/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.common.T3Exception;
import weblogic.common.internal.BootServices;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.T3ClientParams;
import weblogic.kernel.Kernel;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rjvm.MsgAbbrevJVMConnection;
import weblogic.rjvm.RJVMLogger;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.RemoteRequest;
import weblogic.rjvm.ReplyStream;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.t3.srvr.ClientContext;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class BootServicesImpl
implements BootServices,
RemoteInvokable {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String realmName = "weblogicDEFAULT";
    private PrincipalAuthenticator pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)this.realmName, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
    private byte qos;
    private int port;
    private ServerChannel channel;
    private X509Certificate[] peerCertChain = null;
    private static final String OLDBOOTSTRAPREQUEST_QUEUE = "wl_oldBootStrap";
    private WorkManager workMgr;

    private BootServicesImpl() {
        Debug.assertion((this.pa != null ? 1 : 0) != 0, (String)"Security system not initialized");
        this.workMgr = WorkManagerFactory.getInstance().findOrCreate(OLDBOOTSTRAPREQUEST_QUEUE, -1, 8);
    }

    public static void initialize() {
        RJVMManager.getLocalRJVM().getFinder().put(1, (RemoteInvokable)new BootServicesImpl());
    }

    public void setConnectionInfo(MsgAbbrevJVMConnection msgAbbrevJVMConnection) {
        this.qos = msgAbbrevJVMConnection.getQOS();
        this.port = msgAbbrevJVMConnection.getLocalPort();
        this.channel = msgAbbrevJVMConnection.getChannel();
        this.peerCertChain = msgAbbrevJVMConnection.getJavaCertChain();
    }

    public AuthenticatedUser authenticate(UserInfo userInfo, PeerInfo peerInfo) throws RemoteException {
        AuthenticatedUser authenticatedUser = null;
        AuthenticatedSubject authenticatedSubject = null;
        X509Certificate[] x509CertificateArray = this.peerCertChain;
        this.peerCertChain = null;
        if (userInfo instanceof AuthenticatedUser) {
            authenticatedUser = (AuthenticatedUser)userInfo;
        } else {
            Object object;
            if (x509CertificateArray != null) {
                try {
                    object = "X.509";
                    authenticatedSubject = this.pa.assertIdentity((String)object, (Object)x509CertificateArray);
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
            }
            if (authenticatedSubject == null) {
                if (userInfo instanceof DefaultUserInfoImpl) {
                    object = (DefaultUserInfoImpl)userInfo;
                    String string = ((DefaultUserInfoImpl)object).getName();
                    String string2 = ((DefaultUserInfoImpl)object).getPassword();
                    if (string == null || string.length() == 0) {
                        authenticatedSubject = SubjectUtils.getAnonymousSubject();
                    } else {
                        try {
                            SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(string, string2);
                            authenticatedSubject = this.pa.authenticate((CallbackHandler)simpleCallbackHandler);
                        }
                        catch (LoginException loginException) {
                            throw new SecurityException(loginException.getMessage());
                        }
                    }
                } else {
                    throw new SecurityException("Received bad UserInfo: " + userInfo.getClass().getName());
                }
            }
            this.checkAdminPort(authenticatedSubject, userInfo);
            authenticatedUser = authenticatedSubject;
        }
        authenticatedUser.setQOS(this.qos);
        return authenticatedUser;
    }

    private void checkAdminPort(AuthenticatedSubject authenticatedSubject, UserInfo userInfo) {
        if (ChannelHelper.isLocalAdminChannelEnabled() && SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject) && ManagementService.getRuntimeAccess(kernelId).getServer().getAdministrationPort() != this.port && !ChannelHelper.isAdminChannel((ServerChannel)this.channel)) {
            throw new SecurityException("All administrative tasks must go through an Administration Port.");
        }
    }

    public T3ClientParams findOrCreateClientContext(String string, UserInfo userInfo, int n) throws RemoteException {
        throw new InternalError("should never be called");
    }

    public void invoke(RemoteRequest remoteRequest) throws RemoteException {
        try {
            byte by = remoteRequest.readByte();
            switch (by) {
                case 1: {
                    this.authenticate(remoteRequest);
                    break;
                }
                case 2: {
                    this.findOrCreateClientContext(remoteRequest);
                    break;
                }
                default: {
                    throw new AssertionError("Unknown OPCODE: " + by);
                }
            }
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (IOException iOException) {
            throw new UnmarshalException("While providing boot service", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnmarshalException("While providing boot service", classNotFoundException);
        }
    }

    private void authenticate(RemoteRequest remoteRequest) throws IOException, ClassNotFoundException {
        UserInfo userInfo = (UserInfo)remoteRequest.readObject();
        PeerInfo peerInfo = remoteRequest.getPeerInfo();
        BootServicesAuthenticateRequest bootServicesAuthenticateRequest = new BootServicesAuthenticateRequest(this, remoteRequest, userInfo, peerInfo);
        this.workMgr.schedule((Runnable)((Object)bootServicesAuthenticateRequest));
    }

    private void findOrCreateClientContext(RemoteRequest remoteRequest) throws IOException, ClassNotFoundException {
        String string = remoteRequest.readString();
        UserInfo userInfo = (UserInfo)remoteRequest.readObjectWL();
        int n = remoteRequest.readInt();
        byte by = remoteRequest.readByte();
        BootServicesClientContextRequest bootServicesClientContextRequest = new BootServicesClientContextRequest(this, remoteRequest, string, userInfo, n, by);
        this.workMgr.schedule((Runnable)((Object)bootServicesClientContextRequest));
    }

    private void checkServerLock(AuthenticatedUser authenticatedUser) {
        if (SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)((AuthenticatedSubject)authenticatedUser))) {
            return;
        }
        T3Srvr.getT3Srvr().getLockoutManager().checkServerLock();
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    private static class BootServicesClientContextRequest
    extends WorkAdapter {
        BootServicesImpl bootServicesImpl;
        RemoteRequest remoteRequest;
        String workSpace;
        UserInfo userInfo;
        int idleCallbackID;
        byte qos;

        public BootServicesClientContextRequest(BootServicesImpl bootServicesImpl, RemoteRequest remoteRequest, String string, UserInfo userInfo, int n, byte by) {
            this.bootServicesImpl = bootServicesImpl;
            this.remoteRequest = remoteRequest;
            this.workSpace = string;
            this.userInfo = userInfo;
            this.idleCallbackID = n;
            this.qos = by;
        }

        public void run() {
            block5: {
                try {
                    final AuthenticatedUser authenticatedUser = this.bootServicesImpl.authenticate(this.userInfo, this.remoteRequest.getPeerInfo());
                    AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getASFromAU((AuthenticatedUser)authenticatedUser);
                    SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            T3ClientParams t3ClientParams;
                            ClientContext clientContext;
                            try {
                                BootServicesClientContextRequest.this.bootServicesImpl.checkServerLock(authenticatedUser);
                                clientContext = ClientContext.getClientContext(BootServicesClientContextRequest.this.remoteRequest.getOrigin(), BootServicesClientContextRequest.this.workSpace, (UserInfo)authenticatedUser, BootServicesClientContextRequest.this.idleCallbackID, BootServicesClientContextRequest.this.qos);
                                t3ClientParams = clientContext.getParams();
                            }
                            catch (T3Exception t3Exception) {
                                throw new RemoteException("Failed to create client context", t3Exception);
                            }
                            clientContext = BootServicesClientContextRequest.this.remoteRequest.getResponseStream();
                            clientContext.writeObjectWL(t3ClientParams);
                            clientContext.send();
                            return null;
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMessaging()) {
                        RJVMLogger.logDebug2((String)"Execute problem", (Throwable)throwable);
                    }
                    try {
                        this.remoteRequest.getResponseStream().sendThrowable(throwable);
                    }
                    catch (IOException iOException) {
                        RJVMLogger.logDebug2((String)("Failed to deliver error response " + throwable + " to client"), (Throwable)iOException);
                    }
                    if (!(throwable instanceof Error)) break block5;
                    throw (Error)throwable;
                }
            }
        }
    }

    private static class BootServicesAuthenticateRequest
    extends WorkAdapter {
        BootServicesImpl bootServicesImpl;
        RemoteRequest remoteRequest;
        UserInfo userInfo;
        PeerInfo peerInfo;

        public BootServicesAuthenticateRequest(BootServicesImpl bootServicesImpl, RemoteRequest remoteRequest, UserInfo userInfo, PeerInfo peerInfo) {
            this.bootServicesImpl = bootServicesImpl;
            this.remoteRequest = remoteRequest;
            this.userInfo = userInfo;
            this.peerInfo = peerInfo;
        }

        public void run() {
            block5: {
                try {
                    AuthenticatedUser authenticatedUser = this.bootServicesImpl.authenticate(this.userInfo, this.peerInfo);
                    ReplyStream replyStream = this.remoteRequest.getResponseStream();
                    replyStream.writeObject((Object)authenticatedUser);
                    replyStream.send();
                }
                catch (Throwable throwable) {
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMessaging()) {
                        RJVMLogger.logDebug2((String)"Execute problem ", (Throwable)throwable);
                    }
                    try {
                        this.remoteRequest.getResponseStream().sendThrowable(throwable);
                    }
                    catch (IOException iOException) {
                        RJVMLogger.logDebug2((String)("Failed to deliver error response " + throwable + " to client"), (Throwable)iOException);
                    }
                    if (!(throwable instanceof Error)) break block5;
                    throw (Error)throwable;
                }
            }
        }
    }
}

