/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.util.Hashtable;
import weblogic.common.T3Exception;
import weblogic.common.internal.T3ClientParams;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.Kernel;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.provider.ManagementService;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.RemoteRequest;
import weblogic.rmi.internal.OIDManager;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.t3.srvr.ClientMsg;
import weblogic.t3.srvr.ClientRequest;
import weblogic.t3.srvr.ExecutionContext;
import weblogic.t3.srvr.RemoteClientContext;
import weblogic.t3.srvr.Scavengable;
import weblogic.t3.srvr.Scavenger;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.utils.AssertionError;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public final class ClientContext
extends ExecutionContext
implements RemoteClientContext,
RemoteInvokable,
Runnable,
Scavengable,
PeerGoneListener {
    private AuthenticatedUser user;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugLogger debugConnection = DebugLogger.getDebugLogger((String)"DebugConnection");
    private static Hashtable cliConTable = new Hashtable();
    private static final String NAME_SEPARATOR = ".";
    private static int nextIncarnation = 0;
    private static Hashtable ccNameTable = new Hashtable();
    private static Object tableLock = new Object();
    private RJVM rjvm = null;
    private String ccName;
    private byte QOS;
    private int idleCallbackID;
    private ClientMsg cm;
    private int ccID = -1;
    private long disconnectNoticed;
    private boolean hardDisconnectOccurred;
    private long lastWorkPerformed;
    private int workQueueDepth;
    private Object workQueueDepthLock = new Object();
    private boolean dead;
    private static int defHDTM = 0;
    private static int defSDTM = 0;
    private static int defISDTM = -1;

    private static void addEntry(String string, ClientContext clientContext) {
        cliConTable.put(string, clientContext);
    }

    private static void removeEntry(String string) {
        cliConTable.remove(string);
    }

    private static ClientContext findContext(String string) {
        return (ClientContext)cliConTable.get(string);
    }

    private static String makeWSIDSuffix() {
        String string = nextIncarnation + NAME_SEPARATOR + TimeEventGenerator.getLaunch().getTime();
        ++nextIncarnation;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientContext getClientContext(RJVM rJVM, String string, UserInfo userInfo, int n, byte by) throws T3Exception {
        Object object = tableLock;
        synchronized (object) {
            ClientContext clientContext;
            if (string == null || string.equals("")) {
                clientContext = new ClientContext(null, null, by);
            } else if (ClientContext.isWSID(string)) {
                clientContext = ClientContext.findContext(string);
                if (clientContext == null) {
                    throw new T3Exception("Attempt to connect to workspace: '" + string + "' which doesn't exist");
                }
            } else {
                String string2 = userInfo.getName() + NAME_SEPARATOR + string;
                clientContext = (ClientContext)ccNameTable.get(string2);
                if (clientContext == null) {
                    clientContext = new ClientContext(string2, string, by);
                    ccNameTable.put(string2, clientContext);
                }
            }
            clientContext.bind(rJVM, n);
            return clientContext;
        }
    }

    public int hashCode() {
        return this.ccID;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public AuthenticatedUser getUser() {
        return this.user;
    }

    public AuthenticatedSubject getSubject() {
        return SecurityServiceManager.getSealedSubjectFromWire((AuthenticatedSubject)kernelId, (AuthenticatedUser)this.getUser());
    }

    RJVM getRJVM() {
        return this.rjvm;
    }

    private ClientContext(String string, String string2, byte by) throws T3Exception {
        super(ClientContext.makeWSIDSuffix());
        this.ccName = string;
        this.QOS = by;
        this.user = this.getCurrentSubject();
        this.cm = new ClientMsg();
        this.cm.wsName = string2;
        this.cm.serverName = ManagementService.getRuntimeAccess(kernelId).getServer().getName();
        this.disconnectNoticed = 0L;
        this.hardDisconnectOccurred = false;
        this.lastWorkPerformed = TimeEventGenerator.getCurrentMins() + 1L;
        this.workQueueDepth = 0;
        this.dead = false;
        ClientContext.addEntry(this.getID(), this);
        Scavenger.addScavengable(this.getID(), this);
        this.ccID = OIDManager.getInstance().getNextObjectID();
        RJVMManager.getLocalRJVM().getFinder().put(this.ccID, (RemoteInvokable)this);
    }

    private boolean isBound() {
        return this.rjvm != null;
    }

    private void bind(RJVM rJVM, int n) throws T3Exception {
        if (this.isBound()) {
            throw new T3Exception("Attempt to bind to ClientContext: '" + this + "' that is already bound");
        }
        if (this.dead) {
            throw new T3Exception("Attempt to bind to ClientContext: '" + this + "' that is dead");
        }
        this.rjvm = rJVM;
        this.idleCallbackID = n;
        this.disconnectNoticed = 0L;
        this.hardDisconnectOccurred = false;
        rJVM.addPeerGoneListener((PeerGoneListener)this);
    }

    private void unbind() {
        if (!this.isBound()) {
            T3SrvrLogger.logAttemptUnbindUnboundClientContext((String)this.toString());
            return;
        }
        this.rjvm.removePeerGoneListener((PeerGoneListener)this);
        this.rjvm = null;
        if (this.disconnectNoticed == 0L) {
            this.disconnectNoticed = TimeEventGenerator.getCurrentMins();
        }
    }

    public String toString() {
        return "ClientContext - id: '" + this.getID() + "', bound: '" + this.isBound() + "', dead: '" + this.dead + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incWorkQueueDepth() {
        Object object = this.workQueueDepthLock;
        synchronized (object) {
            ++this.workQueueDepth;
        }
        this.lastWorkPerformed = TimeEventGenerator.getCurrentMins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decWorkQueueDepth() {
        Object object = this.workQueueDepthLock;
        synchronized (object) {
            --this.workQueueDepth;
        }
    }

    private void enqueueWork(final Runnable runnable) {
        if (this.dead) {
            throw new AssertionError("Connection: '" + this + "' attempted to enqueue work: '" + runnable + "' when it is dead.");
        }
        this.incWorkQueueDepth();
        if (SubjectUtils.doesUserHaveAnyAdminRoles((AuthenticatedSubject)this.getSubject())) {
            WorkManagerFactory.getInstance().getSystem().schedule(runnable);
        } else {
            WorkManagerFactory.getInstance().getDefault().schedule((Runnable)new WorkAdapter(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
        }
    }

    private boolean checkWorkQueueDepth(int n) {
        if (this.workQueueDepth == n) {
            return true;
        }
        if (this.workQueueDepth > n) {
            if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
                T3SrvrLogger.logCCHasPendingExecuteRequests((String)this.toString(), (int)(this.workQueueDepth - n));
            }
        } else if (this.workQueueDepth < 0) {
            if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
                T3SrvrLogger.logCCHasNegativeWorkQueueDepth((String)this.toString(), (int)this.workQueueDepth);
            }
            this.workQueueDepth = 0;
        }
        return false;
    }

    public void invoke(RemoteRequest remoteRequest) throws RemoteException {
        Object object;
        String string;
        try {
            string = remoteRequest.readAbbrevString();
            object = remoteRequest.readObjectWL();
        }
        catch (IOException iOException) {
            throw new UnmarshalException("", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnmarshalException("", classNotFoundException);
        }
        if ("XZZdisconnectZZX".equals(string)) {
            this.requestKill();
        } else {
            this.enqueueWork(new ClientRequest(string, object, this, remoteRequest));
        }
    }

    public void setHardDisconnectTimeoutMins(int n) {
        this.cm.hardDisconnectTimeoutMins = n;
    }

    public void setSoftDisconnectTimeoutMins(int n) {
        this.cm.softDisconnectTimeoutMins = n;
    }

    public void setIdleDisconnectTimeoutMins(int n) {
        this.cm.idleSoftDisconnectTimeoutMins = n;
    }

    public void setVerbose(boolean bl) {
        this.cm.verbose = bl;
    }

    public T3ClientParams getParams() {
        T3ClientParams t3ClientParams = new T3ClientParams();
        t3ClientParams.verbose = Kernel.DEBUG && debugConnection.isDebugEnabled();
        t3ClientParams.QOS = this.QOS;
        t3ClientParams.hardDisconnectTimeoutMins = this.cm.hardDisconnectTimeoutMins;
        t3ClientParams.softDisconnectTimeoutMins = this.cm.softDisconnectTimeoutMins;
        t3ClientParams.idleSoftDisconnectTimeoutMins = this.cm.idleSoftDisconnectTimeoutMins;
        t3ClientParams.serverName = this.cm.serverName;
        t3ClientParams.wsName = this.cm.wsName;
        t3ClientParams.wsID = this.getID();
        t3ClientParams.ccID = this.ccID;
        t3ClientParams.rcc = this;
        t3ClientParams.user = this.getCurrentSubject();
        return t3ClientParams;
    }

    private AuthenticatedUser getCurrentSubject() {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
    }

    private void sendUnsolicitedData(int n, Object object) throws IOException {
        if (!this.isBound()) {
            return;
        }
        try {
            MsgAbbrevOutputStream msgAbbrevOutputStream = this.rjvm.getRequestStream(null);
            msgAbbrevOutputStream.writeObjectWL(object);
            msgAbbrevOutputStream.sendOneWay(n, this.QOS);
        }
        catch (IOException iOException) {
            T3SrvrLogger.logFailedSendingUnsolicitedMessage((String)object.toString(), (Exception)iOException);
            throw iOException;
        }
    }

    public void peerGone(PeerGoneEvent peerGoneEvent) {
        if (this.dead) {
            return;
        }
        if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
            T3SrvrLogger.logConnectionUnexpectedlyLostHardDisconnect((String)this.toString(), (Exception)peerGoneEvent.getReason());
        }
        this.hardDisconnectOccurred = true;
        this.requestKill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scavenge(int n) throws IOException {
        Object object = tableLock;
        synchronized (object) {
            if (this.dead) {
                return;
            }
            if (!this.isBound()) {
                this.dieIfTimedOut(0);
                return;
            }
        }
        if (this.checkIdleDisconnectTimeout() && this.checkWorkQueueDepth(0)) {
            if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
                T3SrvrLogger.logTimingOutClientContextOnIdle((String)this.toString());
            }
            this.cm.cmd = (byte)8;
            this.cm.reason = "Removing client because of idle disconnect timeout";
            this.sendUnsolicitedData(this.idleCallbackID, this.cm);
            this.requestKill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestKill() {
        Object object = tableLock;
        synchronized (object) {
            if (!this.isBound()) {
                if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
                    T3SrvrLogger.logIgnoringCCDeathRequest((String)this.toString());
                }
                return;
            }
            this.unbind();
            if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
                T3SrvrLogger.logSchedulingClientContextDeath((String)this.toString());
            }
            this.enqueueWork(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        Object object = tableLock;
        synchronized (object) {
            if (this.dead) {
                return;
            }
            if (!this.isBound()) {
                this.dieIfTimedOut(1);
            }
            this.decWorkQueueDepth();
        }
    }

    private void dieIfTimedOut(int n) {
        if ((this.hardDisconnectOccurred && this.checkHardDisconnectTimeout() || !this.hardDisconnectOccurred && this.checkSoftDisconnectTimeout()) && this.checkWorkQueueDepth(n)) {
            if (this.hardDisconnectOccurred) {
                if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
                    T3SrvrLogger.logRemovingClientContextHardDisconnect((String)this.toString());
                }
            } else if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
                T3SrvrLogger.logRemovingClientContextSoftDisconnect((String)this.toString());
            }
            this.dead = true;
            if (this.ccName != null) {
                ccNameTable.remove(this.ccName);
            }
            ClientContext.removeEntry(this.getID());
            Scavenger.removeScavengable(this.getID());
            RJVMManager.getLocalRJVM().getFinder().remove(this.ccID);
            this.clear();
        }
    }

    private boolean checkSoftDisconnectTimeout() {
        int n = this.cm.softDisconnectTimeoutMins;
        if (n == -2) {
            n = defSDTM;
        }
        if (n == -1) {
            return false;
        }
        int n2 = TimeEventGenerator.deltaMins(this.disconnectNoticed);
        if (n2 >= n) {
            return true;
        }
        if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
            T3SrvrLogger.logSoftDisconnectPendingMins((int)n);
        }
        return false;
    }

    private boolean checkHardDisconnectTimeout() {
        int n = this.cm.hardDisconnectTimeoutMins;
        if (n == -2) {
            n = defHDTM;
        }
        if (n == -1) {
            return false;
        }
        int n2 = TimeEventGenerator.deltaMins(this.disconnectNoticed);
        if (n2 >= n) {
            return true;
        }
        if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
            T3SrvrLogger.logHardDisconnectPendingMins((int)n);
        }
        return false;
    }

    private boolean checkIdleDisconnectTimeout() {
        int n = this.cm.idleSoftDisconnectTimeoutMins;
        if (n == -2) {
            n = defISDTM;
        }
        if (n == -1) {
            return false;
        }
        int n2 = TimeEventGenerator.deltaMins(this.lastWorkPerformed);
        if (n2 >= n) {
            return true;
        }
        if (Kernel.DEBUG && debugConnection.isDebugEnabled()) {
            T3SrvrLogger.logIdleDisconnectPendingMins((int)n);
        }
        return false;
    }
}

