/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.Manufacturable;

public final class ClientMsg
implements Manufacturable,
Externalizable {
    private static final long serialVersionUID = -8434373145364482668L;
    public boolean verbose = false;
    public byte cmd = 0;
    public int hardDisconnectTimeoutMins = -2;
    public int softDisconnectTimeoutMins = -2;
    public int idleSoftDisconnectTimeoutMins = -2;
    public int notifyChannel = -1;
    public String serverName;
    public String wsName;
    public String reason;
    public static final byte CMD_NONE = 0;
    public static final byte CMD_SET = 1;
    public static final byte CMD_GET = 6;
    public static final byte CMD_DISCONNECTED = 8;
    public static final byte CMD_NOTIFYCHANNEL = 9;
    public static final String[] CMD_TEXT = new String[]{"NONE", "SET", "LOG", "STORE", "FETCH", "REMOVE", "GET", "GETPROP", "DISCONNECTED", "NOTIFYCHANNEL"};
    public static final int DISCONNECT_MIN = -2;
    public static final int DISCONNECT_TIMEOUT_DEFAULT = -2;
    public static final int DISCONNECT_TIMEOUT_NEVER = -1;

    public void initialize() {
    }

    public void destroy() {
    }

    public String toString() {
        String string = "[CliMsg: Cmd=" + CMD_TEXT[this.cmd] + " ";
        switch (this.cmd) {
            case 1: 
            case 6: {
                return string + "n/h/s/i/v=" + this.wsName + "/" + this.hardDisconnectTimeoutMins + "/" + this.softDisconnectTimeoutMins + "/" + this.idleSoftDisconnectTimeoutMins + "/" + this.verbose + "]";
            }
        }
        return string + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
        wLObjectOutput.writeByte((int)this.cmd);
        switch (this.cmd) {
            case 9: {
                wLObjectOutput.writeInt(this.notifyChannel);
                break;
            }
            case 8: {
                wLObjectOutput.writeString(this.reason);
            }
            case 1: 
            case 6: {
                wLObjectOutput.writeInt(this.hardDisconnectTimeoutMins);
                wLObjectOutput.writeInt(this.softDisconnectTimeoutMins);
                wLObjectOutput.writeInt(this.idleSoftDisconnectTimeoutMins);
                wLObjectOutput.writeString(this.wsName);
                wLObjectOutput.writeBoolean(this.verbose);
                wLObjectOutput.writeString(this.serverName);
                break;
            }
            default: {
                throw new IOException("No such cmd: " + this.cmd);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
        this.cmd = wLObjectInput.readByte();
        switch (this.cmd) {
            case 9: {
                this.notifyChannel = wLObjectInput.readInt();
                break;
            }
            case 8: {
                this.reason = wLObjectInput.readString();
            }
            case 1: 
            case 6: {
                this.hardDisconnectTimeoutMins = wLObjectInput.readInt();
                this.softDisconnectTimeoutMins = wLObjectInput.readInt();
                this.idleSoftDisconnectTimeoutMins = wLObjectInput.readInt();
                this.wsName = wLObjectInput.readString();
                this.verbose = wLObjectInput.readBoolean();
                this.serverName = wLObjectInput.readString();
                break;
            }
            default: {
                throw new IOException("No such cmd: " + this.cmd);
            }
        }
    }
}

