/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import weblogic.common.T3Exception;
import weblogic.common.T3Executable;
import weblogic.common.T3ExecutableLazy;
import weblogic.common.internal.Manufacturable;
import weblogic.common.internal.ObjectFactory;
import weblogic.kernel.T3SrvrLogger;
import weblogic.rjvm.RemoteRequest;
import weblogic.rjvm.ReplyStream;
import weblogic.rmi.MarshalException;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.t3.srvr.ClientContext;

class ClientRequest
implements Runnable {
    private String clss;
    private Object payload;
    private ClientContext cc;
    private RemoteRequest req;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    ClientRequest(String string, Object object, ClientContext clientContext, RemoteRequest remoteRequest) {
        this.clss = string;
        this.payload = object;
        this.cc = clientContext;
        this.req = remoteRequest;
    }

    private void tryToSendObject(Object object) throws IOException {
        ReplyStream replyStream = this.req.getResponseStream();
        try {
            replyStream.writeObjectWL(object);
            replyStream.send();
        }
        catch (IOException iOException) {
            MarshalException marshalException = new MarshalException("", (Throwable)iOException);
            T3SrvrLogger.logSendObjectMarshalFailedIO((Exception)iOException);
            this.req.getResponseStream().sendThrowable((Throwable)marshalException);
        }
        catch (RuntimeException runtimeException) {
            MarshalException marshalException = new MarshalException("", (Throwable)runtimeException);
            T3SrvrLogger.logSendObjectMarshalFailedRTE((Exception)runtimeException);
            this.req.getResponseStream().sendThrowable((Throwable)marshalException);
        }
    }

    public void run() {
        AuthenticatedSubject authenticatedSubject = this.cc.getSubject();
        Manufacturable manufacturable = null;
        ServerHelper.setClientInfo((EndPoint)this.cc.getRJVM(), null);
        try {
            if (this.clss != null) {
                manufacturable = ObjectFactory.get(this.clss);
                if (manufacturable instanceof T3Executable) {
                    Object object = null;
                    Throwable throwable = null;
                    try {
                        final T3Executable t3Executable = (T3Executable)manufacturable;
                        object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return t3Executable.execute(ClientRequest.this.cc, ClientRequest.this.payload);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throwable = privilegedActionException.getException();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    if (throwable != null) {
                        if (!(throwable instanceof T3Exception || throwable instanceof Error || throwable instanceof RuntimeException)) {
                            throwable = new T3Exception("Exception executing a client request", throwable);
                        }
                        this.req.getResponseStream().sendThrowable(throwable);
                        return;
                    }
                    this.tryToSendObject(object);
                    return;
                }
                if (manufacturable instanceof T3ExecutableLazy) {
                    try {
                        final T3ExecutableLazy t3ExecutableLazy = (T3ExecutableLazy)manufacturable;
                        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                t3ExecutableLazy.executeLazy(ClientRequest.this.cc, ClientRequest.this.payload);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        T3SrvrLogger.logFailureOfT3ExecutableLazy((Throwable)privilegedActionException.getException());
                    }
                    catch (Throwable throwable) {
                        T3SrvrLogger.logFailureOfT3ExecutableLazy((Throwable)throwable);
                    }
                    return;
                }
            }
            T3SrvrLogger.logExecutionClassNoRetrieveT3Exec((String)this.clss);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            try {
                this.req.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.req = null;
            this.cc.decWorkQueueDepth();
            if (manufacturable != null) {
                ObjectFactory.put(manufacturable);
            }
        }
    }
}

