/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import weblogic.health.HealthMonitorService;
import weblogic.health.LowMemoryNotificationService;
import weblogic.health.MemoryEvent;
import weblogic.health.MemoryListener;
import weblogic.kernel.Kernel;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.configuration.OverloadProtectionMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ExecuteQueueRuntimeMBean;
import weblogic.management.runtime.ExecuteThread;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.ThreadPoolRuntimeMBean;
import weblogic.platform.GCMonitorThread;
import weblogic.platform.VM;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.io.Chunk;
import weblogic.work.WorkManagerFactory;

public final class CoreHealthService
extends AbstractServerService
implements MemoryListener {
    private static final String SUBSYSTEM_NAME = "core";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Timer healthTimer;
    private static ServerRuntimeMBean serverRuntimeMBean;
    private static OverloadProtectionMBean olp;

    public void start() throws ServiceFailureException {
        try {
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
            serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
            HealthMonitorService.register("ServerRuntime", serverRuntimeMBean, true);
            olp = serverMBean.getOverloadProtection();
            int n = olp.getFreeMemoryPercentHighThreshold();
            int n2 = olp.getFreeMemoryPercentLowThreshold();
            GCMonitorThread.init();
            LowMemoryNotificationService.initialize(n2, n);
            LowMemoryNotificationService.addMemoryListener(new CoreHealthService());
            long l = (long)serverMBean.getStuckThreadTimerInterval() * 1000L;
            long l2 = this.getConfiguredStuckThreadMaxTime(serverMBean);
            TimerManager timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.health.ThreadMonitor", WorkManagerFactory.getInstance().getSystem());
            this.healthTimer = timerManager.schedule((TimerListener)new ThreadMonitoringTimer(l2, l), 0L, l);
        }
        catch (Exception exception) {
            T3SrvrLogger.logWarnRegisterHealthMonitor((String)"ServerRuntime", (Exception)exception);
            throw new ServiceFailureException((Throwable)exception);
        }
    }

    private long getConfiguredStuckThreadMaxTime(ServerMBean serverMBean) {
        return serverMBean.getOverloadProtection().getServerFailureTrigger() != null ? (long)serverMBean.getOverloadProtection().getServerFailureTrigger().getMaxStuckThreadTime() * 1000L : (long)serverMBean.getStuckThreadMaxTime() * 1000L;
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public void halt() throws ServiceFailureException {
        try {
            HealthMonitorService.unregister("ServerRuntime");
            if (this.healthTimer != null) {
                this.healthTimer.cancel();
            }
        }
        catch (Exception exception) {
            T3SrvrLogger.logWarnUnregisterHealthMonitor((String)"ServerRuntime", (Exception)exception);
        }
    }

    public void memoryChanged(final MemoryEvent memoryEvent) {
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                if (memoryEvent.getEventType() == 1) {
                    serverRuntimeMBean.setHealthState(4, "server is low on memory");
                    Chunk.signalLowMemoryCondition();
                }
                if (memoryEvent.getEventType() == 0) {
                    serverRuntimeMBean.setHealthState(0, null);
                    Chunk.clearLowMemoryCondition();
                }
                return null;
            }
        });
    }

    private static final class ThreadMonitoringTimer
    implements TimerListener {
        private final long stuckThreadMaxTime;
        private final long timerInterval;
        private boolean alreadyDeadlocked = false;

        ThreadMonitoringTimer(long l, long l2) {
            this.stuckThreadMaxTime = l;
            this.timerInterval = l2;
        }

        public void timerExpired(Timer timer) {
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    ThreadMonitoringTimer.this.checkDeadlockedThreads();
                    ThreadMonitoringTimer.this.checkStuckThreads();
                    return null;
                }
            });
        }

        private void checkDeadlockedThreads() {
            if (this.alreadyDeadlocked) {
                return;
            }
            String string = VM.getVM().dumpDeadlockedThreads();
            if (string == null) {
                return;
            }
            T3SrvrLogger.logDeadlockedThreads((String)string);
            serverRuntimeMBean.setHealthState(3, "Thread deadlock detected.");
            HealthMonitorService.subsystemFailed(CoreHealthService.SUBSYSTEM_NAME, "Thread deadlock detected");
            this.alreadyDeadlocked = true;
        }

        private void checkStuckThreads() {
            Object object;
            boolean bl;
            boolean bl2 = true;
            ExecuteQueueRuntimeMBean[] executeQueueRuntimeMBeanArray = serverRuntimeMBean.getExecuteQueueRuntimes();
            List list = Kernel.getApplicationDispatchPolicies();
            for (int i = 0; i < executeQueueRuntimeMBeanArray.length; ++i) {
                if (!list.contains(executeQueueRuntimeMBeanArray[i].getName()) || (bl = this.logStuckThreads((object = executeQueueRuntimeMBeanArray[i]).getStuckExecuteThreads(), object.getExecuteThreadTotalCount(), object.getName()))) continue;
                bl2 = false;
            }
            ThreadPoolRuntimeMBean threadPoolRuntimeMBean = serverRuntimeMBean.getThreadPoolRuntime();
            if (threadPoolRuntimeMBean != null && !(bl = this.logStuckThreads((ExecuteThread[])(object = threadPoolRuntimeMBean.getStuckExecuteThreads()), threadPoolRuntimeMBean.getExecuteThreadTotalCount(), threadPoolRuntimeMBean.getName()))) {
                bl2 = false;
            }
            if (bl2) {
                HealthMonitorService.subsystemFailed(CoreHealthService.SUBSYSTEM_NAME, "All execute queues and the self-tuning thread pool are stuck");
            }
        }

        private boolean logStuckThreads(ExecuteThread[] executeThreadArray, int n, String string) {
            if (executeThreadArray == null) {
                return false;
            }
            long l = System.currentTimeMillis();
            for (int i = 0; i < executeThreadArray.length; ++i) {
                ExecuteThread executeThread = executeThreadArray[i];
                long l2 = l - executeThread.getCurrentRequestStartTime();
                if (!this.logStuckThreadMessage(l2)) continue;
                String string2 = VM.getVM().threadDumpAsString(executeThread.getExecuteThread());
                T3SrvrLogger.logWarnPossibleStuckThread((String)executeThread.getName(), (long)(l2 / 1000L), (String)executeThread.getCurrentRequest(), (long)(this.stuckThreadMaxTime / 1000L), (String)string2);
            }
            if (n == executeThreadArray.length) {
                serverRuntimeMBean.setHealthState(1, "All Threads in the queue " + string + " are stuck.");
                return true;
            }
            if (serverRuntimeMBean.getHealthState().getState() == 1) {
                serverRuntimeMBean.setHealthState(0, "");
            }
            return false;
        }

        private boolean logStuckThreadMessage(long l) {
            return l > this.stuckThreadMaxTime && l < this.stuckThreadMaxTime + 2L * this.timerInterval;
        }
    }
}

