/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;
import weblogic.server.channels.DynamicListenThreadManager;
import weblogic.t3.srvr.ListenerService;
import weblogic.t3.srvr.SetUIDRendezvous;

final class EnableListenersHelper {
    private static final boolean DEBUG = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean started;

    private EnableListenersHelper() {
    }

    static EnableListenersHelper getInstance() {
        return Factory.THE_ONE;
    }

    synchronized void start() throws ServiceFailureException {
        if (this.started) {
            return;
        }
        this.started = true;
        if (!ManagementService.getRuntimeAccess(kernelId).getServer().getListenersBindEarly()) {
            ListenerService.getInstance().bindListeners();
        }
        DynamicListenThreadManager.getInstance().enableListeners();
        SetUIDRendezvous.finish();
        EnableListenersHelper.logStartedMessage();
    }

    void stop() {
        this.halt();
    }

    synchronized void halt() {
        if (!this.started) {
            return;
        }
        this.started = false;
        DynamicListenThreadManager.getInstance().stop();
    }

    private static boolean isClassCacheTurnedOn() {
        return ClassLoader.getSystemClassLoader().getClass().getName().equals("com.oracle.classloader.PolicyClassLoader");
    }

    private static void logStartedMessage() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        String string = runtimeAccess.getServerName();
        String string2 = runtimeAccess.getDomainName();
        boolean bl = runtimeAccess.getDomain().isProductionModeEnabled();
        if (runtimeAccess.isAdminServer()) {
            if (bl) {
                T3SrvrLogger.logStartedAdminServerProduction((String)string, (String)string2);
            } else {
                T3SrvrLogger.logStartedAdminServerDevelopment((String)string, (String)string2);
            }
        } else if (!runtimeAccess.isAdminServerAvailable()) {
            if (bl) {
                T3SrvrLogger.logStartedIndependentManagedServerProdMode((String)string, (String)string2);
            } else {
                T3SrvrLogger.logStartedIndependentManagedServerDevMode((String)string, (String)string2);
            }
        } else if (bl) {
            T3SrvrLogger.logStartedManagedServerProduction((String)string, (String)string2);
        } else {
            T3SrvrLogger.logStartedManagedServerDevelopment((String)string, (String)string2);
        }
        if (EnableListenersHelper.isClassCacheTurnedOn() && bl) {
            T3SrvrLogger.logClassCacheEnabledWarning((String)string, (String)string2);
        }
    }

    private static void debug(String string) {
        System.out.println("<LISTENER_DEBUG>" + string);
    }

    private static final class Factory {
        static final EnableListenersHelper THE_ONE = new EnableListenersHelper();

        private Factory() {
        }
    }
}

