/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.server.channels.AdminPortService;
import weblogic.t3.srvr.EnableListenersHelper;
import weblogic.t3.srvr.T3Srvr;

public final class EnableListenersIfAdminChannelAbsentService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        if (EnableListenersIfAdminChannelAbsentService.isRequired()) {
            EnableListenersHelper.getInstance().start();
        }
    }

    public static boolean isRequired() {
        return !AdminPortService.getInstance().listenersBound() && !EnableListenersIfAdminChannelAbsentService.startInRunningState();
    }

    public static boolean isOpenForManagementConnectionsEarly() {
        return AdminPortService.getInstance().listenersBound() || EnableListenersIfAdminChannelAbsentService.isRequired();
    }

    public static boolean startInRunningState() {
        if (T3Srvr.getT3Srvr().isAbortStartupAfterAdminState()) {
            return false;
        }
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getStartupMode();
        return string == null || "RUNNING".equalsIgnoreCase(string);
    }

    public void stop() {
        EnableListenersHelper.getInstance().stop();
    }

    public void halt() {
        EnableListenersHelper.getInstance().halt();
    }
}

