/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import weblogic.server.ServerLogger;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.StackTraceUtils;

class GracefulShutdownRequest
implements Runnable {
    private Exception exception;
    private boolean isCompleted = false;
    private Object syncObj = new Object();
    private boolean ignoreSessions = false;
    private int destinationState;

    GracefulShutdownRequest(boolean bl) {
        this.ignoreSessions = bl;
        this.destinationState = 0;
    }

    GracefulShutdownRequest(boolean bl, int n) {
        this.ignoreSessions = bl;
        this.destinationState = n;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.destinationState == 17) {
                T3Srvr.getT3Srvr().gracefulSuspend(this.ignoreSessions);
            } else {
                T3Srvr.getT3Srvr().gracefulShutdown(this.ignoreSessions);
            }
        }
        catch (RuntimeException runtimeException) {
            ServerLogger.logServerRuntimeError((String)runtimeException.toString());
            ServerLogger.logServerRuntimeError((String)StackTraceUtils.throwable2StackTrace((Throwable)runtimeException));
            this.exception = runtimeException;
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        this.isCompleted = true;
        Object object = this.syncObj;
        synchronized (object) {
            this.syncObj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(int n) {
        if (!this.isCompleted) {
            Object object = this.syncObj;
            synchronized (object) {
                if (!this.isCompleted) {
                    try {
                        this.syncObj.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

