/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import com.bea.jvm.CPU;
import com.bea.jvm.JVM;
import com.bea.jvm.JVMFactory;
import com.bea.jvm.MemorySystem;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.ProfilingSystem;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JRockitRuntimeMBean;
import weblogic.management.utils.NotFoundException;
import weblogic.t3.srvr.JVMRuntime;

public class JRockitRuntime
extends JVMRuntime
implements JRockitRuntimeMBean {
    private JVM theJVM = JVMFactory.getJVM();

    public double getAllProcessorsAverageLoad() {
        List list = this.theJVM.getMachine().getCPUs();
        if (list.size() < 1) {
            return 0.0;
        }
        Iterator iterator = list.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            CPU cPU = (CPU)iterator.next();
            d += cPU.getLoad();
        }
        return d / (double)list.size();
    }

    public int getNumberOfProcessors() {
        return this.theJVM.getMachine().getCPUs().size();
    }

    public double getJvmProcessorLoad() {
        return this.theJVM.getJVMLoad();
    }

    public String getJVMDescription() {
        return this.theJVM.getDescription();
    }

    public String getVendor() {
        return this.theJVM.getVendor();
    }

    public String getVersion() {
        return this.theJVM.getVersion();
    }

    public int getNumberOfDaemonThreads() {
        return this.theJVM.getThreadSystem().getDaemonThreadCount();
    }

    public int getTotalNumberOfThreads() {
        return this.theJVM.getThreadSystem().getTotalThreadCount();
    }

    public Collection getThreadSnapShots() {
        return this.theJVM.getThreadSystem().getThreadSnapshots();
    }

    public String getThreadStackDump() {
        return this.theJVM.getThreadSystem().getThreadStackDump();
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.theJVM.getStartTime();
    }

    public long getFreeHeap() {
        MemorySystem memorySystem = this.theJVM.getMemorySystem();
        return memorySystem.getTotalHeapSize() - memorySystem.getUsedHeapSize();
    }

    public long getFreePhysicalMemory() {
        return this.theJVM.getMachine().getPhysicalMemory().getTotalMemory() - this.theJVM.getMachine().getPhysicalMemory().getUsedMemory();
    }

    public long getTotalHeap() {
        return this.theJVM.getMemorySystem().getTotalHeapSize();
    }

    public long getTotalPhysicalMemory() {
        return this.theJVM.getMachine().getPhysicalMemory().getTotalMemory();
    }

    public long getTotalNurserySize() {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().getNurserySize();
        }
        catch (NotAvailableException notAvailableException) {
            return 0L;
        }
    }

    public long getUsedHeap() {
        return this.theJVM.getMemorySystem().getUsedHeapSize();
    }

    public long getUsedPhysicalMemory() {
        return this.theJVM.getMachine().getPhysicalMemory().getUsedMemory();
    }

    public long getMaxHeapSize() {
        return this.theJVM.getMemorySystem().getMaxHeapSize();
    }

    public List getCPUs() throws NotFoundException {
        try {
            return this.theJVM.getMachine().getCPUs();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public Collection getHardwareComponents() throws NotFoundException {
        try {
            return this.theJVM.getMachine().getHardwareComponents();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public Collection getNICs() throws NotFoundException {
        try {
            return this.theJVM.getMachine().getNICs();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public boolean isExceptionCountEnabled(Class clazz) throws ClassCastException {
        return this.theJVM.getProfilingSystem().isExceptionCountEnabled(clazz);
    }

    public String getGcAlgorithm() {
        return this.theJVM.getMemorySystem().getGarbageCollector().getDescription();
    }

    public long getTotalGarbageCollectionCount() {
        return this.theJVM.getMemorySystem().getGarbageCollector().getTotalGarbageCollectionCount();
    }

    public long getLastGCEnd() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().getLastGCEnd();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public long getLastGCStart() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().getLastGCStart();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public long getTotalGarbageCollectionTime() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().getTotalGarbageCollectionTime();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public boolean isGCHandlesCompaction() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().hasCompaction();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public boolean isConcurrent() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().isConcurrent();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public boolean isGenerational() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().isGenerational();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public boolean isIncremental() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().isIncremental();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public boolean isParallel() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().isParallel();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public void setPauseTimeTarget(long l) throws NotFoundException {
        try {
            this.theJVM.getMemorySystem().getGarbageCollector().setPauseTimeTarget(l);
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public long getPauseTimeTarget() throws NotFoundException {
        try {
            return this.theJVM.getMemorySystem().getGarbageCollector().getPauseTimeTarget();
        }
        catch (NotAvailableException notAvailableException) {
            throw new NotFoundException(notAvailableException.getMessage());
        }
    }

    public long getMethodTiming(Method method) throws NotFoundException {
        try {
            return this.theJVM.getProfilingSystem().getTiming(method);
        }
        catch (Throwable throwable) {
            throw new NotFoundException(throwable.getMessage());
        }
    }

    public long getConstructorTiming(Constructor constructor) {
        return this.theJVM.getProfilingSystem().getTiming(constructor);
    }

    public boolean isMethodInvocationCountEnabled(Method method) throws NotFoundException {
        try {
            return this.theJVM.getProfilingSystem().isInvocationCountEnabled(method);
        }
        catch (Throwable throwable) {
            throw new NotFoundException(throwable.getMessage());
        }
    }

    public boolean isConstructorInvocationCountEnabled(Constructor constructor) {
        return this.theJVM.getProfilingSystem().isInvocationCountEnabled(constructor);
    }

    public boolean isMethodTimingEnabled(Method method) throws NotFoundException {
        try {
            return this.theJVM.getProfilingSystem().isTimingEnabled(method);
        }
        catch (Throwable throwable) {
            throw new NotFoundException(throwable.getMessage());
        }
    }

    public boolean isConstructorTimingEnabled(Constructor constructor) {
        return this.theJVM.getProfilingSystem().isTimingEnabled(constructor);
    }

    public long getExceptionCount(Class clazz) throws ClassCastException {
        return this.theJVM.getProfilingSystem().getExceptionCount(clazz);
    }

    public long getMethodInvocationCount(Method method) throws NotFoundException {
        try {
            ProfilingSystem profilingSystem = this.theJVM.getProfilingSystem();
            return profilingSystem.getInvocationCount(method);
        }
        catch (Throwable throwable) {
            throw new NotFoundException(throwable.getMessage());
        }
    }

    public long getConstructorInvocationCount(Constructor constructor) throws NotFoundException {
        try {
            ProfilingSystem profilingSystem = this.theJVM.getProfilingSystem();
            return profilingSystem.getInvocationCount(constructor);
        }
        catch (Throwable throwable) {
            throw new NotFoundException(throwable.getMessage());
        }
    }
}

