/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import java.util.Locale;
import weblogic.health.HealthLogger;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.JVMRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.platform.GCListener;
import weblogic.platform.GarbageCollectionEvent;
import weblogic.platform.VM;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.t3.srvr.JRockitRuntime;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class JVMRuntime
extends RuntimeMBeanDelegate
implements JVMRuntimeMBean,
GCListener {
    private static final long serialVersionUID = -6411120496639444681L;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Runtime runtime;
    private static JVMRuntime singleton;
    private static final long OOME_IMMINENT = 5000000L;
    private static final int FREE_MEM_PERCENT_DIFF_THRESHOLD = 10;
    private static final DebugCategory debugMemory;
    private int previousFreeMemPercent;
    private boolean sendNotificationOOME = true;

    protected JVMRuntime() throws ManagementException {
        super(ManagementService.getRuntimeAccess(kernelId).getServerName(), (RuntimeMBean)ManagementService.getRuntimeAccess(kernelId).getServerRuntime(), true, "JVMuntime");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().setJVMRuntime(this);
        this.runtime = Runtime.getRuntime();
    }

    public static synchronized JVMRuntime init() throws ManagementException {
        if (singleton != null) {
            throw new IllegalStateException("Attempt to double initialize");
        }
        if (JVMRuntime.isJrockit()) {
            singleton = new JRockitRuntime();
        } else {
            singleton = new JVMRuntime();
            VM.getVM().addGCListener((GCListener)singleton);
        }
        return singleton;
    }

    public static synchronized JVMRuntime theOne() {
        return singleton;
    }

    private static boolean isJrockit() {
        String string = System.getProperty("java.vm.name");
        if (string == null) {
            string = "";
        }
        return (string = string.toLowerCase(Locale.ENGLISH)).indexOf("jrockit", 0) >= 0;
    }

    public void shutdown() {
        this.runtime.exit(0);
    }

    public void runGC() {
        this.runtime.gc();
    }

    public long getHeapFreeCurrent() {
        return this.runtime.freeMemory();
    }

    public long getHeapSizeCurrent() {
        return this.runtime.totalMemory();
    }

    public long getHeapSizeMax() {
        return this.runtime.maxMemory();
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getOSName() {
        return System.getProperty("os.name");
    }

    public String getOSVersion() {
        return System.getProperty("os.version");
    }

    public String getThreadStackDump() {
        return VM.getVM().threadDumpAsString();
    }

    public long getUptime() {
        return System.currentTimeMillis() - ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getActivationTime();
    }

    public int getHeapFreePercent() {
        if (this.getHeapSizeMax() == Long.MAX_VALUE) {
            return (int)(this.getHeapFreeCurrent() * 100L / this.getHeapSizeCurrent());
        }
        return (int)((this.getHeapSizeMax() - this.getHeapSizeCurrent() + this.getHeapFreeCurrent()) * 100L / this.getHeapSizeMax());
    }

    public synchronized void sendMemoryNotification(int n, int n2) {
        this._postSet("HeapFreePercent", n, n2);
    }

    public void onGarbageCollection(GarbageCollectionEvent garbageCollectionEvent) {
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().maxMemory();
        int n = (int)(l * 100L / l2);
        this.logDebug(n, l, l2, l3);
        if (l + (l3 - l2) < 5000000L) {
            if (this.sendNotificationOOME) {
                HealthLogger.logOOMEImminent((long)l);
                this.sendMemoryNotification(this.previousFreeMemPercent, n);
                this.previousFreeMemPercent = n;
                this.sendNotificationOOME = false;
            }
            return;
        }
        int n2 = n - this.previousFreeMemPercent;
        this.sendNotificationOOME = true;
        if (Math.abs(n2) > 10) {
            HealthLogger.logFreeMemoryChanged((int)n);
            this.sendMemoryNotification(this.previousFreeMemPercent, n);
            this.previousFreeMemPercent = n;
        }
    }

    private void logDebug(int n, long l, long l2, long l3) {
        if (debugMemory.isEnabled()) {
            HealthLogger.logDebugMsg((String)("free mem " + n + "%, " + "free mem bytes " + l + ", " + "total mem " + l2 + ", " + "max mem " + l3));
        }
    }

    static {
        debugMemory = Debug.getCategory((String)"weblogic.debug.memory");
    }
}

