/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import weblogic.kernel.FinalThreadLocalList;
import weblogic.kernel.Kernel;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.ManagementException;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.ConfigurationException;
import weblogic.net.http.Handler;
import weblogic.security.utils.SSLSetup;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class PreConfigBootService
extends AbstractServerService {
    public void start() throws ServiceFailureException {
        try {
            String string;
            boolean bl = Boolean.getBoolean("weblogic.nodemanager.ServiceEnabled");
            if (!bl && (string = System.getProperty("weblogic.Stdout")) != null) {
                System.setOut(PreConfigBootService.getPrintStream(string));
            }
            if ((string = System.getProperty("weblogic.Stderr")) != null) {
                System.setErr(PreConfigBootService.getPrintStream(string));
            }
            T3SrvrLogger.logServerStarting((String)System.getProperty("java.vm.name"), (String)System.getProperty("java.vm.version"), (String)System.getProperty("java.vm.vendor"));
            String string2 = BootStrap.getWebLogicHome();
            if (string2 == null) {
                throw new ConfigurationException("Property weblogic.home must be set to run WebLogic Server.  This should be set to the location of your WebLogic Server install (i.e. -Dweblogic.home=/bea/wlserver[version])");
            }
            SSLSetup.initForServer();
            Handler.init();
            Kernel.setIsServer((boolean)true);
            FinalThreadLocalList.initialize();
        }
        catch (ConfigurationException configurationException) {
            T3SrvrLogger.logConfigFailure((String)configurationException.getMessage());
            throw new ServiceFailureException((Throwable)configurationException);
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException((Throwable)managementException);
        }
        catch (IOException iOException) {
            throw new ServiceFailureException((Throwable)iOException);
        }
    }

    private static PrintStream getPrintStream(String string) throws IOException {
        File file;
        File file2 = new File(string);
        if (!file2.exists() && (file = file2.getParentFile()) != null && !file.exists()) {
            file.mkdirs();
        }
        return new PrintStream(new FileOutputStream(string, true));
    }

    public void stop() {
        this.shutdown();
    }

    public void halt() {
        this.shutdown();
    }

    public void shutdown() {
    }
}

