/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import weblogic.t3.srvr.Scavengable;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.NestedError;

public final class Scavenger
implements TimerListener {
    private static final int SCAVENGE_INTERVAL_SECS = 60;
    private static final Hashtable TRASH = new Hashtable();
    private int passCount = 0;

    public Scavenger() {
        int n = 60;
        TimerManagerFactory.getTimerManagerFactory().getTimerManager("Scavenger").scheduleAtFixedRate((TimerListener)this, 0L, (long)(n * 1000));
    }

    public void timerExpired(Timer timer) {
        ++this.passCount;
        Hashtable hashtable = (Hashtable)TRASH.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Scavengable scavengable = (Scavengable)enumeration.nextElement();
            try {
                scavengable.scavenge(this.passCount);
            }
            catch (IOException iOException) {
                throw new NestedError("IOException in trigger of " + timer, (Throwable)iOException);
            }
        }
    }

    public static void addScavengable(String string, Scavengable scavengable) {
        TRASH.put(string, scavengable);
    }

    public static void removeScavengable(String string) {
        TRASH.remove(string);
    }
}

