/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.provider.ManagementService;
import weblogic.nodemanager.NMService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.FileUtils;

final class ServerLifeCycleTimerThread
extends Thread {
    private static ServerLifeCycleTimerThread THE_ONE;
    private static final AuthenticatedSubject kernelId;
    private int timeout = ManagementService.isRuntimeAccessInitialized() ? ManagementService.getRuntimeAccess(kernelId).getServer().getServerLifeCycleTimeoutVal() : 30;

    private ServerLifeCycleTimerThread() {
    }

    static synchronized void startTimeBomb() {
        if (THE_ONE != null) {
            return;
        }
        THE_ONE = new ServerLifeCycleTimerThread();
        THE_ONE.setDaemon(true);
        THE_ONE.start();
    }

    public void run() {
        int n = 10000;
        int n2 = this.timeout == 0 ? Integer.MAX_VALUE : (this.timeout < 2147483 ? this.timeout * 1000 : Integer.MAX_VALUE);
        if (n > n2) {
            n = n2;
        }
        while (n > 0) {
            try {
                Thread.sleep(n);
                if ((n2 -= n) <= 0) break;
                if (n2 >= n) continue;
                n = n2;
            }
            catch (InterruptedException interruptedException) {}
        }
        T3SrvrLogger.logShutdownTimedOut((int)this.timeout);
        FileUtils.removeLockFiles();
        T3Srvr.logThreadDump();
        NMService nMService = NMService.getInstance();
        if (nMService != null) {
            try {
                nMService.hardShutdown();
            }
            catch (ServiceFailureException serviceFailureException) {
                // empty catch block
            }
        }
        Runtime.getRuntime().halt(-1);
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

