/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.ServerResource;
import weblogic.security.spi.Resource;

public final class ServerLockoutManager {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final AuthorizationManager am = SecurityServiceManager.getAuthorizationManager((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT");
    private boolean isLocked = false;
    private String lockedMessage;
    private static final int LOCKSERVER_CODE = 1;
    private static final int UNLOCKSERVER_CODE = 2;
    private static final int SHUTDOWN_CODE = 3;
    private static final int CANCELSHUTDOWN_CODE = 4;

    ServerLockoutManager() {
    }

    public void checkServerLock() throws SecurityException {
        if (!this.isLocked) {
            return;
        }
        throw new SecurityException(this.lockedMessage);
    }

    public String lockServer(String string) throws SecurityException {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        this.simpleCheckSubject(authenticatedSubject, 1);
        T3SrvrLogger.logLockServerRequested((String)SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject));
        ServerResource serverResource = new ServerResource(null, ManagementService.getRuntimeAccess(kernelId).getServerName(), "lock");
        if (!this.am.isAccessAllowed(authenticatedSubject, (Resource)serverResource, null)) {
            throw new SecurityException("User: '" + SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject) + "' does not have permission to lock server");
        }
        this.lockedMessage = string;
        this.isLocked = true;
        String string2 = T3SrvrLogger.logLockServerHappened();
        return this.getLocalMessage(string2);
    }

    public String unlockServer() throws SecurityException {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        this.simpleCheckSubject(authenticatedSubject, 2);
        T3SrvrLogger.logUnlockServerRequested((String)SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject));
        ServerResource serverResource = new ServerResource(null, ManagementService.getRuntimeAccess(kernelId).getServerName(), "unlock");
        if (!this.am.isAccessAllowed(authenticatedSubject, (Resource)serverResource, null)) {
            throw new SecurityException("User: '" + SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject) + "' does not have permission to unlock server");
        }
        this.isLocked = false;
        this.lockedMessage = null;
        String string = T3SrvrLogger.logUnlockServerHappened();
        return this.getLocalMessage(string);
    }

    private void simpleCheckSubject(AuthenticatedSubject authenticatedSubject, int n) throws SecurityException {
        if (authenticatedSubject != null) {
            String string = SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject);
            if (string != null && string.trim().length() > 0) {
                return;
            }
            switch (n) {
                default: {
                    T3SrvrLogger.logNoShutdownNamelessUser();
                    throw new SecurityException("Cannot shutdown the server, the request was from a nameless user (Principal)");
                }
                case 1: {
                    T3SrvrLogger.logNoLockServerNamelessUser();
                    throw new SecurityException("Cannot disable server logins, the request was from a nameless user (Principal)");
                }
                case 2: {
                    T3SrvrLogger.logNoUnlockServerNamelessUser();
                    throw new SecurityException("Cannot enable server logins, the request was from a nameless user (Principal)");
                }
                case 4: 
            }
            T3SrvrLogger.logNoCancelShutdownNamelessUser();
            throw new SecurityException("Cannot cancel the server shutdown, the request was from a nameless user (Principal)");
        }
        switch (n) {
            default: {
                T3SrvrLogger.logNoShutdownNullUser();
                throw new SecurityException("Cannot shutdown, the request was from a null Principal");
            }
            case 1: {
                T3SrvrLogger.logNoLockServerNullUser();
                throw new SecurityException("Cannot disable server logins, the request was from a null Principal");
            }
            case 2: {
                T3SrvrLogger.logNoUnlockServerNullUser();
                throw new SecurityException("Cannot enable server logins, the request was from a null Principal");
            }
            case 4: 
        }
        T3SrvrLogger.logNoCancelShutdownNullUser();
        throw new SecurityException("Cannot cancel the server shutdown, the request was from a null user (Principal)");
    }

    private String getLocalMessage(String string) {
        String string2;
        try {
            int n = Integer.parseInt(string);
            Localizer localizer = L10nLookup.getLocalizer((Locale)Locale.getDefault(), (String)"weblogic.i18n.T3SrvrLogLocalizer");
            string2 = (String)localizer.getObject("messagebody", n);
        }
        catch (Exception exception) {
            T3SrvrLogger.logLocalizerProblem((String)string, (Exception)exception);
            string2 = "A message regarding the status of server shutdown or logins could not be retrieved, messageid " + string;
        }
        return string2;
    }
}

