/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import weblogic.Home;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.descriptor.DescriptorBean;
import weblogic.health.HealthFeedback;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.logging.LogBroadcaster;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.management.provider.RegistrationHandler;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.provider.Service;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.AsyncReplicationRuntimeMBean;
import weblogic.management.runtime.ClusterRuntimeMBean;
import weblogic.management.runtime.ConnectorServiceRuntimeMBean;
import weblogic.management.runtime.EntityCacheCumulativeRuntimeMBean;
import weblogic.management.runtime.EntityCacheCurrentStateRuntimeMBean;
import weblogic.management.runtime.ExecuteQueueRuntimeMBean;
import weblogic.management.runtime.JDBCServiceRuntimeMBean;
import weblogic.management.runtime.JMSRuntimeMBean;
import weblogic.management.runtime.JTARuntimeMBean;
import weblogic.management.runtime.JVMRuntimeMBean;
import weblogic.management.runtime.JoltConnectionServiceRuntimeMBean;
import weblogic.management.runtime.LibraryRuntimeMBean;
import weblogic.management.runtime.LogBroadcasterRuntimeMBean;
import weblogic.management.runtime.LogRuntimeMBean;
import weblogic.management.runtime.MANAsyncReplicationRuntimeMBean;
import weblogic.management.runtime.MANReplicationRuntimeMBean;
import weblogic.management.runtime.MailSessionRuntimeMBean;
import weblogic.management.runtime.MaxThreadsConstraintRuntimeMBean;
import weblogic.management.runtime.MessagingBridgeRuntimeMBean;
import weblogic.management.runtime.MinThreadsConstraintRuntimeMBean;
import weblogic.management.runtime.PathServiceRuntimeMBean;
import weblogic.management.runtime.PersistentStoreRuntimeMBean;
import weblogic.management.runtime.RequestClassRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SAFRuntimeMBean;
import weblogic.management.runtime.SNMPAgentRuntimeMBean;
import weblogic.management.runtime.ServerChannelRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.ServerSecurityRuntimeMBean;
import weblogic.management.runtime.ServerStates;
import weblogic.management.runtime.SingleSignOnServicesRuntimeMBean;
import weblogic.management.runtime.SocketRuntime;
import weblogic.management.runtime.ThreadPoolRuntimeMBean;
import weblogic.management.runtime.TimeServiceRuntimeMBean;
import weblogic.management.runtime.TimerRuntimeMBean;
import weblogic.management.runtime.WANReplicationRuntimeMBean;
import weblogic.management.runtime.WLDFRuntimeMBean;
import weblogic.management.runtime.WLECConnectionServiceRuntimeMBean;
import weblogic.management.runtime.WTCRuntimeMBean;
import weblogic.management.runtime.WebServerRuntimeMBean;
import weblogic.management.runtime.WorkManagerRuntimeMBean;
import weblogic.management.runtime.WseeClusterFrontEndRuntimeMBean;
import weblogic.management.runtime.WseeWsrmRuntimeMBean;
import weblogic.protocol.AdminServerIdentity;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.URLManager;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rjvm.JVMID;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.EndPoint;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.RemoteLifeCycleOperations;
import weblogic.server.ServerLifeCycleRuntime;
import weblogic.server.ServerLifecycleException;
import weblogic.server.ServerLogger;
import weblogic.server.channels.ChannelService;
import weblogic.socket.MuxableSocket;
import weblogic.socket.SocketMuxer;
import weblogic.t3.srvr.GracefulShutdownRequest;
import weblogic.t3.srvr.ServerServices;
import weblogic.t3.srvr.ServerServicesManager;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.Classpath;
import weblogic.utils.StackTraceUtils;
import weblogic.version;
import weblogic.work.ContextWrap;
import weblogic.work.WorkManagerFactory;

public final class ServerRuntime
extends RuntimeMBeanDelegate
implements ServerRuntimeMBean,
HealthFeedback {
    private static final long serialVersionUID = 3862450250430200114L;
    private static ServerRuntime singleton;
    private final T3Srvr server;
    private ConnectorServiceRuntimeMBean connectorServiceRuntime;
    private JDBCServiceRuntimeMBean jdbcRuntime;
    private JMSRuntimeMBean jmsRuntime;
    private JTARuntimeMBean jtaRuntime;
    private JVMRuntimeMBean jvmRuntime;
    private SAFRuntimeMBean safRuntime;
    private ClusterRuntimeMBean clusterRuntime;
    private EntityCacheCurrentStateRuntimeMBean ecCurrStateRuntime;
    private EntityCacheCumulativeRuntimeMBean ecCumRuntime;
    private EntityCacheCumulativeRuntimeMBean ecHistRuntime;
    private ExecuteQueueRuntimeMBean executeQueueRuntime;
    private ServerSecurityRuntimeMBean serverSecurityRuntime;
    private SingleSignOnServicesRuntimeMBean ssoRuntime;
    private ThreadPoolRuntimeMBean threadPoolRuntime;
    private final Set executeQueueRuntimes = new HashSet();
    private final Set workManagerRuntimes = new HashSet();
    private final Set minThreadsConstraintRuntimes = new HashSet();
    private final Set maxThreadsConstraintRuntimes = new HashSet();
    private final Set<ApplicationRuntimeMBean> applicationRuntimes = Collections.synchronizedSet(new HashSet());
    private final Set pendingRestartSystemResources = new HashSet();
    private final Map<String, LibraryRuntimeMBean> libraryRuntimes = Collections.synchronizedMap(new HashMap());
    private final Set channelRuntimes = new HashSet();
    private final Set webServerRuntimes = new HashSet();
    private final Map persistentStoreRuntimes = new HashMap();
    private MANReplicationRuntimeMBean manReplicationRuntime;
    private WANReplicationRuntimeMBean wanReplicationRuntime;
    private MANAsyncReplicationRuntimeMBean manAsyncReplicationRuntime;
    private AsyncReplicationRuntimeMBean asyncReplicationRuntime = null;
    private WLDFRuntimeMBean wldfRuntime;
    private WTCRuntimeMBean wtcRuntime;
    private JoltConnectionServiceRuntimeMBean joltRuntime;
    private PathServiceRuntimeMBean pathServiceRuntime;
    private String currentMachine = "";
    private final Set requestClassRuntimes = new HashSet();
    private final Set mailSessionRuntimes = new HashSet();
    private boolean restartRequired;
    private TimerRuntimeMBean timerRuntime;
    private TimeServiceRuntimeMBean timeServiceRuntime;
    private LogRuntimeMBean logRuntime;
    private WLECConnectionServiceRuntimeMBean wlecConnectionService;
    private SNMPAgentRuntimeMBean snmpAgentRuntime;
    private MessagingBridgeRuntimeMBean messagingBridgeRuntime;
    private WseeWsrmRuntimeMBean wseeWsrmRuntime;
    private WseeClusterFrontEndRuntimeMBean wseeClusterFrontEndRuntime;
    private static final AuthenticatedSubject kernelId;
    private int stateVal = 9;
    private HealthState healthState = new HealthState(0);
    private Set internalApps;
    private String curDir;

    public static synchronized ServerRuntime init() throws ManagementException {
        if (singleton != null) {
            throw new IllegalStateException("Attempt to double initialize");
        }
        singleton = new ServerRuntime();
        return singleton;
    }

    public static synchronized ServerRuntime theOne() {
        return singleton;
    }

    private ServerRuntime() throws ManagementException {
        super(ManagementService.getRuntimeAccess(kernelId).getServerName(), null, true, (DescriptorBean)ManagementService.getRuntimeAccess(kernelId).getServer());
        this.server = T3Srvr.getT3Srvr();
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        runtimeAccess.addRegistrationHandler(this.createRegistrationHandler());
        this.server.initializeServerRuntime(this);
    }

    private RegistrationHandler createRegistrationHandler() {
        return new RegistrationHandler(){

            public void registered(RuntimeMBean runtimeMBean, DescriptorBean descriptorBean) {
                if (runtimeMBean instanceof ApplicationRuntimeMBean) {
                    ServerRuntime.this.applicationRuntimes.add((ApplicationRuntimeMBean)runtimeMBean);
                } else if (runtimeMBean instanceof LibraryRuntimeMBean) {
                    ServerRuntime.this.libraryRuntimes.put(runtimeMBean.getName(), (LibraryRuntimeMBean)runtimeMBean);
                }
            }

            public void unregistered(RuntimeMBean runtimeMBean) {
                if (runtimeMBean instanceof ApplicationRuntimeMBean) {
                    ServerRuntime.this.applicationRuntimes.remove(runtimeMBean);
                } else if (runtimeMBean instanceof LibraryRuntimeMBean) {
                    ServerRuntime.this.libraryRuntimes.remove(runtimeMBean.getName());
                }
            }

            public void registeredCustom(ObjectName objectName, Object object) {
            }

            public void unregisteredCustom(ObjectName objectName) {
            }

            public void registered(Service service2) {
            }

            public void unregistered(Service service2) {
            }
        };
    }

    public void suspend() throws ServerLifecycleException {
        this.suspend(0, false);
    }

    public void suspend(int n, boolean bl) throws ServerLifecycleException {
        GracefulShutdownRequest gracefulShutdownRequest = new GracefulShutdownRequest(bl, 17);
        this.logAdministratorAddress("Graceful suspend");
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new ContextWrap(gracefulShutdownRequest)));
        gracefulShutdownRequest.waitForCompletion(n * 1000);
        if (gracefulShutdownRequest.getException() != null) {
            throw new ServerLifecycleException(gracefulShutdownRequest.getException());
        }
        if (!gracefulShutdownRequest.isCompleted()) {
            this.forceSuspend();
        }
    }

    public void forceSuspend() throws ServerLifecycleException {
        this.logAdministratorAddress("Force suspend");
        this.server.forceSuspend();
    }

    public void resume() throws ServerLifecycleException {
        this.logAdministratorAddress("Resume");
        this.server.resume();
    }

    public void shutdown(int n, boolean bl) throws ServerLifecycleException {
        this.logAdministratorAddress("Graceful shutdown");
        GracefulShutdownRequest gracefulShutdownRequest = bl ? new GracefulShutdownRequest(bl) : new GracefulShutdownRequest(ManagementService.getRuntimeAccess(kernelId).getServer().isIgnoreSessionsDuringShutdown());
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new ContextWrap(gracefulShutdownRequest)));
        if (n == 0) {
            gracefulShutdownRequest.waitForCompletion(ManagementService.getRuntimeAccess(kernelId).getServer().getGracefulShutdownTimeout() * 1000);
        } else {
            gracefulShutdownRequest.waitForCompletion(n * 1000);
        }
        if (gracefulShutdownRequest.getException() != null) {
            throw new ServerLifecycleException(gracefulShutdownRequest.getException());
        }
        if (!gracefulShutdownRequest.isCompleted()) {
            this.forceShutdown();
        }
    }

    public void shutdown() throws ServerLifecycleException {
        this.shutdown(0, false);
    }

    public void forceShutdown() throws ServerLifecycleException {
        try {
            ServerLogger.logForceShuttingDownServer();
            this.logAdministratorAddress("Force shutdown");
            this.server.forceShutdown();
        }
        catch (RuntimeException runtimeException) {
            ServerLogger.logServerRuntimeError((String)runtimeException.toString());
            ServerLogger.logServerRuntimeError((String)StackTraceUtils.throwable2StackTrace((Throwable)runtimeException));
            throw new ServerLifecycleException(runtimeException);
        }
        catch (Exception exception) {
            throw new ServerLifecycleException(exception);
        }
    }

    public void abortStartupAfterAdminState() throws ServerLifecycleException {
        this.server.abortStartupAfterAdminState();
    }

    private void logAdministratorAddress(String string) {
        EndPoint endPoint = ServerHelper.getClientEndPointInternal();
        if (endPoint == null) {
            return;
        }
        Channel channel = endPoint.getRemoteChannel();
        if (channel == null) {
            return;
        }
        ServerLogger.logAdminAddress((String)string, (String)channel.getInetAddress().getHostAddress());
    }

    public void start() {
        this.server.getLockoutManager().unlockServer();
    }

    public boolean isStartupAbortedInAdminState() {
        return this.stateVal == 17 && this.server.isAbortStartupAfterAdminState();
    }

    public boolean isShuttingDownDueToFailure() {
        return this.server.isShutdownDueToFailure();
    }

    public void updateRunState(int n) {
        int n2;
        int n3 = this.stateVal;
        if (n == 10 || n == 11) {
            this.stateVal = 7;
            n2 = 7;
        } else {
            n2 = this.stateVal = n;
        }
        this._postSet("State", ServerRuntime.getStateAsString(n3), ServerRuntime.getStateAsString(n2));
        this.sendStateToAdminServer(ServerRuntime.getStateAsString(n2));
    }

    private void sendStateToAdminServer(final String string) {
        try {
            if (this.stateVal == 1) {
                return;
            }
            String string2 = ManagementService.getRuntimeAccess(kernelId).getAdminServerName();
            if (string2 == null) {
                return;
            }
            final RemoteLifeCycleOperations remoteLifeCycleOperations = ServerLifeCycleRuntime.getLifeCycleOperationsRemote(string2);
            if (remoteLifeCycleOperations == null) {
                return;
            }
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    try {
                        remoteLifeCycleOperations.setState(ManagementService.getRuntimeAccess(kernelId).getServerName(), string);
                    }
                    catch (RemoteRuntimeException remoteRuntimeException) {
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            // empty catch block
        }
    }

    private static String getStateAsString(int n) {
        return ServerStates.SERVERSTATES[n];
    }

    public String getState() {
        return ServerRuntime.getStateAsString(this.stateVal);
    }

    public boolean isShuttingDown() {
        return this.stateVal == 7 || this.stateVal == 18;
    }

    public int getStateVal() {
        return this.stateVal;
    }

    public long getActivationTime() {
        return this.server.getStartTime();
    }

    public long getServerStartupTime() {
        return this.server.getStartupTime();
    }

    public String getJVMID() {
        return JVMID.localID().objectToString();
    }

    public ServerIdentity getServerIdentity() {
        return LocalServerIdentity.getIdentity();
    }

    public int getSSLListenPort() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().getSSL().getListenPort();
    }

    public int getAdministrationPort() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().getAdministrationPort();
    }

    public int getRestartsTotalCount() {
        return 0;
    }

    public int getOpenSocketsCurrentCount() {
        return SocketMuxer.getMuxer().getNumSockets();
    }

    public SocketRuntime[] getSockets() {
        MuxableSocket[] muxableSocketArray = SocketMuxer.getMuxer().getSockets();
        SocketRuntime[] socketRuntimeArray = new SocketRuntime[muxableSocketArray.length];
        for (int i = 0; i < socketRuntimeArray.length; ++i) {
            MuxableSocket muxableSocket = muxableSocketArray[i];
            socketRuntimeArray[i] = muxableSocket instanceof SocketRuntime ? (SocketRuntime)muxableSocket : null;
        }
        return socketRuntimeArray;
    }

    public ServerChannelRuntimeMBean[] getServerChannelRuntimes() {
        int n = this.channelRuntimes.size();
        return this.channelRuntimes.toArray(new ServerChannelRuntimeMBean[n]);
    }

    public boolean addServerChannelRuntime(ServerChannelRuntimeMBean serverChannelRuntimeMBean) {
        return this.channelRuntimes.add(serverChannelRuntimeMBean);
    }

    public boolean removeServerChannelRuntime(ServerChannelRuntimeMBean serverChannelRuntimeMBean) {
        return this.channelRuntimes.remove(serverChannelRuntimeMBean);
    }

    public long getSocketsOpenedTotalCount() {
        return SocketMuxer.getMuxer().getNumSockets();
    }

    public String getMiddlewareHome() {
        int n;
        String string = this.getWeblogicHome();
        if (string != null && (n = string.lastIndexOf(File.separatorChar)) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public String getOracleHome() {
        return this.getMiddlewareHome();
    }

    public String getWeblogicHome() {
        String string = null;
        try {
            string = new File(Home.getPath()).getCanonicalPath();
        }
        catch (IOException iOException) {
            string = Home.getPath();
        }
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public String getWeblogicVersion() {
        return version.getVersions();
    }

    public MessagingBridgeRuntimeMBean getMessagingBridgeRuntime() {
        return this.messagingBridgeRuntime;
    }

    public void setMessagingBridgeRuntime(MessagingBridgeRuntimeMBean messagingBridgeRuntimeMBean) {
        this.messagingBridgeRuntime = messagingBridgeRuntimeMBean;
    }

    public JMSRuntimeMBean getJMSRuntime() {
        return this.jmsRuntime;
    }

    public void setJMSRuntime(JMSRuntimeMBean jMSRuntimeMBean) {
        this.jmsRuntime = jMSRuntimeMBean;
    }

    public SAFRuntimeMBean getSAFRuntime() {
        return this.safRuntime;
    }

    public void setSAFRuntime(SAFRuntimeMBean sAFRuntimeMBean) {
        this.safRuntime = sAFRuntimeMBean;
    }

    public WLECConnectionServiceRuntimeMBean getWLECConnectionServiceRuntime() {
        return this.wlecConnectionService;
    }

    public void setWLECConnectionServiceRuntime(WLECConnectionServiceRuntimeMBean wLECConnectionServiceRuntimeMBean) {
        this.wlecConnectionService = wLECConnectionServiceRuntimeMBean;
    }

    public JDBCServiceRuntimeMBean getJDBCServiceRuntime() {
        return this.jdbcRuntime;
    }

    public void setJDBCServiceRuntime(JDBCServiceRuntimeMBean jDBCServiceRuntimeMBean) {
        this.jdbcRuntime = jDBCServiceRuntimeMBean;
    }

    public JTARuntimeMBean getJTARuntime() {
        return this.jtaRuntime;
    }

    public void setJTARuntime(JTARuntimeMBean jTARuntimeMBean) {
        this.jtaRuntime = jTARuntimeMBean;
    }

    public WTCRuntimeMBean getWTCRuntime() {
        return this.wtcRuntime;
    }

    public void setWTCRuntime(WTCRuntimeMBean wTCRuntimeMBean) {
        this.wtcRuntime = wTCRuntimeMBean;
    }

    public JoltConnectionServiceRuntimeMBean getJoltRuntime() {
        return this.joltRuntime;
    }

    public void setJoltRuntime(JoltConnectionServiceRuntimeMBean joltConnectionServiceRuntimeMBean) {
        this.joltRuntime = joltConnectionServiceRuntimeMBean;
    }

    public JVMRuntimeMBean getJVMRuntime() {
        return this.jvmRuntime;
    }

    public void setJVMRuntime(JVMRuntimeMBean jVMRuntimeMBean) {
        this.jvmRuntime = jVMRuntimeMBean;
    }

    public ClusterRuntimeMBean getClusterRuntime() {
        return this.clusterRuntime;
    }

    public void setClusterRuntime(ClusterRuntimeMBean clusterRuntimeMBean) {
        this.clusterRuntime = clusterRuntimeMBean;
    }

    public EntityCacheCurrentStateRuntimeMBean getEntityCacheCurrentStateRuntime() {
        return this.ecCurrStateRuntime;
    }

    public void setEntityCacheCurrentStateRuntime(EntityCacheCurrentStateRuntimeMBean entityCacheCurrentStateRuntimeMBean) {
        this.ecCurrStateRuntime = entityCacheCurrentStateRuntimeMBean;
    }

    public EntityCacheCumulativeRuntimeMBean getEntityCacheCumulativeRuntime() {
        return this.ecCumRuntime;
    }

    public void setEntityCacheCumulativeRuntime(EntityCacheCumulativeRuntimeMBean entityCacheCumulativeRuntimeMBean) {
        this.ecCumRuntime = entityCacheCumulativeRuntimeMBean;
    }

    public EntityCacheCumulativeRuntimeMBean getEntityCacheHistoricalRuntime() {
        return this.ecHistRuntime;
    }

    public void setEntityCacheHistoricalRuntime(EntityCacheCumulativeRuntimeMBean entityCacheCumulativeRuntimeMBean) {
        this.ecHistRuntime = entityCacheCumulativeRuntimeMBean;
    }

    public ThreadPoolRuntimeMBean getThreadPoolRuntime() {
        return this.threadPoolRuntime;
    }

    public void setThreadPoolRuntime(ThreadPoolRuntimeMBean threadPoolRuntimeMBean) {
        this.threadPoolRuntime = threadPoolRuntimeMBean;
    }

    public void setTimerRuntime(TimerRuntimeMBean timerRuntimeMBean) {
        this.timerRuntime = timerRuntimeMBean;
    }

    public TimerRuntimeMBean getTimerRuntime() {
        return this.timerRuntime;
    }

    public void setTimeServiceRuntime(TimeServiceRuntimeMBean timeServiceRuntimeMBean) {
        this.timeServiceRuntime = timeServiceRuntimeMBean;
    }

    public TimeServiceRuntimeMBean getTimeServiceRuntime() {
        return this.timeServiceRuntime;
    }

    public ExecuteQueueRuntimeMBean getDefaultExecuteQueueRuntime() {
        if (this.executeQueueRuntime != null) {
            return this.executeQueueRuntime;
        }
        ExecuteQueueRuntimeMBean executeQueueRuntimeMBean = this.getExecuteQueueRuntimeInternal("weblogic.kernel.Default");
        if (executeQueueRuntimeMBean != null) {
            return executeQueueRuntimeMBean;
        }
        return this.getExecuteQueueRuntimeInternal("default");
    }

    public void setDefaultExecuteQueueRuntime(ExecuteQueueRuntimeMBean executeQueueRuntimeMBean) {
        this.executeQueueRuntime = executeQueueRuntimeMBean;
    }

    private ExecuteQueueRuntimeMBean getExecuteQueueRuntimeInternal(String string) {
        ExecuteQueueRuntimeMBean[] executeQueueRuntimeMBeanArray = this.getExecuteQueueRuntimes();
        for (int i = 0; i < executeQueueRuntimeMBeanArray.length; ++i) {
            if (!executeQueueRuntimeMBeanArray[i].getName().equals(string)) continue;
            return executeQueueRuntimeMBeanArray[i];
        }
        return null;
    }

    public ExecuteQueueRuntimeMBean[] getExecuteQueueRuntimes() {
        int n = this.executeQueueRuntimes.size();
        return this.executeQueueRuntimes.toArray(new ExecuteQueueRuntimeMBean[n]);
    }

    public boolean addExecuteQueueRuntime(ExecuteQueueRuntimeMBean executeQueueRuntimeMBean) {
        return this.executeQueueRuntimes.add(executeQueueRuntimeMBean);
    }

    public boolean removeExecuteQueueRuntime(ExecuteQueueRuntimeMBean executeQueueRuntimeMBean) {
        return this.executeQueueRuntimes.remove(executeQueueRuntimeMBean);
    }

    public WorkManagerRuntimeMBean[] getWorkManagerRuntimes() {
        int n = this.workManagerRuntimes.size();
        return this.workManagerRuntimes.toArray(new WorkManagerRuntimeMBean[n]);
    }

    public boolean addWorkManagerRuntime(WorkManagerRuntimeMBean workManagerRuntimeMBean) {
        return this.workManagerRuntimes.add(workManagerRuntimeMBean);
    }

    public boolean removeWorkManagerRuntime(WorkManagerRuntimeMBean workManagerRuntimeMBean) {
        return this.workManagerRuntimes.remove(workManagerRuntimeMBean);
    }

    public MinThreadsConstraintRuntimeMBean lookupMinThreadsConstraintRuntime(String string) {
        MinThreadsConstraintRuntimeMBean[] minThreadsConstraintRuntimeMBeanArray = this.getMinThreadsConstraintRuntimes();
        for (int i = 0; i < minThreadsConstraintRuntimeMBeanArray.length; ++i) {
            if (!minThreadsConstraintRuntimeMBeanArray[i].getName().equals(string)) continue;
            return minThreadsConstraintRuntimeMBeanArray[i];
        }
        return null;
    }

    public RequestClassRuntimeMBean lookupRequestClassRuntime(String string) {
        RequestClassRuntimeMBean[] requestClassRuntimeMBeanArray = this.getRequestClassRuntimes();
        for (int i = 0; i < requestClassRuntimeMBeanArray.length; ++i) {
            if (!requestClassRuntimeMBeanArray[i].getName().equals(string)) continue;
            return requestClassRuntimeMBeanArray[i];
        }
        return null;
    }

    public MaxThreadsConstraintRuntimeMBean lookupMaxThreadsConstraintRuntime(String string) {
        MaxThreadsConstraintRuntimeMBean[] maxThreadsConstraintRuntimeMBeanArray = this.getMaxThreadsConstraintRuntimes();
        for (int i = 0; i < maxThreadsConstraintRuntimeMBeanArray.length; ++i) {
            if (!maxThreadsConstraintRuntimeMBeanArray[i].getName().equals(string)) continue;
            return maxThreadsConstraintRuntimeMBeanArray[i];
        }
        return null;
    }

    public boolean addMaxThreadsConstraintRuntime(MaxThreadsConstraintRuntimeMBean maxThreadsConstraintRuntimeMBean) {
        return this.maxThreadsConstraintRuntimes.add(maxThreadsConstraintRuntimeMBean);
    }

    public MaxThreadsConstraintRuntimeMBean[] getMaxThreadsConstraintRuntimes() {
        int n = this.maxThreadsConstraintRuntimes.size();
        return this.maxThreadsConstraintRuntimes.toArray(new MaxThreadsConstraintRuntimeMBean[n]);
    }

    public boolean addMinThreadsConstraintRuntime(MinThreadsConstraintRuntimeMBean minThreadsConstraintRuntimeMBean) {
        return this.minThreadsConstraintRuntimes.add(minThreadsConstraintRuntimeMBean);
    }

    public boolean addRequestClassRuntime(RequestClassRuntimeMBean requestClassRuntimeMBean) {
        return this.requestClassRuntimes.add(requestClassRuntimeMBean);
    }

    public MinThreadsConstraintRuntimeMBean[] getMinThreadsConstraintRuntimes() {
        int n = this.minThreadsConstraintRuntimes.size();
        return this.minThreadsConstraintRuntimes.toArray(new MinThreadsConstraintRuntimeMBean[n]);
    }

    public RequestClassRuntimeMBean[] getRequestClassRuntimes() {
        int n = this.requestClassRuntimes.size();
        return this.requestClassRuntimes.toArray(new RequestClassRuntimeMBean[n]);
    }

    public ServerSecurityRuntimeMBean getServerSecurityRuntime() {
        return this.serverSecurityRuntime;
    }

    public void setServerSecurityRuntime(ServerSecurityRuntimeMBean serverSecurityRuntimeMBean) {
        this.serverSecurityRuntime = serverSecurityRuntimeMBean;
    }

    public SingleSignOnServicesRuntimeMBean getSingleSignOnServicesRuntime() {
        return this.ssoRuntime;
    }

    public void setSingleSignOnServicesRuntime(SingleSignOnServicesRuntimeMBean singleSignOnServicesRuntimeMBean) {
        this.ssoRuntime = singleSignOnServicesRuntimeMBean;
    }

    public String getListenAddress() {
        InetSocketAddress inetSocketAddress = this.getServerChannel("T3");
        if (!(inetSocketAddress != null && !inetSocketAddress.isUnresolved() || (inetSocketAddress = this.getServerChannel("T3S")) != null && !inetSocketAddress.isUnresolved() || (inetSocketAddress = this.getServerChannel("ADMIN")) != null && !inetSocketAddress.isUnresolved())) {
            return null;
        }
        String string = inetSocketAddress.getAddress().toString();
        if (string.startsWith("/")) {
            StringBuffer stringBuffer = new StringBuffer(inetSocketAddress.getHostName());
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    public InetSocketAddress getServerChannel(String string) {
        return ChannelService.findServerAddress(string);
    }

    public void restartSSLChannels() {
        ((ChannelService)ServerChannelManager.getServerChannelManager()).restartSSLChannels();
    }

    public String getDefaultURL() {
        return ChannelHelper.getDefaultURL();
    }

    public String getAdministrationURL() {
        return ChannelHelper.getLocalAdministrationURL();
    }

    public String getURL(String string) {
        Protocol protocol = ProtocolManager.getProtocolByName((String)string);
        return ChannelHelper.getURL(protocol);
    }

    public String getIPv4URL(String string) {
        Protocol protocol = ProtocolManager.getProtocolByName((String)string);
        return ChannelHelper.getIPv4URL(protocol);
    }

    public String getIPv6URL(String string) {
        Protocol protocol = ProtocolManager.getProtocolByName((String)string);
        return ChannelHelper.getIPv6URL(protocol);
    }

    public int getListenPort() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().getListenPort();
    }

    public boolean isListenPortEnabled() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().isListenPortEnabled();
    }

    public boolean isAdministrationPortEnabled() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().isAdministrationPortEnabled();
    }

    public boolean isSSLListenPortEnabled() {
        if (ManagementService.getRuntimeAccess(kernelId).getServer().getSSL() == null) {
            return false;
        }
        return ManagementService.getRuntimeAccess(kernelId).getServer().getSSL().isListenPortEnabled();
    }

    public boolean isAdminServerListenPortSecure() {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            ServerMBean serverMBean = runtimeAccess.getServer();
            if (serverMBean != null) {
                if (serverMBean.isAdministrationPortEnabled()) {
                    return true;
                }
                return !serverMBean.isListenPortEnabled();
            }
            return false;
        }
        ManagementService.getPropertyService(kernelId);
        String string = PropertyService.getAdminHttpUrl();
        if (null == string) {
            return false;
        }
        return string.startsWith("https");
    }

    public int getAdminServerListenPort() {
        ServerIdentity serverIdentity = AdminServerIdentity.getIdentity();
        if (serverIdentity == null) {
            throw new IllegalStateException("Admin server identity is unavailable. The managed server may not be connected to the admin server");
        }
        String string = URLManager.findAdministrationURL(serverIdentity);
        try {
            return new URI(string).getPort();
        }
        catch (URISyntaxException uRISyntaxException) {
            return 0;
        }
    }

    public String getAdminServerHost() {
        String string = URLManager.findAdministrationURL(AdminServerIdentity.getIdentity());
        try {
            return new URI(string).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String getSSLListenAddress() {
        InetSocketAddress inetSocketAddress = this.getServerChannel("HTTPS");
        if (inetSocketAddress == null) {
            return null;
        }
        String string = inetSocketAddress.getAddress().toString();
        if (string.startsWith("/")) {
            StringBuffer stringBuffer = new StringBuffer(inetSocketAddress.getHostName());
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    public HealthState getHealthState() {
        return this.healthState;
    }

    public HealthState getOverallHealthState() {
        HealthState healthState = this.getHealthState();
        for (HealthState healthState2 : this.getSubsystemHealthStates()) {
            if ("ApplicationRuntime".equals(healthState2.getMBeanType()) && this.isInternalDeployment(healthState2.getMBeanName()) || "MessageDrivenEJBRuntime".equals(healthState2.getMBeanType()) || healthState.compareSeverityTo(healthState2) <= 0) continue;
            healthState = healthState2;
        }
        return healthState;
    }

    private boolean isInternalDeployment(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.indexOf("#");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (this.internalApps == null) {
            HashSet<String> hashSet = new HashSet<String>();
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            DomainMBean domainMBean = runtimeAccess.getDomain();
            for (AppDeploymentMBean appDeploymentMBean : domainMBean.getInternalAppDeployments()) {
                hashSet.add(appDeploymentMBean.getApplicationName());
            }
            this.internalApps = hashSet;
        }
        return this.internalApps.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHealthState(int n, String string) {
        HealthState healthState;
        HealthState healthState2;
        ServerRuntime serverRuntime = this;
        synchronized (serverRuntime) {
            healthState2 = this.healthState;
            this.healthState = healthState = new HealthState(n, string);
        }
        this._postSet("HealthState", healthState2, healthState);
    }

    public boolean isAdminServer() {
        return ManagementService.getRuntimeAccess(kernelId).isAdminServer() || !ManagementService.getRuntimeAccess(kernelId).isAdminServerAvailable();
    }

    public String getCurrentDirectory() {
        if (this.curDir == null) {
            this.curDir = new File(".").getAbsolutePath();
        }
        return this.curDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationRuntimeMBean[] getApplicationRuntimes() {
        Set<ApplicationRuntimeMBean> set = this.applicationRuntimes;
        synchronized (set) {
            int n = this.applicationRuntimes.size();
            return this.applicationRuntimes.toArray(new ApplicationRuntimeMBean[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationRuntimeMBean lookupApplicationRuntime(String string) {
        Set<ApplicationRuntimeMBean> set = this.applicationRuntimes;
        synchronized (set) {
            for (ApplicationRuntimeMBean applicationRuntimeMBean : this.applicationRuntimes) {
                if (!applicationRuntimeMBean.getApplicationName().equals(string)) continue;
                return applicationRuntimeMBean;
            }
            return null;
        }
    }

    public String[] getPendingRestartSystemResources() {
        int n = this.pendingRestartSystemResources.size();
        return this.pendingRestartSystemResources.toArray(new String[n]);
    }

    public boolean addPendingRestartSystemResource(String string) {
        return this.pendingRestartSystemResources.add(string);
    }

    public boolean removePendingRestartSystemResource(String string) {
        return this.pendingRestartSystemResources.remove(string);
    }

    public boolean isRestartPendingForSystemResource(String string) {
        return this.pendingRestartSystemResources.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryRuntimeMBean[] getLibraryRuntimes() {
        Map<String, LibraryRuntimeMBean> map = this.libraryRuntimes;
        synchronized (map) {
            return this.libraryRuntimes.values().toArray(new LibraryRuntimeMBean[this.libraryRuntimes.size()]);
        }
    }

    public LibraryRuntimeMBean lookupLibraryRuntime(String string) {
        return this.libraryRuntimes.get(string);
    }

    public LogBroadcasterRuntimeMBean getLogBroadcasterRuntime() throws ManagementException {
        return LogBroadcaster.getLogBroadcaster();
    }

    public LogRuntimeMBean getLogRuntime() {
        return this.logRuntime;
    }

    public void setLogRuntime(LogRuntimeMBean logRuntimeMBean) {
        this.logRuntime = logRuntimeMBean;
    }

    public WLDFRuntimeMBean getWLDFRuntime() {
        return this.wldfRuntime;
    }

    public void setWLDFRuntime(WLDFRuntimeMBean wLDFRuntimeMBean) {
        this.wldfRuntime = wLDFRuntimeMBean;
    }

    public void setMANReplicationRuntime(MANReplicationRuntimeMBean mANReplicationRuntimeMBean) {
        this.manReplicationRuntime = mANReplicationRuntimeMBean;
    }

    public MANReplicationRuntimeMBean getMANReplicationRuntime() {
        return this.manReplicationRuntime;
    }

    public void setWANReplicationRuntime(WANReplicationRuntimeMBean wANReplicationRuntimeMBean) {
        this.wanReplicationRuntime = wANReplicationRuntimeMBean;
    }

    public WANReplicationRuntimeMBean getWANReplicationRuntime() {
        return this.wanReplicationRuntime;
    }

    public AsyncReplicationRuntimeMBean getAsyncReplicationRuntime() {
        return this.asyncReplicationRuntime;
    }

    public void setAsyncReplicationRuntime(AsyncReplicationRuntimeMBean asyncReplicationRuntimeMBean) {
        this.asyncReplicationRuntime = asyncReplicationRuntimeMBean;
    }

    public String getCurrentMachine() {
        return this.currentMachine;
    }

    public HealthState[] getSubsystemHealthStates() {
        return HealthMonitorService.getHealthStates();
    }

    public HashMap getServerServiceVersions() {
        return ServerServicesManager.getVersionsOnline();
    }

    public void setCurrentMachine(String string) {
        this.currentMachine = string;
    }

    public MailSessionRuntimeMBean[] getMailSessionRuntimes() {
        return this.mailSessionRuntimes.toArray(new MailSessionRuntimeMBean[this.mailSessionRuntimes.size()]);
    }

    public boolean addMailSessionRuntime(MailSessionRuntimeMBean mailSessionRuntimeMBean) {
        return this.mailSessionRuntimes.add(mailSessionRuntimeMBean);
    }

    public boolean removeMailSessionRuntime(MailSessionRuntimeMBean mailSessionRuntimeMBean) {
        return this.mailSessionRuntimes.remove(mailSessionRuntimeMBean);
    }

    public PersistentStoreRuntimeMBean[] getPersistentStoreRuntimes() {
        Collection collection = this.persistentStoreRuntimes.values();
        return collection.toArray(new PersistentStoreRuntimeMBean[this.persistentStoreRuntimes.size()]);
    }

    public PersistentStoreRuntimeMBean lookupPersistentStoreRuntime(String string) {
        return (PersistentStoreRuntimeMBean)this.persistentStoreRuntimes.get(string);
    }

    public void addPersistentStoreRuntime(PersistentStoreRuntimeMBean persistentStoreRuntimeMBean) {
        this.persistentStoreRuntimes.put(persistentStoreRuntimeMBean.getName(), persistentStoreRuntimeMBean);
    }

    public void removePersistentStoreRuntime(PersistentStoreRuntimeMBean persistentStoreRuntimeMBean) {
        this.persistentStoreRuntimes.remove(persistentStoreRuntimeMBean.getName());
    }

    public ConnectorServiceRuntimeMBean getConnectorServiceRuntime() {
        return this.connectorServiceRuntime;
    }

    public void setConnectorServiceRuntime(ConnectorServiceRuntimeMBean connectorServiceRuntimeMBean) {
        this.connectorServiceRuntime = connectorServiceRuntimeMBean;
    }

    public WebServerRuntimeMBean[] getWebServerRuntimes() {
        int n = this.webServerRuntimes.size();
        return this.webServerRuntimes.toArray(new WebServerRuntimeMBean[n]);
    }

    public boolean addWebServerRuntime(WebServerRuntimeMBean webServerRuntimeMBean) {
        return this.webServerRuntimes.add(webServerRuntimeMBean);
    }

    public boolean removeWebServerRuntime(WebServerRuntimeMBean webServerRuntimeMBean) {
        return this.webServerRuntimes.remove(webServerRuntimeMBean);
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setRestartRequired(boolean bl) {
        this.restartRequired = bl;
    }

    public String getServerClasspath() {
        return Classpath.get();
    }

    public PathServiceRuntimeMBean getPathServiceRuntime() {
        return this.pathServiceRuntime;
    }

    public void setPathServiceRuntime(PathServiceRuntimeMBean pathServiceRuntimeMBean) {
        this.pathServiceRuntime = pathServiceRuntimeMBean;
    }

    public boolean isClusterMaster() {
        MigratableServerService migratableServerService = MigratableServerService.theOne();
        if (migratableServerService != null) {
            return migratableServerService.isClusterMaster();
        }
        return false;
    }

    public SNMPAgentRuntimeMBean getSNMPAgentRuntime() {
        return this.snmpAgentRuntime;
    }

    public void setSNMPAgentRuntime(SNMPAgentRuntimeMBean sNMPAgentRuntimeMBean) {
        this.snmpAgentRuntime = sNMPAgentRuntimeMBean;
    }

    public boolean isServiceAvailable(String string) {
        return ServerServices.WLS_DEPENDENCIES.isServiceAvailable(string);
    }

    public MANAsyncReplicationRuntimeMBean getMANAsyncReplicationRuntime() {
        return this.manAsyncReplicationRuntime;
    }

    public void setMANAsyncReplicationRuntime(MANAsyncReplicationRuntimeMBean mANAsyncReplicationRuntimeMBean) {
        this.manAsyncReplicationRuntime = mANAsyncReplicationRuntimeMBean;
    }

    public int getStableState() {
        return this.server.getStableState();
    }

    public void setWseeWsrmRuntime(WseeWsrmRuntimeMBean wseeWsrmRuntimeMBean) {
        this.wseeWsrmRuntime = wseeWsrmRuntimeMBean;
    }

    public WseeWsrmRuntimeMBean getWseeWsrmRuntime() {
        return this.wseeWsrmRuntime;
    }

    public void setWseeClusterFrontEndRuntime(WseeClusterFrontEndRuntimeMBean wseeClusterFrontEndRuntimeMBean) {
        this.wseeClusterFrontEndRuntime = wseeClusterFrontEndRuntimeMBean;
    }

    public WseeClusterFrontEndRuntimeMBean getWseeClusterFrontEndRuntime() {
        return this.wseeClusterFrontEndRuntime;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

