/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.WebLogicMBeanImplBeanInfo;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.runtime.RequestClassRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.t3.srvr.ServerRuntime;

public class ServerRuntimeBeanInfo
extends WebLogicMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = ServerRuntimeMBean.class;

    public ServerRuntimeBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public ServerRuntimeBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = ServerRuntime.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.t3.srvr");
        String string = new String("Provides methods for retrieving runtime information about a server instance and for transitioning a server from one state to another.  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.runtime.ServerRuntimeMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("ActivationTime")) {
            string2 = "getActivationTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ActivationTime", ServerRuntimeMBean.class, string2, string);
            map.put("ActivationTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The time when the server was started.</p> ");
        }
        if (!map.containsKey("AdminServerHost")) {
            string2 = "getAdminServerHost";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AdminServerHost", ServerRuntimeMBean.class, string2, string);
            map.put("AdminServerHost", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The address on which the Administration Server is listening for connections. For example, this might return the string: santiago</p> ");
        }
        if (!map.containsKey("AdminServerListenPort")) {
            string2 = "getAdminServerListenPort";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AdminServerListenPort", ServerRuntimeMBean.class, string2, string);
            map.put("AdminServerListenPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The port on which the Administration Server is listening for connections.</p> ");
        }
        if (!map.containsKey("AdministrationPort")) {
            string2 = "getAdministrationPort";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AdministrationPort", ServerRuntimeMBean.class, string2, string);
            map.put("AdministrationPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The port on which this server is listening for administrative requests.</p> ");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by {@link #getAdministrationURL} ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("AdministrationURL")) {
            string2 = "getAdministrationURL";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AdministrationURL", ServerRuntimeMBean.class, string2, string);
            map.put("AdministrationURL", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The URL that the server and its clients use for administrative connections.</p>  <p>If no administration channel is enabled, then this method returns the URL for connections through the default channel. If the default channel is de-activated, this method returns the URL for a secure channel. If no secure channel is enabled, the method returns null.</p>  <p>The returned URL will be consistent with dynamic channel updates.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("ApplicationRuntimes")) {
            string2 = "getApplicationRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ApplicationRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("ApplicationRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Returns the list of currently running Applications </p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.0.0", null, (String)this.targetVersion) && !map.containsKey("AsyncReplicationRuntime")) {
            string2 = "getAsyncReplicationRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AsyncReplicationRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("AsyncReplicationRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which represents this server's view of its AsyncReplicationRuntime, if any.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "10.3.0.0");
        }
        if (!map.containsKey("ClusterRuntime")) {
            string2 = "getClusterRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ClusterRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("ClusterRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which represents this server's view of its cluster, if any.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("ConnectorServiceRuntime")) {
            string2 = "getConnectorServiceRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ConnectorServiceRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("ConnectorServiceRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "The access point for server wide control and monitoring of the Connector Container. ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("CurrentDirectory")) {
            string2 = "getCurrentDirectory";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentDirectory", ServerRuntimeMBean.class, string2, string);
            map.put("CurrentDirectory", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The absolute path of the directory from which the server was started.</p>  <p>This may be used in conjunction with other relative paths in ServerMBean to compute full paths.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean")};
            propertyDescriptor.setValue("see", stringArray);
        }
        if (!map.containsKey("CurrentMachine")) {
            string2 = "getCurrentMachine";
            string = null;
            if (!this.readOnly) {
                string = "setCurrentMachine";
            }
            propertyDescriptor = new PropertyDescriptor("CurrentMachine", ServerRuntimeMBean.class, string2, string);
            map.put("CurrentMachine", propertyDescriptor);
            propertyDescriptor.setValue("description", "Return the machine on which the server is running. This will be different from the configuration if the server gets migrated automatically. * @return Machine on which server is running. ");
        }
        if (!map.containsKey("DefaultExecuteQueueRuntime")) {
            string2 = "getDefaultExecuteQueueRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DefaultExecuteQueueRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("DefaultExecuteQueueRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which exposes this server's default execute queue.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("DefaultURL")) {
            string2 = "getDefaultURL";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DefaultURL", ServerRuntimeMBean.class, string2, string);
            map.put("DefaultURL", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The URL that clients use to connect to this server's default network channel.</p>  <p>The returned value indicates the default protocol, listen address and listen port:<br clear=\"none\" /> <i>protocol</i>://<i>listen-address</i>:<i>listen-port</i></p>  <dl> <dt>Note:</dt>  <dd> <p>The default protocol, listen address and listen port are persisted in the domain's <code>config.xml</code> file, however when a server instance is started, command-line options can override these persisted values. This <code>getDefaultURL</code> method returns the URL values that are currently being used, not necessarily the values that are specified in <code>config.xml</code>.</p> </dd> </dl>  <p>The returned URL will be consistent with dynamic channel updates.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("EntityCacheCumulativeRuntime")) {
            string2 = "getEntityCacheCumulativeRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("EntityCacheCumulativeRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("EntityCacheCumulativeRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which represents Cumulative Status of the XML Cache.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("EntityCacheCurrentStateRuntime")) {
            string2 = "getEntityCacheCurrentStateRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("EntityCacheCurrentStateRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("EntityCacheCurrentStateRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which represents Current Status of the XML Cache.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("EntityCacheHistoricalRuntime")) {
            string2 = "getEntityCacheHistoricalRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("EntityCacheHistoricalRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("EntityCacheHistoricalRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which represents Historical Status of the XML Cache.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("ExecuteQueueRuntimes")) {
            string2 = "getExecuteQueueRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ExecuteQueueRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("ExecuteQueueRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns an array of MBeans which exposes this server's active execute queues.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("HealthState")) {
            string2 = "getHealthState";
            string = null;
            propertyDescriptor = new PropertyDescriptor("HealthState", ServerRuntimeMBean.class, string2, string);
            map.put("HealthState", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The health state of the server as reported by the server's self-health monitoring. See <a href=../../e13941/weblogic/health/HealthState.html>weblogic.health.HealthState</a> for state values. </p>  <p>For example, the server can report if it is overloaded by too many requests, if it needs more memory resources, or if it will soon fail for other reasons.</p> ");
        }
        if (!map.containsKey("JDBCServiceRuntime")) {
            string2 = "getJDBCServiceRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JDBCServiceRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("JDBCServiceRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The JDBCServiceRuntimeMBean for this server.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("JMSRuntime")) {
            string2 = "getJMSRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JMSRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("JMSRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The JMSRuntimeMBean for this server.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("JTARuntime")) {
            string2 = "getJTARuntime";
            string = null;
            if (!this.readOnly) {
                string = "setJTARuntime";
            }
            propertyDescriptor = new PropertyDescriptor("JTARuntime", ServerRuntimeMBean.class, string2, string);
            map.put("JTARuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The transaction RuntimeMBean for this server.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"JTARuntimeMBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("JVMRuntime")) {
            string2 = "getJVMRuntime";
            string = null;
            if (!this.readOnly) {
                string = "setJVMRuntime";
            }
            propertyDescriptor = new PropertyDescriptor("JVMRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("JVMRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The JVMRuntimeMBean for this server.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"JVMRuntimeMBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("JoltRuntime")) {
            string2 = "getJoltRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JoltRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("JoltRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The JoltConnectionServiceRuntimeMBean for this server.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("LibraryRuntimes")) {
            string2 = "getLibraryRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("LibraryRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("LibraryRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Returns all deployed Libraries </p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("ListenAddress")) {
            string2 = "getListenAddress";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ListenAddress", ServerRuntimeMBean.class, string2, string);
            map.put("ListenAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The address on which this server is listening for connections through the default network channel.</p>  <p>For example this might return the string: <code>santiago/172.17.9.220</code>.</p>  <p>You can configure other network channels for this server, and the other channels can use different listen addresses.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getServerChannel(String)")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by {@link #getURL} ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("ListenPort")) {
            string2 = "getListenPort";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ListenPort", ServerRuntimeMBean.class, string2, string);
            map.put("ListenPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The port on which this server is listening for connections.</p> ");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by {@link #getURL} ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("LogBroadcasterRuntime")) {
            string2 = "getLogBroadcasterRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("LogBroadcasterRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("LogBroadcasterRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "The object which generates notifications on behalf of the logging subystem. ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("LogRuntime")) {
            string2 = "getLogRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("LogRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("LogRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return the MBean which provides access to the control interface for WLS server logging.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.0.0", null, (String)this.targetVersion) && !map.containsKey("MANAsyncReplicationRuntime")) {
            string2 = "getMANAsyncReplicationRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MANAsyncReplicationRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("MANAsyncReplicationRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which represents this server's view of its MANAsyncReplicationRuntime, if any.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "10.3.0.0");
        }
        if (!map.containsKey("MANReplicationRuntime")) {
            string2 = "getMANReplicationRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MANReplicationRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("MANReplicationRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which represents this server's view of its MANReplicationRuntime, if any.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("MailSessionRuntimes")) {
            string2 = "getMailSessionRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MailSessionRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("MailSessionRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return the runtimeMBeans for JavaMail Mail Sessions ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("MaxThreadsConstraintRuntimes")) {
            string2 = "getMaxThreadsConstraintRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MaxThreadsConstraintRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("MaxThreadsConstraintRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns an array of RuntimeMBeans which exposes this server's globally defined MaxThreadsConstraints.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("MessagingBridgeRuntime")) {
            string2 = "getMessagingBridgeRuntime";
            string = null;
            if (!this.readOnly) {
                string = "setMessagingBridgeRuntime";
            }
            propertyDescriptor = new PropertyDescriptor("MessagingBridgeRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("MessagingBridgeRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> The MessagingBridgeRuntimeMBean for this server </p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3.0", null, (String)this.targetVersion) && !map.containsKey("MiddlewareHome")) {
            string2 = "getMiddlewareHome";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MiddlewareHome", ServerRuntimeMBean.class, string2, string);
            map.put("MiddlewareHome", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The Oracle Middleware installation directory. </p> ");
            propertyDescriptor.setValue("since", "10.3.3.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("MinThreadsConstraintRuntimes")) {
            string2 = "getMinThreadsConstraintRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MinThreadsConstraintRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("MinThreadsConstraintRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns an array of RuntimeMBeans which exposes this server's globally defined MinThreadsConstraints.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("OpenSocketsCurrentCount")) {
            string2 = "getOpenSocketsCurrentCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("OpenSocketsCurrentCount", ServerRuntimeMBean.class, string2, string);
            map.put("OpenSocketsCurrentCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The current number of sockets registered for socket muxing on this server.</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.1.0", null, (String)this.targetVersion) && !map.containsKey("OracleHome")) {
            string2 = "getOracleHome";
            string = null;
            propertyDescriptor = new PropertyDescriptor("OracleHome", ServerRuntimeMBean.class, string2, string);
            map.put("OracleHome", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The directory where Oracle products are installed. </p> Deprecated since 10.3.3 ");
            propertyDescriptor.setValue("deprecated", "WLS can no longer find out what ORACLE_HOME is ");
            propertyDescriptor.setValue("since", "10.3.1.0");
        }
        if (!map.containsKey("OverallHealthState")) {
            string2 = "getOverallHealthState";
            string = null;
            propertyDescriptor = new PropertyDescriptor("OverallHealthState", ServerRuntimeMBean.class, string2, string);
            map.put("OverallHealthState", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Determine the overall health state of this server, taking into account the health of each of its subsystems. See <a href=../../e13941/weblogic/health/HealthState.html>weblogic.health.HealthState</a> for state values. </p> ");
        }
        if (!map.containsKey("PathServiceRuntime")) {
            string2 = "getPathServiceRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("PathServiceRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("PathServiceRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The PathServiceRuntimeMBean for this server.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("PendingRestartSystemResources")) {
            string2 = "getPendingRestartSystemResources";
            string = null;
            propertyDescriptor = new PropertyDescriptor("PendingRestartSystemResources", ServerRuntimeMBean.class, string2, string);
            map.put("PendingRestartSystemResources", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Returns all the System Resources that need to be restarted </p> ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("PersistentStoreRuntimes")) {
            string2 = "getPersistentStoreRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("PersistentStoreRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("PersistentStoreRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the mbeans that provides runtime information for each PersistentStore.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("RequestClassRuntimes")) {
            string2 = "getRequestClassRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("RequestClassRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("RequestClassRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns an array of RuntimeMBeans which exposes this server's globally defined Request Classes.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("adder", "addRequestClassRuntime");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("RestartsTotalCount")) {
            string2 = "getRestartsTotalCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("RestartsTotalCount", ServerRuntimeMBean.class, string2, string);
            map.put("RestartsTotalCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The total number of restarts for this server since the cluster was last started.</p> ");
            propertyDescriptor.setValue("deprecated", "This attribute always returns a value of 0. Please use {@link ServerLifeCycleRuntimeMBean#getNodeManagerRestartCount()} if the NodeManager is used to start servers ");
        }
        if (!map.containsKey("SAFRuntime")) {
            string2 = "getSAFRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SAFRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("SAFRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The SAFRuntimeMBean for this server.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.0.0.0", null, (String)this.targetVersion) && !map.containsKey("SNMPAgentRuntime")) {
            string2 = "getSNMPAgentRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SNMPAgentRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("SNMPAgentRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return the MBean which provides access to the monitoring statistics for WLS SNMP Agent.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "10.0.0.0");
        }
        if (!map.containsKey("SSLListenAddress")) {
            string2 = "getSSLListenAddress";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SSLListenAddress", ServerRuntimeMBean.class, string2, string);
            map.put("SSLListenAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The address on which this server is listening for SSL connections. For example this might return the string: santiago/172.17.9.220</p> ");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by {@link #getURL} ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("SSLListenPort")) {
            string2 = "getSSLListenPort";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SSLListenPort", ServerRuntimeMBean.class, string2, string);
            map.put("SSLListenPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The port on which this server is listening for SSL connections.</p> ");
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by {@link #getURL} ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("ServerChannelRuntimes")) {
            string2 = "getServerChannelRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerChannelRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("ServerChannelRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The network channels that are currently configured on the server.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("ServerClasspath")) {
            string2 = "getServerClasspath";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerClasspath", ServerRuntimeMBean.class, string2, string);
            map.put("ServerClasspath", propertyDescriptor);
            propertyDescriptor.setValue("description", "Get the classpath for this server including domain/lib contents that are automatically picked up and appended to the classpath. ");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("ServerSecurityRuntime")) {
            string2 = "getServerSecurityRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerSecurityRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("ServerSecurityRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return the ServerSecurityRuntimeMBean for this server.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("ServerServiceVersions")) {
            string2 = "getServerServiceVersions";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerServiceVersions", ServerRuntimeMBean.class, string2, string);
            map.put("ServerServiceVersions", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns a map of ServerService names and their versions. The key is the service name and the value is the version string. This method is provided primarily for console and is not intended for remote use. ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("ServerStartupTime")) {
            string2 = "getServerStartupTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ServerStartupTime", ServerRuntimeMBean.class, string2, string);
            map.put("ServerStartupTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "The amount of time taken for the server to transition from <code>STARTING</code> to <code>RUNNING</code> state. ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("SingleSignOnServicesRuntime")) {
            string2 = "getSingleSignOnServicesRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SingleSignOnServicesRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("SingleSignOnServicesRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the runtime interface to publish single sign-on services information. </p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("SocketsOpenedTotalCount")) {
            string2 = "getSocketsOpenedTotalCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SocketsOpenedTotalCount", ServerRuntimeMBean.class, string2, string);
            map.put("SocketsOpenedTotalCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The total number of registrations for socket muxing on this sever.</p> ");
            propertyDescriptor.setValue("deprecated", "Use {@link #getOpenSocketsCurrentCount} instead. Both methods return the same value. This method is being deprecated in favor of the other method. ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.0.0", null, (String)this.targetVersion) && !map.containsKey("StableState")) {
            string2 = "getStableState";
            string = null;
            propertyDescriptor = new PropertyDescriptor("StableState", ServerRuntimeMBean.class, string2, string);
            map.put("StableState", propertyDescriptor);
            propertyDescriptor.setValue("description", "It returns the end state for the server if it's transitioning or the current state if it is already in stable state ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
            propertyDescriptor.setValue("since", "10.3.0.0");
        }
        if (!map.containsKey("State")) {
            string2 = "getState";
            string = null;
            propertyDescriptor = new PropertyDescriptor("State", ServerRuntimeMBean.class, string2, string);
            map.put("State", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The current life cycle state of this server.</p>  <p>For example, a server can be in a RUNNING state in which it can receive and process requests or in an ADMIN state in which it can receive only administrative requests.</p> ");
        }
        if (!map.containsKey("StateVal")) {
            string2 = "getStateVal";
            string = null;
            propertyDescriptor = new PropertyDescriptor("StateVal", ServerRuntimeMBean.class, string2, string);
            map.put("StateVal", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns current state of the server as in integer. {@link weblogic.management.runtime.ServerStates} has more information about the available server states</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("SubsystemHealthStates")) {
            string2 = "getSubsystemHealthStates";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SubsystemHealthStates", ServerRuntimeMBean.class, string2, string);
            map.put("SubsystemHealthStates", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns an array of health states for major subsystems in the server. Exposed only to console to display a table of health states ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("ThreadPoolRuntime")) {
            string2 = "getThreadPoolRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ThreadPoolRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("ThreadPoolRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the self-tuning thread pool's runtime information. This call will return <code>null</code> if the self-tuning implementation is not enabled.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("TimeServiceRuntime")) {
            string2 = "getTimeServiceRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TimeServiceRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("TimeServiceRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the runtime information about the WebLogic timer implementation. </p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("TimerRuntime")) {
            string2 = "getTimerRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TimerRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("TimerRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the runtime information about the WebLogic timer implementation. </p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("WANReplicationRuntime")) {
            string2 = "getWANReplicationRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WANReplicationRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("WANReplicationRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return an MBean which represents this server's view of its WANReplicationRuntime, if any.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("WLDFRuntime")) {
            string2 = "getWLDFRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WLDFRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("WLDFRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return the MBean which provides access to all Diagnostic runtime MBeans.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("WLECConnectionServiceRuntime")) {
            string2 = "getWLECConnectionServiceRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WLECConnectionServiceRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("WLECConnectionServiceRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The WLECConnectionServiceRuntime for this server.</p> ");
        }
        if (!map.containsKey("WTCRuntime")) {
            string2 = "getWTCRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WTCRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("WTCRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The WTCRuntimeMBean for this server.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("WebServerRuntimes")) {
            string2 = "getWebServerRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WebServerRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("WebServerRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Returns all the initialized webservers </p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.1.0", null, (String)this.targetVersion) && !map.containsKey("WeblogicHome")) {
            string2 = "getWeblogicHome";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WeblogicHome", ServerRuntimeMBean.class, string2, string);
            map.put("WeblogicHome", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The directory where the WebLogic Server instance (server) is installed, without the trailing \"/server\".</p> ");
            propertyDescriptor.setValue("since", "10.3.1.0");
        }
        if (!map.containsKey("WeblogicVersion")) {
            string2 = "getWeblogicVersion";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WeblogicVersion", ServerRuntimeMBean.class, string2, string);
            map.put("WeblogicVersion", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The version of this WebLogic Server instance (server).</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("WorkManagerRuntimes")) {
            string2 = "getWorkManagerRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WorkManagerRuntimes", ServerRuntimeMBean.class, string2, string);
            map.put("WorkManagerRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns an array of MBeans which exposes this server's active internal WorkManagers.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.1.2", null, (String)this.targetVersion) && !map.containsKey("WseeClusterFrontEndRuntime")) {
            string2 = "getWseeClusterFrontEndRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WseeClusterFrontEndRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("WseeClusterFrontEndRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "This is non-null only when this server is running as a host to a front-end proxy (HttpClusterServlet) instance. ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "10.3.1.2");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.1.2", null, (String)this.targetVersion) && !map.containsKey("WseeWsrmRuntime")) {
            string2 = "getWseeWsrmRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WseeWsrmRuntime", ServerRuntimeMBean.class, string2, string);
            map.put("WseeWsrmRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "Get statistics for web services reliable messaging across the entire server if any web service is deployed that employs reliable messaging. This MBean is null otherwise. ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "10.3.1.2");
        }
        if (!map.containsKey("AdminServer")) {
            string2 = "isAdminServer";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AdminServer", ServerRuntimeMBean.class, string2, string);
            map.put("AdminServer", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether the server is an Administration Server.</p> ");
        }
        if (!map.containsKey("AdminServerListenPortSecure")) {
            string2 = "isAdminServerListenPortSecure";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AdminServerListenPortSecure", ServerRuntimeMBean.class, string2, string);
            map.put("AdminServerListenPortSecure", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether the port that the server uses for administrative traffic is configured to use a secure protocol.</p> ");
        }
        if (!map.containsKey("AdministrationPortEnabled")) {
            string2 = "isAdministrationPortEnabled";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AdministrationPortEnabled", ServerRuntimeMBean.class, string2, string);
            map.put("AdministrationPortEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether the administration port is enabled on the server</p> ");
        }
        if (!map.containsKey("ClusterMaster")) {
            string2 = "isClusterMaster";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ClusterMaster", ServerRuntimeMBean.class, string2, string);
            map.put("ClusterMaster", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether the server is the ClusterMaster of a cluster which is configured for server migration.</p> ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("ListenPortEnabled")) {
            string2 = "isListenPortEnabled";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ListenPortEnabled", ServerRuntimeMBean.class, string2, string);
            map.put("ListenPortEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether the default listen port is enabled on the server.</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("RestartRequired")) {
            string2 = "isRestartRequired";
            string = null;
            propertyDescriptor = new PropertyDescriptor("RestartRequired", ServerRuntimeMBean.class, string2, string);
            map.put("RestartRequired", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether the server must be restarted in order to activate configuration changes.</p> ");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("SSLListenPortEnabled")) {
            string2 = "isSSLListenPortEnabled";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SSLListenPortEnabled", ServerRuntimeMBean.class, string2, string);
            map.put("SSLListenPortEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Indicates whether the default SSL listen port is enabled on the server</p> ");
        }
        if (!map.containsKey("ShuttingDown")) {
            string2 = "isShuttingDown";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ShuttingDown", ServerRuntimeMBean.class, string2, string);
            map.put("ShuttingDown", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Check if the server is shutting down.</p> ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        Method method = ServerRuntimeMBean.class.getMethod("addRequestClassRuntime", RequestClassRuntimeMBean.class);
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            MethodDescriptor methodDescriptor = new MethodDescriptor(method, null);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "RequestClassRuntimes");
        }
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        Object object;
        MethodDescriptor methodDescriptor;
        Method method = ServerRuntimeMBean.class.getMethod("lookupMinThreadsConstraintRuntime", String.class);
        ParameterDescriptor[] parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(parameterDescriptorArray)) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "MinThreadsConstraintRuntimes");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("lookupRequestClassRuntime", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("since", "9.0.0.0");
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "RequestClassRuntimes");
            methodDescriptor.setValue("since", "9.0.0.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("lookupMaxThreadsConstraintRuntime", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("since", "9.0.0.0");
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "MaxThreadsConstraintRuntimes");
            methodDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("lookupApplicationRuntime", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p> Returns the ApplicationRuntimeMBean asked for, by name. </p> ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "ApplicationRuntimes");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            methodDescriptor.setValue("rolesAllowed", object);
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("lookupLibraryRuntime", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p> Returns the LibraryRuntimeMBean asked for, by name. </p> ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "LibraryRuntimes");
        }
        method = ServerRuntimeMBean.class.getMethod("lookupPersistentStoreRuntime", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ServerRuntimeBeanInfo.createParameterDescriptor((String)"name", null)};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Returns the Runtime mbean for the persistent store with the specified short name. ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "PersistentStoreRuntimes");
        }
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String[] stringArray;
        Object object;
        MethodDescriptor methodDescriptor;
        Method method = ServerRuntimeMBean.class.getMethod("preDeregister", new Class[0]);
        Object object2 = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object2)) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(object2 = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("suspend", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Suspend server. Deny new requests (except by privileged users). Allow pending requests to complete. This operation transitions the server into <code>ADMIN</code> state. Applications and resources are fully available to administrators in <code>ADMIN</code> state. But non-admin users are denied access to applications and resources</p> ");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"#suspend(int, boolean)")};
            methodDescriptor.setValue("see", object);
            methodDescriptor.setValue("role", "operation");
        }
        method = ServerRuntimeMBean.class.getMethod("suspend", Integer.TYPE, Boolean.TYPE);
        object2 = new ParameterDescriptor[]{ServerRuntimeBeanInfo.createParameterDescriptor((String)"timeout", (String)"Seconds to wait for server to transition gracefully. The server calls {@link #forceSuspend()} after timeout. "), ServerRuntimeBeanInfo.createParameterDescriptor((String)"ignoreSessions", (String)"drop inflight HTTP sessions during graceful suspend ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object2);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"ServerLifecycleException server failed to suspend gracefully.  A {@link #forceSuspend()} or a {@link #forceShutdown()} operation can be  invoked.")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Transitions the server from <code>RUNNING</code> to <code>ADMIN</code> state gracefully.</p>  <p>Applications are in admin mode. Inflight work is completed. Applications and resources are fully available to administrators in <code>ADMIN</code> state. But non-admin users are denied access to applications and resources</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(object2 = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("forceSuspend", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"ServerLifecycleException server failed to force suspend.  A {@link #forceShutdown()} operation can be invoked.")};
            methodDescriptor.setValue("throws", object);
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Transitions the server from <code>RUNNING</code> to <code>ADMIN</code> state forcefully cancelling inflight work.</p>  <p>Work that cannot be cancelled is dropped. Applications are brought into the admin mode. This is the supported way of force suspending the server and getting it into <code>ADMIN</code> state. ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(object2 = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("resume", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Resume suspended server. Allow new requests. This operation transitions the server into <code>RUNNING</code> state.</p> ");
            methodDescriptor.setValue("role", "operation");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"Operator")};
            methodDescriptor.setValue("rolesAllowed", object);
        }
        if (!map.containsKey(object2 = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("shutdown", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Gracefully shuts down the server after handling inflight work.</p> ");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"#shutdown(int, boolean)")};
            methodDescriptor.setValue("see", object);
            methodDescriptor.setValue("role", "operation");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Operator")};
            methodDescriptor.setValue("rolesAllowed", stringArray);
        }
        method = ServerRuntimeMBean.class.getMethod("shutdown", Integer.TYPE, Boolean.TYPE);
        object2 = new ParameterDescriptor[]{ServerRuntimeBeanInfo.createParameterDescriptor((String)"timeout", (String)"Number of seconds to wait before aborting inflight work and shutting down the server. "), ServerRuntimeBeanInfo.createParameterDescriptor((String)"ignoreSessions", (String)"<code>true</code> indicates ignore pending HTTP sessions during inflight work handling. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object2);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Gracefully shuts down the server after handling inflight work; optionally ignores pending HTTP sessions while handling inflight work.</p>  <p>The following inflight work is allowed to complete before shutdown:</p>  <ul> <li> <p>Pending transaction's and TLOG checkpoint</p> </li>  <li> <p>Pending HTTP sessions</p> </li>  <li> <p>Pending JMS work</p> </li>  <li> <p>Pending work in the execute queues</p> </li>  <li> <p>RMI requests with transaction context</p> </li> </ul>  <p>Further administrative calls are accepted while the server is completing inflight work. For example a forceShutdown command can be issued to quickly shutdown the server if graceful shutdown takes a long time.</p> ");
            methodDescriptor.setValue("role", "operation");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Operator")};
            methodDescriptor.setValue("rolesAllowed", stringArray);
        }
        if (!map.containsKey(object2 = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("forceShutdown", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Force shutdown the server. Causes the server to reject new requests and fail pending requests.</p> ");
            methodDescriptor.setValue("role", "operation");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"Operator")};
            methodDescriptor.setValue("rolesAllowed", object);
        }
        if (!map.containsKey(object2 = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("start", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("deprecated", "Use {@link #suspend} and {@link #resume} operations instead of lock/unlock. ");
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "Unlocks a server and enables it to receive new requests. <p> Servers can be locked with the <code>java weblogic.Admin LOCK</code> command. In a locked state, a server instance accepts only administrative logins. ");
            methodDescriptor.setValue("role", "operation");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"Operator")};
            methodDescriptor.setValue("rolesAllowed", object);
        }
        method = ServerRuntimeMBean.class.getMethod("getServerChannel", String.class);
        object2 = new ParameterDescriptor[]{ServerRuntimeBeanInfo.createParameterDescriptor((String)"protocol", (String)"the desired protocol ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object2);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The address on which this server is listening for connections that use the specified protocol.</p>  <dl> <dt>Note:</dt>  <dd> <p>The listen address is persisted in the domain's <code>config.xml</code> file, however when a server instance is started, a command-line option can override the persisted listen address. This <code>getServerChannel</code> method returns the listen address that is currently being used, not necessarily the address that is specified in <code>config.xml</code>.</p> </dd> </dl>  <p>The returned address will always be resolved.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ServerRuntimeMBean.class.getMethod("getURL", String.class);
        object2 = new ParameterDescriptor[]{ServerRuntimeBeanInfo.createParameterDescriptor((String)"protocol", (String)"the desired protocol ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object2);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The URL that clients use when connecting to this server using the specified protocol.</p>  <dl> <dt>Note:</dt>  <dd> <p>The listen address and listen port for a given protocol are persisted in the domain's <code>config.xml</code> file, however when a server instance is started, command-line options can override these persisted values. This <code>getURL</code> method returns the URL values that are currently being used, not necessarily the values that are specified in <code>config.xml</code>.</p> </dd> </dl> ");
            methodDescriptor.setValue("role", "operation");
            methodDescriptor.setValue("rolePermitAll", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.1.0", null, (String)this.targetVersion)) {
            method = ServerRuntimeMBean.class.getMethod("getIPv4URL", String.class);
            object2 = new ParameterDescriptor[]{ServerRuntimeBeanInfo.createParameterDescriptor((String)"protocol", (String)"the desired protocol ")};
            object = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(object)) {
                methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object2);
                methodDescriptor.setValue("since", "10.3.1.0");
                map.put(object, methodDescriptor);
                methodDescriptor.setValue("description", "<p>The URL that clients use when connecting to this server using the specified protocol.</p>  <dl> <dt>Note:</dt>  <dd> <p>The listen address and listen port for a given protocol are persisted in the domain's <code>config.xml</code> file, however when a server instance is started, command-line options can override these persisted values. This <code>getURL</code> method returns the URL values that are currently being used, not necessarily the values that are specified in <code>config.xml</code>.</p> </dd> </dl> ");
                methodDescriptor.setValue("role", "operation");
                methodDescriptor.setValue("rolePermitAll", Boolean.TRUE);
                methodDescriptor.setValue("since", "10.3.1.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.1.0", null, (String)this.targetVersion)) {
            method = ServerRuntimeMBean.class.getMethod("getIPv6URL", String.class);
            object2 = new ParameterDescriptor[]{ServerRuntimeBeanInfo.createParameterDescriptor((String)"protocol", (String)"the desired protocol ")};
            object = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(object)) {
                methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object2);
                methodDescriptor.setValue("since", "10.3.1.0");
                map.put(object, methodDescriptor);
                methodDescriptor.setValue("description", "<p>The URL that clients use when connecting to this server using the specified protocol.</p>  <dl> <dt>Note:</dt>  <dd> <p>The listen address and listen port for a given protocol are persisted in the domain's <code>config.xml</code> file, however when a server instance is started, command-line options can override these persisted values. This <code>getURL</code> method returns the URL values that are currently being used, not necessarily the values that are specified in <code>config.xml</code>.</p> </dd> </dl> ");
                methodDescriptor.setValue("role", "operation");
                methodDescriptor.setValue("rolePermitAll", Boolean.TRUE);
                methodDescriptor.setValue("since", "10.3.1.0");
            }
        }
        method = ServerRuntimeMBean.class.getMethod("setHealthState", Integer.TYPE, String.class);
        object2 = new ParameterDescriptor[]{ServerRuntimeBeanInfo.createParameterDescriptor((String)"state", (String)"The new healthState value "), ServerRuntimeBeanInfo.createParameterDescriptor((String)"reason", (String)"The new healthState value ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object2);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>For Server Health Monitoring.</p> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(object2 = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("restartSSLChannels", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "Restart all SSL channels on which the server is listening. This could be necessary because of some change that the server is not aware of, for instance updates to the keystore. ");
            methodDescriptor.setValue("role", "operation");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.0.0", null, (String)this.targetVersion) && !map.containsKey(object2 = BeanInfoHelper.buildMethodKey((Method)(method = ServerRuntimeMBean.class.getMethod("isServiceAvailable", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("since", "10.3.0.0");
            map.put(object2, methodDescriptor);
            methodDescriptor.setValue("description", "<p>returns true iff the named service is available (configured, licensed & running)</p> The service String is either ServerService.EJB, ServerService.CONNECTOR, ServerService.JMS or the Bundle-SymbolicName of a service plugin ");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.server.ServerService")};
            methodDescriptor.setValue("see", object);
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
            methodDescriptor.setValue("rolePermitAll", Boolean.TRUE);
            methodDescriptor.setValue("since", "10.3.0.0");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

