/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.Kernel;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.RunningStateListener;
import weblogic.server.ServerService;
import weblogic.server.ServiceActivator;
import weblogic.server.ServiceFailureException;
import weblogic.server.servicegraph.Service;
import weblogic.servlet.internal.WebAppShutdownService;
import weblogic.t3.srvr.ServerServices;
import weblogic.t3.srvr.SubsystemRequest;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerServicesManager
implements ServerServices {
    private static final DebugCategory debugSLC = Debug.getCategory((String)"weblogic.slc");
    private static final DebugLogger debugSLCWLDF = DebugLogger.getDebugLogger((String)"DebugServerLifeCycle");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    static final ServiceFailureException STARTUP_ABORTED = new ServiceFailureException("Startup aborted");
    static final ServiceFailureException STARTUP_TIMED_OUT = new ServiceFailureException("Startup timed out");
    private static final SubsystemRequest subsystemRequest = new SubsystemRequest();
    private static final ArrayList<ServerService> servicesBeforeAdminState = new ArrayList();
    private static final ArrayList<ServerService> servicesAfterAdminState = new ArrayList();
    private static boolean startupCompleted = false;
    private static int startFromIndex = 0;
    private static boolean forceShutdown;
    private static int currentState;
    private static boolean startupAborted;
    private static boolean checkServicesMemory;
    private static final ArrayList<RunningStateListener> runningListeners;

    private ServerServicesManager() {
    }

    static synchronized void startInStandbyState() throws ServiceFailureException {
        if (ServerServicesManager.debugEnabled()) {
            ServerServicesManager.debug("starting server in standby state");
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        if (checkServicesMemory && ServerServicesManager.debugEnabled()) {
            l5 = MEMORY_MX_BEAN.instance.getHeapMemoryUsage().getUsed();
            l6 = MEMORY_MX_BEAN.instance.getNonHeapMemoryUsage().getUsed();
            ServerServicesManager.debug("[Memory(Heap,NonHeap) used by pre-service-startup before forced gc: (" + l5 + "," + l6 + ")");
            MEMORY_MX_BEAN.instance.gc();
            ServerServicesManager.debug("[Memory(Heap,NonHeap) used by pre-service-startup after gc: (" + MEMORY_MX_BEAN.instance.getHeapMemoryUsage().getUsed() + "," + MEMORY_MX_BEAN.instance.getNonHeapMemoryUsage().getUsed() + ")");
            ServerServicesManager.debug("[Memory(Heap,NonHeap) freed by forced gc: (" + (l5 - MEMORY_MX_BEAN.instance.getHeapMemoryUsage().getUsed()) + "," + (l6 - MEMORY_MX_BEAN.instance.getNonHeapMemoryUsage().getUsed()) + ")");
        }
        for (Service service2 : ServerServicesManager.getServicesBeforeStandbyState()) {
            String string = service2.getServiceClassName();
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("creating service: " + string);
            }
            if (checkServicesMemory) {
                if (ServerServicesManager.debugEnabled()) {
                    ServerServicesManager.debug("Forcing garbage collection to measure memory usage.");
                }
                MEMORY_MX_BEAN.instance.gc();
                l5 = MEMORY_MX_BEAN.instance.getHeapMemoryUsage().getUsed();
                l6 = MEMORY_MX_BEAN.instance.getNonHeapMemoryUsage().getUsed();
            }
            ServerServicesManager.updateStartupSnapshot(string, l, l2);
            ServerService serverService = ServerServicesManager.createService(service2);
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("starting service: " + string);
            }
            l = System.currentTimeMillis();
            ServerServicesManager.startService(serverService, l4);
            servicesBeforeAdminState.add(serverService);
            l2 = System.currentTimeMillis();
            long l7 = 0L;
            if (l3 == 0L) {
                l7 = ServerServicesManager.getStartupTimeout();
            }
            if (l3 == 0L && l7 > 0L) {
                l4 = l3 = l7;
            }
            if (l3 > 0L) {
                l4 = l3 - (l2 - l);
            }
            if (!ServerServicesManager.debugEnabled()) continue;
            ServerServicesManager.debug("Time taken to start " + string + ": " + (l2 - l) + " ms");
            if (!checkServicesMemory) continue;
            ServerServicesManager.debug("[Memory(Heap,NonHeap) used by " + string + ": (" + (MEMORY_MX_BEAN.instance.getHeapMemoryUsage().getUsed() - l5) + "," + (MEMORY_MX_BEAN.instance.getNonHeapMemoryUsage().getUsed() - l6) + ")");
        }
    }

    private static long getStartupTimeout() {
        if (ManagementService.isRuntimeAccessInitialized()) {
            return ManagementService.getRuntimeAccess(kernelId).getServer().getStartupTimeout() * 1000;
        }
        return 0L;
    }

    static synchronized void startInAdminState(long l) throws ServiceFailureException {
        if (ServerServicesManager.debugEnabled()) {
            ServerServicesManager.debug("starting server in admin state");
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l;
        long l5 = 0L;
        long l6 = 0L;
        for (Service service2 : ServerServicesManager.getServicesBeforeAdminState()) {
            String string = service2.getServiceClassName();
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("creating service: " + string);
            }
            if (checkServicesMemory) {
                if (ServerServicesManager.debugEnabled()) {
                    ServerServicesManager.debug("Forcing garbage collection to measure memory usage.");
                }
                MEMORY_MX_BEAN.instance.gc();
                l5 = MEMORY_MX_BEAN.instance.getHeapMemoryUsage().getUsed();
                l6 = MEMORY_MX_BEAN.instance.getNonHeapMemoryUsage().getUsed();
            }
            ServerServicesManager.updateStartupSnapshot(string, l2, l3);
            ServerService serverService = ServerServicesManager.createService(service2);
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("starting service: " + string);
            }
            l2 = System.currentTimeMillis();
            ServerServicesManager.startService(serverService, l4);
            servicesBeforeAdminState.add(serverService);
            l3 = System.currentTimeMillis();
            if (l > 0L) {
                l4 -= l3 - l2;
            }
            if (!ServerServicesManager.debugEnabled()) continue;
            ServerServicesManager.debug("Time taken to start " + string + ": " + (l3 - l2) + " ms");
            if (!checkServicesMemory) continue;
            ServerServicesManager.debug("[Memory(Heap,NonHeap) used by " + string + ": (" + (MEMORY_MX_BEAN.instance.getHeapMemoryUsage().getUsed() - l5) + "," + (MEMORY_MX_BEAN.instance.getNonHeapMemoryUsage().getUsed() - l6) + ")");
        }
    }

    static synchronized void resume(long l) throws ServiceFailureException {
        long l2 = l;
        long l3 = 0L;
        long l4 = 0L;
        if (!startupCompleted) {
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("starting services after admin state");
            }
            for (Service service2 : ServerServicesManager.getServicesAfterAdminState()) {
                String string = service2.getServiceClassName();
                if (ServerServicesManager.debugEnabled()) {
                    ServerServicesManager.debug("creating service: " + string);
                }
                ServerServicesManager.updateStartupSnapshot(string, l3, l4);
                ServerService serverService = ServerServicesManager.createService(service2);
                if (ServerServicesManager.debugEnabled()) {
                    ServerServicesManager.debug("starting service: " + string);
                }
                l3 = System.currentTimeMillis();
                ServerServicesManager.startService(serverService, l2);
                servicesAfterAdminState.add(serverService);
                l4 = System.currentTimeMillis();
                if (l > 0L) {
                    l2 -= l4 - l3;
                }
                if (!ServerServicesManager.debugEnabled()) continue;
                ServerServicesManager.debug("Time taken to start " + string + ": " + (l4 - l3) + " ms");
            }
            startupCompleted = true;
        } else {
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("resuming a suspended server ...");
            }
            for (ServerService serverService : servicesAfterAdminState) {
                if (ServerServicesManager.debugEnabled()) {
                    ServerServicesManager.debug("resuming: " + serverService);
                }
                l3 = System.currentTimeMillis();
                ServerServicesManager.startService(serverService, l2);
                l4 = System.currentTimeMillis();
                if (l <= 0L) continue;
                l2 -= l4 - l3;
            }
        }
    }

    static void stop(int n, boolean bl) throws ServiceFailureException {
        if (n == 17) {
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("graceful suspend of a running server. Will stop services till admin state ...");
            }
            ServerServicesManager.stopInternal(servicesAfterAdminState.toArray(), bl);
            currentState = 17;
        } else {
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("will attempt to stop all services ...");
            }
            if (currentState != 17) {
                ServerServicesManager.stopInternal(servicesAfterAdminState.toArray(), bl);
            }
            ServerServicesManager.stopInternal(servicesBeforeAdminState.toArray(), bl);
        }
    }

    static void halt(int n) {
        if (n == 17) {
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("force suspend a running server. Will halt services till admin state ...");
            }
            ServerServicesManager.haltInternal(servicesAfterAdminState.toArray());
            currentState = 17;
        } else {
            forceShutdown = true;
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("will attempt to halt all services ...");
            }
            if (currentState != 17) {
                ServerServicesManager.haltInternal(servicesAfterAdminState.toArray());
            }
            ServerServicesManager.haltInternal(servicesBeforeAdminState.toArray());
        }
    }

    private static List<Service> getServicesBeforeAdminState() {
        Service service2;
        String string;
        ArrayList<Service> arrayList = new ArrayList<Service>();
        if (ServerServicesManager.debugEnabled()) {
            ServerServicesManager.debug("getting classnames that should be started before admin state");
        }
        for (int i = startFromIndex; i < ServerServices.ORDERED_SUBSYSTEM_LIST.length && !"admin_state".equals(string = (service2 = ServerServices.ORDERED_SUBSYSTEM_LIST[i]).getServiceClassName()); ++i) {
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("[start before admin state] " + string);
            }
            arrayList.add(service2);
        }
        return arrayList;
    }

    private static List<Service> getServicesBeforeStandbyState() {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        if (ServerServicesManager.debugEnabled()) {
            ServerServicesManager.debug("getting classnames that should be started before standby state");
        }
        for (int i = 0; i < ServerServices.ORDERED_SUBSYSTEM_LIST.length; ++i) {
            Service service2 = ServerServices.ORDERED_SUBSYSTEM_LIST[i];
            String string = service2.getServiceClassName();
            if ("standby_state".equals(string)) {
                startFromIndex = i + 1;
                break;
            }
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("[start before standby state] " + string);
            }
            arrayList.add(service2);
        }
        return arrayList;
    }

    private static List<Service> getServicesAfterAdminState() {
        String string;
        int n;
        ArrayList<Service> arrayList = new ArrayList<Service>();
        for (n = 0; n < ServerServices.ORDERED_SUBSYSTEM_LIST.length; ++n) {
            Service service2 = ServerServices.ORDERED_SUBSYSTEM_LIST[n];
            string = service2.getServiceClassName();
            if (!"admin_state".equals(string)) continue;
            if (!ServerServicesManager.debugEnabled()) break;
            ServerServicesManager.debug("admin index is at " + n);
            break;
        }
        Debug.assertion((n > 0 ? 1 : 0) != 0, (String)"admin state not defined in ServerServicesList");
        if (ServerServicesManager.debugEnabled()) {
            ServerServicesManager.debug("getting class names that should be started after admin state");
        }
        for (int i = n + 1; i < ServerServices.ORDERED_SUBSYSTEM_LIST.length; ++i) {
            string = ServerServices.ORDERED_SUBSYSTEM_LIST[i];
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("[start after admin state] " + string.getServiceClassName());
            }
            arrayList.add((Service)string);
        }
        return arrayList;
    }

    private static ServerService createService(Service service2) throws ServiceFailureException {
        String string = null;
        try {
            if (forceShutdown) {
                throw new ServiceFailureException("Startup aborted. Server is shutting down");
            }
            ServiceActivator serviceActivator = service2.getActivator();
            if (serviceActivator == null) {
                string = service2.getServiceClassName();
                Object obj = Class.forName(string).newInstance();
                return (ServerService)obj;
            }
            return serviceActivator;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError("ServerService class " + string + " doesn't implement ServerService", (Throwable)classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("ServerService class " + string + " not found", (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError("ServerService class " + string + " can't be instantiated", (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError("ServerService class " + string + " doesn't hava public constructor", (Throwable)illegalAccessException);
        }
    }

    private static void startService(ServerService serverService, long l) throws ServiceFailureException {
        if (Kernel.isInitialized()) {
            ServerServicesManager.getSubsystemRequest(serverService).start(l);
        } else {
            serverService.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SubsystemRequest getSubsystemRequest(ServerService serverService) throws ServiceFailureException {
        SubsystemRequest subsystemRequest = ServerServicesManager.subsystemRequest;
        synchronized (subsystemRequest) {
            if (startupAborted) {
                throw STARTUP_ABORTED;
            }
            ServerServicesManager.subsystemRequest.setRequest(serverService);
            return ServerServicesManager.subsystemRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void abortStartup() {
        SubsystemRequest subsystemRequest = ServerServicesManager.subsystemRequest;
        synchronized (subsystemRequest) {
            startupAborted = true;
            ServerServicesManager.subsystemRequest.notify(STARTUP_ABORTED);
        }
    }

    private static void stopInternal(Object[] objectArray, boolean bl) throws ServiceFailureException {
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ServerService serverService = (ServerService)objectArray[i];
            if (bl && serverService instanceof WebAppShutdownService) {
                WebAppShutdownService.ignoreSessionsDuringShutdown();
            }
            if (ServerServicesManager.debugEnabled()) {
                ServerServicesManager.debug("calling stop on " + serverService);
            }
            serverService.stop();
        }
    }

    private static void haltInternal(Object[] objectArray) {
        for (int i = objectArray.length - 1; i >= 0; --i) {
            try {
                ServerService serverService = (ServerService)objectArray[i];
                if (ServerServicesManager.debugEnabled()) {
                    ServerServicesManager.debug("calling halt on " + serverService);
                }
                serverService.halt();
                continue;
            }
            catch (ServiceFailureException serviceFailureException) {
                T3SrvrLogger.logServiceFailure((String)("halt call on " + objectArray[i] + " failed"), (Throwable)serviceFailureException);
            }
        }
    }

    public static int getServicesCount() {
        return ServerServices.ORDERED_SUBSYSTEM_LIST.length;
    }

    public static void addRunningStateListener(RunningStateListener runningStateListener) {
        runningListeners.add(runningStateListener);
    }

    static void invokeRunningStateListeners() {
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new WorkAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList arrayList = runningListeners;
                synchronized (arrayList) {
                    for (RunningStateListener runningStateListener : runningListeners) {
                        runningStateListener.onRunning();
                    }
                }
            }
        });
    }

    static HashMap getVersionsOnline() {
        if (!startupCompleted) {
            throw new IllegalStateException("Cannot get ServerServices information till startup is complete");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ServerService serverService : servicesBeforeAdminState) {
            if (serverService.getVersion() == null || serverService.getVersion().trim().length() <= 0) continue;
            hashMap.put(serverService.getName(), serverService.getVersion());
        }
        for (ServerService serverService : servicesAfterAdminState) {
            if (serverService.getVersion() == null || serverService.getVersion().trim().length() <= 0) continue;
            hashMap.put(serverService.getName(), serverService.getVersion());
        }
        return hashMap;
    }

    private static void updateStartupSnapshot(String string, long l, long l2) {
        STARTUP_SNAPSHOT.instance.updateStartupSnapShot(string, l, l2);
    }

    public static StartupSnapshot getStartupSnapshot() {
        return STARTUP_SNAPSHOT.instance;
    }

    private static boolean debugEnabled() {
        return debugSLC.isEnabled() || debugSLCWLDF.isDebugEnabled();
    }

    private static void debug(String string) {
        debugSLCWLDF.debug(string);
    }

    static {
        checkServicesMemory = Boolean.getBoolean("checkServices");
        runningListeners = new ArrayList();
    }

    public static final class StartupSnapshot {
        private static int index = 0;
        private String currentServiceName;
        private String previousServiceName;
        private long previousServiceStartupTime;

        StartupSnapshot() {
        }

        synchronized void updateStartupSnapShot(String string, long l, long l2) {
            this.previousServiceName = this.currentServiceName;
            this.previousServiceStartupTime = l2 - l;
            this.currentServiceName = string;
            ++index;
        }

        public int getCurrentServiceIndex() {
            return index;
        }

        public String getCurrentServiceName() {
            return this.currentServiceName;
        }

        public long getPreviousServiceStartupTime() {
            return this.previousServiceStartupTime;
        }

        public String getPreviousServiceName() {
            return this.previousServiceName;
        }
    }

    private static final class STARTUP_SNAPSHOT {
        static final StartupSnapshot instance = new StartupSnapshot();

        private STARTUP_SNAPSHOT() {
        }
    }

    private static final class MEMORY_MX_BEAN {
        static final MemoryMXBean instance = ManagementFactory.getMemoryMXBean();

        private MEMORY_MX_BEAN() {
        }
    }
}

