/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import java.security.PrivilegedAction;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.UnixMachineMBean;
import weblogic.management.provider.ManagementService;
import weblogic.platform.OperatingSystem;
import weblogic.platform.Unix;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class SetUIDRendezvous {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugCategory dbg = Debug.getCategory((String)"weblogic.DebugSetUID");
    private static final SetUIDRendezvous singleton = new SetUIDRendezvous();
    private boolean canSwitchUsers;
    private final OperatingSystem os = OperatingSystem.getOS();
    private final String privilegedUser;
    private final String privilegedGroup;
    private final String unPrivilegedUser = SetUIDRendezvous.getNonPrivUser();
    private final String unPrivilegedGroup = SetUIDRendezvous.getNonPrivGroup();

    private SetUIDRendezvous() {
        String string = null;
        String string2 = null;
        if ((this.unPrivilegedUser != null || this.unPrivilegedGroup != null) && this.os instanceof Unix && KernelStatus.isServer()) {
            string = this.os.getUser();
            string2 = this.os.getGroup();
            if (string != null || string2 != null) {
                this.canSwitchUsers = true;
            }
        }
        this.privilegedUser = string;
        this.privilegedGroup = string2;
    }

    public static synchronized void initialize() {
        if (dbg.isEnabled()) {
            T3SrvrLogger.logDebugSetUID((String)("current user=" + SetUIDRendezvous.singleton.privilegedUser + " current group=" + SetUIDRendezvous.singleton.privilegedGroup + " target user=" + SetUIDRendezvous.singleton.unPrivilegedUser + " target group=" + SetUIDRendezvous.singleton.unPrivilegedGroup + " canSwithUsers=" + SetUIDRendezvous.singleton.canSwitchUsers));
        }
        singleton.makeUnPrivileged();
    }

    public static synchronized void finish() {
        singleton.makePrivileged();
        singleton.makeUnPrivilegedFinal();
        if (dbg.isEnabled()) {
            T3SrvrLogger.logDebugSetUID((String)"switching uid/gid done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Throwable doPrivileged(PrivilegedAction privilegedAction) {
        Throwable throwable;
        try {
            singleton.makePrivileged();
            if (dbg.isEnabled()) {
                T3SrvrLogger.logDebugSetUID((String)("Running action " + privilegedAction));
            }
            throwable = (Throwable)privilegedAction.run();
            Object var3_2 = null;
        }
        catch (Throwable throwable2) {
            Object var3_3 = null;
            if (dbg.isEnabled()) {
                T3SrvrLogger.logDebugSetUID((String)("Done action " + privilegedAction));
            }
            singleton.makeUnPrivileged();
            throw throwable2;
        }
        if (dbg.isEnabled()) {
            T3SrvrLogger.logDebugSetUID((String)("Done action " + privilegedAction));
        }
        singleton.makeUnPrivileged();
        return throwable;
    }

    private void setUser(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            this.os.setUser(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            T3SrvrLogger.logCantSwitchToUser((String)string, (Throwable)illegalArgumentException);
            return;
        }
        T3SrvrLogger.logSwitchedToUser((String)string);
    }

    private void setGroup(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            this.os.setGroup(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            T3SrvrLogger.logCantSwitchToGroup((String)string, (Throwable)illegalArgumentException);
            return;
        }
        T3SrvrLogger.logSwitchedToGroup((String)string);
    }

    private void setEUser(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (dbg.isEnabled()) {
            T3SrvrLogger.logDebugSetUID((String)("Switching user to " + string));
        }
        try {
            this.os.setEffectiveUser(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            T3SrvrLogger.logCantSwitchToUser((String)string, (Throwable)illegalArgumentException);
            return;
        }
        if (dbg.isEnabled()) {
            T3SrvrLogger.logDebugSetUID((String)("Switched user to " + string));
        }
    }

    private void setEGroup(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (dbg.isEnabled()) {
            T3SrvrLogger.logDebugSetUID((String)("Switching group to " + string));
        }
        try {
            this.os.setEffectiveGroup(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            T3SrvrLogger.logCantSwitchToGroup((String)string, (Throwable)illegalArgumentException);
            return;
        }
        if (dbg.isEnabled()) {
            T3SrvrLogger.logDebugSetUID((String)("Switched group to " + string));
        }
    }

    private void makeUnPrivilegedFinal() {
        if (!this.canSwitchUsers) {
            return;
        }
        this.canSwitchUsers = false;
        this.setGroup(this.unPrivilegedGroup);
        this.setUser(this.unPrivilegedUser);
        this.verifyReal(this.unPrivilegedGroup, this.unPrivilegedUser);
    }

    private void makeUnPrivileged() {
        if (!this.canSwitchUsers) {
            return;
        }
        this.setEGroup(this.unPrivilegedGroup);
        this.setEUser(this.unPrivilegedUser);
        this.verifyEffective(this.unPrivilegedGroup, this.unPrivilegedUser);
    }

    private void makePrivileged() {
        if (!this.canSwitchUsers) {
            return;
        }
        this.setEGroup(this.privilegedGroup);
        this.setEUser(this.privilegedUser);
        this.verifyEffective(this.privilegedGroup, this.privilegedUser);
    }

    private void verifyEffective(String string, String string2) {
        String string3;
        if (string != null && !string.equals(string3 = this.os.getEffectiveGroup())) {
            throw new AssertionError((Object)(string + "!=" + string3));
        }
        if (string2 != null && !string2.equals(string3 = this.os.getEffectiveUser())) {
            throw new AssertionError((Object)(string2 + " != " + string3));
        }
    }

    private void verifyReal(String string, String string2) {
        String string3;
        if (string != null && !string.equals(string3 = this.os.getGroup())) {
            throw new AssertionError((Object)(string + "!=" + string3));
        }
        if (string2 != null && !string2.equals(string3 = this.os.getUser())) {
            throw new AssertionError((Object)(string2 + " != " + string3));
        }
    }

    private static String getNonPrivUser() {
        UnixMachineMBean unixMachineMBean;
        if (!KernelStatus.isServer()) {
            return null;
        }
        String string = null;
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        MachineMBean machineMBean = serverMBean.getMachine();
        if (machineMBean != null && machineMBean instanceof UnixMachineMBean && (unixMachineMBean = (UnixMachineMBean)machineMBean).isPostBindUIDEnabled()) {
            string = unixMachineMBean.getPostBindUID();
        }
        return string;
    }

    private static String getNonPrivGroup() {
        UnixMachineMBean unixMachineMBean;
        if (!KernelStatus.isServer()) {
            return null;
        }
        String string = null;
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        MachineMBean machineMBean = serverMBean.getMachine();
        if (machineMBean != null && machineMBean instanceof UnixMachineMBean && (unixMachineMBean = (UnixMachineMBean)machineMBean).isPostBindGIDEnabled()) {
            string = unixMachineMBean.getPostBindGID();
        }
        return string;
    }
}

