/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import weblogic.management.runtime.ServerStates;
import weblogic.server.ServerService;
import weblogic.server.ServiceFailureException;
import weblogic.t3.srvr.ServerServicesManager;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

final class SubsystemRequest
extends WorkAdapter
implements ServerStates {
    private ServerService slc;
    private Throwable t;
    private boolean done;
    private final boolean concurrent;
    private int action;

    private SubsystemRequest(ServerService serverService, boolean bl) {
        this.slc = serverService;
        this.concurrent = bl;
    }

    SubsystemRequest(ServerService serverService) {
        this(serverService, false);
    }

    SubsystemRequest() {
        this(null, false);
    }

    void setRequest(ServerService serverService) {
        this.slc = serverService;
    }

    public void start(long l) throws ServiceFailureException {
        this.action(6, l);
    }

    public void run() {
        try {
            switch (this.action) {
                case 4: {
                    this.slc.stop();
                    break;
                }
                case 3: {
                    this.slc.halt();
                    break;
                }
                case 6: {
                    this.slc.start();
                    break;
                }
                default: {
                    throw new ServiceFailureException("Unknown ServerLifeCycle action");
                }
            }
            this.notify(true);
        }
        catch (Throwable throwable) {
            this.notify(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void action(int n, long l) throws ServiceFailureException {
        try {
            this.action = n;
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)this));
            if (!this.concurrent) {
                this.rendezvouz(l);
            }
            Object var5_3 = null;
            this.t = null;
            this.done = false;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.t = null;
            this.done = false;
            throw throwable;
        }
    }

    private synchronized void rendezvouz(long l) throws ServiceFailureException {
        long l2 = System.currentTimeMillis();
        while (this.notDone()) {
            try {
                if (l != 0L && System.currentTimeMillis() - l2 >= l) {
                    this.slc.halt();
                    throw ServerServicesManager.STARTUP_TIMED_OUT;
                }
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.t != null) {
            if (this.t instanceof ServiceFailureException) {
                throw (ServiceFailureException)this.t;
            }
            if (this.t instanceof RuntimeException) {
                throw (RuntimeException)this.t;
            }
            if (this.t instanceof Error) {
                throw (Error)this.t;
            }
        }
    }

    synchronized void notify(Throwable throwable) {
        this.t = throwable;
        this.notify();
    }

    private synchronized void notify(boolean bl) {
        this.done = true;
        this.notify();
    }

    private final boolean notDone() {
        return !this.done && this.t == null;
    }
}

