/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.common.AdminServicesDef;
import weblogic.common.LogServicesDef;
import weblogic.common.NameServicesDef;
import weblogic.common.T3Client;
import weblogic.common.T3Exception;
import weblogic.common.T3ServicesDef;
import weblogic.common.internal.LogOutputStream;
import weblogic.io.common.IOServicesDef;
import weblogic.io.common.internal.IOServicesServerImpl;
import weblogic.jdbc.common.JdbcServicesDef;
import weblogic.jndi.Environment;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.provider.ManagementService;
import weblogic.platform.VM;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifecycleException;
import weblogic.t3.srvr.T3Srvr;
import weblogic.t3.srvr.T3SrvrTextTextFormatter;
import weblogic.time.common.Schedulable;
import weblogic.time.common.ScheduledTriggerDef;
import weblogic.time.common.Scheduler;
import weblogic.time.common.TimeServicesDef;
import weblogic.time.common.TimeTriggerException;
import weblogic.time.common.Trigger;
import weblogic.time.common.Triggerable;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.time.server.ScheduledTrigger;
import weblogic.utils.AssertionError;
import weblogic.version;

public class T3ServerServices
implements T3ServicesDef,
AdminServicesDef,
JdbcServicesDef,
TimeServicesDef,
NameServicesDef {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private IOServicesDef ioSvc;
    LogOutputStream los = new LogOutputStream("T3Services");

    public AdminServicesDef admin() {
        return this;
    }

    public JdbcServicesDef jdbc() {
        return null;
    }

    public LogServicesDef log() {
        return this.los;
    }

    public NameServicesDef name() {
        return this;
    }

    public IOServicesDef io() {
        if (this.ioSvc != null) {
            return this.ioSvc;
        }
        try {
            this.ioSvc = new IOServicesServerImpl(this);
            return this.ioSvc;
        }
        catch (T3Exception t3Exception) {
            throw new AssertionError("Failed to instantiate IOServicesImpl: " + (Object)((Object)t3Exception));
        }
    }

    public TimeServicesDef time() {
        return this;
    }

    public String ping(byte[] byArray) {
        return "OK";
    }

    public String shut(int n) throws ServerLifecycleException {
        return this.shut(null, n);
    }

    public String shut() throws ServerLifecycleException {
        return this.shut(null, -1);
    }

    public String shut(String string, int n) throws ServerLifecycleException {
        if (n >= 0) {
            T3Srvr.getT3Srvr().setShutdownWaitSecs(n);
        }
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().shutdown();
        T3SrvrTextTextFormatter t3SrvrTextTextFormatter = new T3SrvrTextTextFormatter();
        return t3SrvrTextTextFormatter.getServerShutdownSuccessfully(ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getName());
    }

    public String cancelShut() {
        return T3Srvr.getT3Srvr().cancelShutdown();
    }

    public String version() {
        return version.getVersions();
    }

    public String lockServer(String string) {
        return T3Srvr.getT3Srvr().getLockoutManager().lockServer(string);
    }

    public String unlockServer() {
        return T3Srvr.getT3Srvr().getLockoutManager().unlockServer();
    }

    public void enableWatchDog(int n) {
        T3SrvrLogger.logEnableWatchDogNotPermitted();
    }

    public void disableWatchDog() {
        T3SrvrLogger.logDisableWatchDogNotPermitted();
    }

    public void threadDump() {
        VM.getVM().threadDump();
    }

    public ScheduledTriggerDef getScheduledTrigger(Schedulable schedulable, Triggerable triggerable) {
        ScheduledTrigger scheduledTrigger = new ScheduledTrigger(schedulable, triggerable, TimeEventGenerator.getOne());
        return scheduledTrigger;
    }

    public ScheduledTriggerDef getScheduledTrigger(Scheduler scheduler, Trigger trigger) throws TimeTriggerException {
        scheduler.private_initialize(this);
        if (trigger.theObject() == null && trigger.className().equals(scheduler.className())) {
            trigger.private_set_instance((Triggerable)scheduler.theObject());
        }
        trigger.private_initialize(this);
        return this.getScheduledTrigger((Schedulable)scheduler.theObject(), (Triggerable)trigger.theObject());
    }

    public long currentTimeMillis() throws T3Exception {
        return System.currentTimeMillis();
    }

    public int getRoundTripDelayMillis() throws T3Exception {
        return 0;
    }

    public int getLocalClockOffsetMillis() throws T3Exception {
        return 0;
    }

    public void resetPool(String string) {
        throw new UnsupportedOperationException();
    }

    public void shrinkPool(String string) {
        throw new UnsupportedOperationException();
    }

    public Context getInitialContext() throws NamingException {
        return this.getInitialContext(new Hashtable());
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        return new Environment(hashtable).getInitialContext();
    }

    public void private_setT3Client(T3Client t3Client) {
    }
}

