/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Date;
import java.util.List;
import weblogic.common.T3ServicesDef;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.Kernel;
import weblogic.kernel.T3SrvrLogger;
import weblogic.logging.LogOutputStream;
import weblogic.logging.LoggingHelper;
import weblogic.management.configuration.OverloadProtectionMBean;
import weblogic.management.internal.InteractiveConfigurationException;
import weblogic.management.provider.CommandLine;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerStates;
import weblogic.platform.OperatingSystem;
import weblogic.platform.VM;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.SecurityInitializationException;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.PluginUtils;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.ServerResource;
import weblogic.security.service.SubjectManagerImpl;
import weblogic.security.spi.Resource;
import weblogic.security.subject.SubjectManager;
import weblogic.server.ServerLifecycleException;
import weblogic.server.ServiceFailureException;
import weblogic.t3.srvr.ServerLifeCycleTimerThread;
import weblogic.t3.srvr.ServerLockoutManager;
import weblogic.t3.srvr.ServerRuntime;
import weblogic.t3.srvr.ServerServicesManager;
import weblogic.t3.srvr.T3ServerServices;
import weblogic.t3.srvr.T3SrvrConsole;
import weblogic.t3.srvr.T3SrvrTextTextFormatter;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.FileUtils;
import weblogic.utils.collections.NumericKeyHashMap;

public final class T3Srvr {
    private static final DebugCategory debugSLC = Debug.getCategory((String)"weblogic.slc");
    private static final DebugLogger debugSLCWLDF = DebugLogger.getDebugLogger((String)"DebugServerLifeCycle");
    private static final DebugLogger loggerSERVER_START_STATISTICS = DebugLogger.getDebugLogger((String)"DebugServerStartStatistics");
    public static final int RESTARTABLE_EXIT_CODE = 1;
    public static final int NON_RESTARTABLE_EXIT_CODE = -1;
    public static final int PANIC_EXIT_CODE = 65;
    private static AuthenticatedSubject kernelId;
    private static T3Srvr singleton;
    private final LogOutputStream log = new LogOutputStream("WebLogicServer");
    private final ThreadGroup tg = new ThreadGroup("WebLogicServer");
    private AuthorizationManager am;
    private ServerLockoutManager lockoutManager;
    private ServerRuntime serverRuntimeMBean;
    private long startTime;
    private long startupTime;
    private boolean abortStartupAfterAdminState;
    private boolean started;
    private int srvrState = 0;
    private int exitCode = 0;
    private boolean preventShutdownHook = Boolean.getBoolean("weblogic.system.disableShutdownHook");
    private int fallbackState = 0;
    private boolean isShuttingDown = false;
    private static final String restartFileName = "wls.restartfile";
    private static File restartFile;
    private static final DebugCategory debugExceptions;
    private int shutWaitSecs = 0;
    private final T3ServerServices svcs = new T3ServerServices();
    private static final String PAUSE = "weblogic.sleepOnStartSecs";
    private static int numRestartsSoFar;

    public static T3Srvr getT3Srvr() {
        if (singleton == null) {
            throw new IllegalStateException("Calling getT3Srvr() too early. This can happen when you have a static initializer or static variable pointing to T3Srvr.getT3Srvr() and your class is getting loaded prior to T3Srvr.");
        }
        return singleton;
    }

    public ServerLockoutManager getLockoutManager() {
        return this.lockoutManager;
    }

    public LogOutputStream getLog() {
        return this.log;
    }

    long getStartTime() {
        return this.startTime;
    }

    long getStartupTime() {
        return this.startupTime;
    }

    ThreadGroup getStartupThreadGroup() {
        return this.tg;
    }

    private synchronized void setState(int n) {
        if (!StateChangeValidator.validate(this.srvrState, n)) {
            String string = "trying to set illegal state, present state " + this.getState() + ", new state " + ServerStates.SERVERSTATES[n];
            throw new IllegalStateException(string);
        }
        this.srvrState = n;
        if (this.serverRuntimeMBean != null) {
            this.serverRuntimeMBean.updateRunState(n);
        }
        T3SrvrLogger.logServerStateChange((String)this.getState());
    }

    public synchronized void failed(String string) {
        if (this.srvrState == 8) {
            return;
        }
        int n = this.srvrState;
        if (string != null) {
            T3SrvrLogger.logServerHealthFailed((String)string);
        }
        this.setState(8);
        T3Srvr.logThreadDump();
        try {
            OverloadProtectionMBean overloadProtectionMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getOverloadProtection();
            if ("force-shutdown".equals(overloadProtectionMBean.getFailureAction())) {
                T3SrvrLogger.logShuttingDownOnFailure();
                this.exitCode = 1;
                singleton.shutdown(false, true);
            } else if (T3Srvr.isServerBeyondAdminState(n) && "admin-state".equals(overloadProtectionMBean.getFailureAction())) {
                T3SrvrLogger.logSuspendingOnFailure();
                singleton.suspend(false, true);
            }
        }
        catch (ServerLifecycleException serverLifecycleException) {
            serverLifecycleException.printStackTrace();
        }
    }

    public void failedForceShutdown(String string) {
        if (string != null) {
            T3SrvrLogger.logServerHealthFailed((String)string);
        }
        this.setState(8);
        T3Srvr.logThreadDump();
        T3SrvrLogger.logShuttingDownOnFailure();
        this.exitCode = 1;
        try {
            singleton.shutdown(false, true);
        }
        catch (ServerLifecycleException serverLifecycleException) {
            this.exitImmediately(serverLifecycleException);
        }
    }

    public boolean isShutdownDueToFailure() {
        return this.exitCode == 1;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    static void logThreadDump() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        VM.getVM().threadDump(printWriter);
        printWriter.close();
        LoggingHelper.getServerLogger().severe(stringWriter.toString());
    }

    private synchronized void setFailedState(Throwable throwable, boolean bl) {
        if (throwable == ServerServicesManager.STARTUP_ABORTED) {
            return;
        }
        if (throwable == ServerServicesManager.STARTUP_TIMED_OUT) {
            T3Srvr.logThreadDump();
        }
        if (throwable != null && (bl || debugExceptions.isEnabled())) {
            T3SrvrLogger.logServerSubsystemFailedWithTrace((Throwable)throwable);
        } else {
            T3SrvrLogger.logServerSubsystemFailed((String)throwable.getMessage());
        }
        this.setState(8);
        try {
            if (this.fallbackState == 17) {
                T3SrvrLogger.logSuspendingOnFailure();
                singleton.suspend(false, true);
                return;
            }
            if (this.fallbackState == 0) {
                T3SrvrLogger.logShuttingDownOnFailure();
                singleton.shutdown(false, true);
            }
        }
        catch (ServerLifecycleException serverLifecycleException) {
            serverLifecycleException.printStackTrace();
        }
    }

    public void exitImmediately(Throwable throwable) {
        T3Srvr.signalCriticalFailure("There is a panic condition in the server. The server is configured to exit on panic", throwable);
        this.setPreventShutdownHook();
        JrveVM.setShutdownAction(65);
        System.exit(65);
    }

    public int getRunState() {
        return this.srvrState;
    }

    public String getState() {
        return ServerStates.SERVERSTATES[this.srvrState];
    }

    public int getStableState() {
        int n = this.srvrState;
        switch (this.srvrState) {
            case 1: {
                try {
                    String string = this.getStartupMode();
                    if (this.abortStartupAfterAdminState || string != null && "ADMIN".equalsIgnoreCase(string)) {
                        n = 17;
                        break;
                    }
                    n = 2;
                }
                catch (ServerLifecycleException serverLifecycleException) {
                    n = 9;
                }
                break;
            }
            case 4: 
            case 5: 
            case 17: {
                if (this.isShuttingDown()) {
                    n = 9;
                    break;
                }
                n = 17;
                break;
            }
            case 2: 
            case 6: {
                n = 2;
                break;
            }
            case 7: 
            case 11: 
            case 18: {
                n = 9;
            }
        }
        return n;
    }

    public void setShutdownWaitSecs(int n) {
        this.shutWaitSecs = n;
    }

    public T3ServicesDef getT3Services() {
        return this.svcs;
    }

    public static int run(String[] stringArray) {
        T3Srvr.pauseBeforeStartup();
        try {
            T3Srvr.initSubjectManager();
            SecurityServiceManager.initJava2Security();
            kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                System.setSecurityManager(new SecurityManager(){

                    public void checkRead(String string) {
                    }
                });
            }
            new T3Srvr();
            SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId);
            singleton.addShutdownHook();
            singleton.startup();
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
            }
        }
        catch (ServerLifecycleException serverLifecycleException) {
            T3Srvr.singleton.preventShutdownHook = true;
            JrveVM.setShutdownAction(-1);
            return -1;
        }
        catch (Throwable throwable) {
            T3Srvr.singleton.preventShutdownHook = true;
            T3Srvr.handleFatalInitializationException(throwable);
            if (singleton != null) {
                singleton.setState(18);
            }
            JrveVM.setShutdownAction(-1);
            return -1;
        }
        try {
            singleton.waitForDeath();
            JrveVM.setShutdownAction(T3Srvr.singleton.exitCode);
            return T3Srvr.singleton.exitCode;
        }
        catch (Throwable throwable) {
            T3SrvrLogger.logErrorWhileServerShutdown((Throwable)throwable);
            T3Srvr.singleton.preventShutdownHook = true;
            JrveVM.setShutdownAction(-1);
            return -1;
        }
    }

    private static void deleteRestartFile() {
        if (restartFile != null) {
            restartFile.delete();
        }
    }

    private void startup() throws ServerLifecycleException {
        long l;
        long l2 = l = System.currentTimeMillis();
        VersionInfoFactory.initialize(true);
        if (OperatingSystem.isJRVE()) {
            try {
                long l3;
                restartFile = new File(restartFileName);
                if (!restartFile.exists()) {
                    if (debugSLC.isEnabled()) {
                        debugSLCWLDF.debug("Creating new HA restart file: " + restartFile.getName());
                    }
                    restartFile.createNewFile();
                    numRestartsSoFar = 0;
                    l3 = l2;
                } else {
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(restartFile));
                    try {
                        numRestartsSoFar = dataInputStream.readInt();
                        l3 = dataInputStream.readLong();
                        long l4 = (l2 - l3) / 1000L / 60L;
                        long l5 = (l2 - l3) / 1000L - l4 * 60L;
                        if (debugSLC.isEnabled()) {
                            debugSLCWLDF.debug(String.format("There have been %d restarts since the start %d minutes and %d seconds ago at %s%n", numRestartsSoFar, l4, l5, new Date(l3)));
                        }
                    }
                    catch (EOFException eOFException) {
                        numRestartsSoFar = 0;
                        l3 = l2;
                    }
                }
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(restartFile));
                dataOutputStream.writeInt(++numRestartsSoFar);
                dataOutputStream.writeLong(l3);
                dataOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ServerLifecycleException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new ServerLifecycleException(iOException);
            }
        }
        singleton.initializeStandby();
        long l6 = ManagementService.getRuntimeAccess(kernelId).getServer().getStartupTimeout();
        if (l6 > 0L) {
            l6 = T3Srvr.updateStartTimeout(l6 * 1000L, l2);
        }
        String string = this.getStartupMode();
        if (debugSLC.isEnabled()) {
            debugSLCWLDF.debug("Server startup mode is " + string);
        }
        if (!"STANDBY".equalsIgnoreCase(string)) {
            l2 = System.currentTimeMillis();
            singleton.initializeAdmin(l6);
            if (this.abortStartupAfterAdminState || "ADMIN".equalsIgnoreCase(string)) {
                this.fallbackState = 17;
            } else {
                if (l6 > 0L) {
                    l6 = T3Srvr.updateStartTimeout(l6, l2);
                }
                singleton.resume(l6);
            }
        }
        T3SrvrLogger.logServerStarted1((String)singleton.getState());
        this.startupTime = this.getElapsedStartTime(l);
        this.logStartupStatistics();
        this.started = true;
        this.isShuttingDown = false;
    }

    private long getStartBeginTime() {
        long l;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Method method = classLoader.getClass().getMethod("getCreationTime", new Class[0]);
            this.startTime = l = ((Long)method.invoke((Object)classLoader, new Object[0])).longValue();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            l = System.currentTimeMillis();
        }
        return l;
    }

    private long getElapsedStartTime(long l) throws ServerLifecycleException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        String string = System.getProperty("launch.time.log");
        if (string != null) {
            System.out.println("Startup completed in " + l3 + "ms.");
            try {
                String string2 = l3 + "\n";
                File file = new File(string);
                if (!file.exists() || file.length() == 0L) {
                    string2 = System.getProperty("java.vm.name") + " " + System.getProperty("java.runtime.version") + " " + new Date().toString() + System.getProperty("line.separator") + string2;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write(string2.getBytes());
                fileOutputStream.close();
                System.out.println("Logged to " + file.getAbsolutePath());
            }
            catch (Exception exception) {
                System.out.println("Failed to log: " + exception);
            }
            this.shutdown(false, true);
        }
        return l3;
    }

    private void logStartupStatistics() {
        if (!loggerSERVER_START_STATISTICS.isDebugEnabled()) {
            return;
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        memoryMXBean.gc();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage memoryUsage2 = memoryMXBean.getNonHeapMemoryUsage();
        List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
        long l = 0L;
        long l2 = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            MemoryUsage memoryUsage3 = memoryPoolMXBean.getUsage();
            MemoryUsage memoryUsage4 = memoryPoolMXBean.getPeakUsage();
            loggerSERVER_START_STATISTICS.debug("MemoryPool(name,type,current,peak):" + memoryPoolMXBean.getName() + "," + (Object)((Object)memoryPoolMXBean.getType()) + "," + memoryUsage3.getUsed() + "," + memoryUsage4.getUsed());
            if (memoryPoolMXBean.getType() == MemoryType.HEAP) {
                l += memoryUsage4.getUsed();
                continue;
            }
            l2 += memoryUsage4.getUsed();
        }
        loggerSERVER_START_STATISTICS.debug("Statistics(time,heap,peakheap,nonheap,peaknonheap):" + this.startupTime + "," + memoryUsage.getUsed() + "," + l + "," + memoryUsage2.getUsed() + "," + l2);
    }

    private String getStartupMode() throws ServerLifecycleException {
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getStartupMode();
        try {
            if ("STANDBY".equalsIgnoreCase(string)) {
                T3Srvr.ensureAdminChannel();
            }
            return string;
        }
        catch (ServerLifecycleException serverLifecycleException) {
            singleton.setFailedState(serverLifecycleException, false);
            throw serverLifecycleException;
        }
    }

    private static long updateStartTimeout(long l, long l2) throws ServerLifecycleException {
        long l3 = l - (System.currentTimeMillis() - l2);
        if (l3 <= 0L) {
            singleton.setFailedState(ServerServicesManager.STARTUP_TIMED_OUT, false);
            throw new ServerLifecycleException("Startup timed out");
        }
        return l3;
    }

    private static void ensureAdminChannel() throws ServerLifecycleException {
        if (!T3Srvr.isAdminChannelEnabled()) {
            T3SrvrTextTextFormatter t3SrvrTextTextFormatter = new T3SrvrTextTextFormatter();
            throw new ServerLifecycleException(t3SrvrTextTextFormatter.getStartupWithoutAdminChannel());
        }
    }

    private static boolean isAdminChannelEnabled() {
        return ChannelHelper.isLocalAdminChannelEnabled();
    }

    private static void pauseBeforeStartup() {
        block5: {
            try {
                int n = 30;
                if (System.getProperty(PAUSE) == null) break block5;
                try {
                    n = Integer.parseInt(System.getProperty(PAUSE));
                }
                catch (Exception exception) {
                    System.out.println("Server Failed parse time, using default of: '" + n + "'");
                }
                System.out.println("Server Sleeping for: '" + n + "' seconds");
                Thread.sleep(n * 1000);
                System.out.println("Server Waking");
            }
            catch (AccessControlException accessControlException) {
            }
            catch (Exception exception) {
                System.out.println("Server Failed to sleep");
            }
        }
    }

    private static void initSubjectManager() {
        Object object = PluginUtils.createPlugin(SubjectManager.class, (String)CommandLine.getCommandLine().getSecurityFWSubjectManagerClassNameProp());
        if (object != null) {
            SubjectManager.setSubjectManager((SubjectManager)((SubjectManager)object));
        } else {
            SubjectManager.setSubjectManager((SubjectManager)new SubjectManagerImpl());
        }
    }

    private static void handleFatalInitializationException(Throwable throwable) {
        String string = throwable.getMessage();
        Throwable throwable2 = throwable.getCause();
        if (throwable instanceof Error || throwable2 instanceof InteractiveConfigurationException || throwable2 instanceof SecurityInitializationException || throwable2 instanceof AccessControlException || throwable instanceof SecurityInitializationException) {
            T3Srvr.signalCriticalFailure(string, null);
            return;
        }
        StringBuffer stringBuffer = string == null ? new StringBuffer() : new StringBuffer(string);
        while (throwable2 != null) {
            String string2 = throwable2.getMessage();
            if (string != null) {
                if (string2 != null && string.indexOf(string2) == -1) {
                    stringBuffer.append(string2);
                }
            } else if (string2 != null) {
                stringBuffer.append(string2);
            }
            throwable = throwable2;
            throwable2 = throwable.getCause();
        }
        try {
            if (Kernel.isInitialized()) {
                T3SrvrLogger.logNotInitialized((String)stringBuffer.toString());
            }
            T3Srvr.signalCriticalFailure(stringBuffer.toString(), throwable);
        }
        catch (Throwable throwable3) {
            System.err.println("Unable to dump log: '" + throwable3.getMessage() + "'");
        }
    }

    private static void signalCriticalFailure(String string, Throwable throwable) {
        System.out.flush();
        System.err.println("***************************************************************************");
        System.err.println("The WebLogic Server encountered a critical failure");
        if (throwable != null) {
            if (throwable instanceof RuntimeException || throwable instanceof Error || throwable instanceof ServiceFailureException) {
                throwable.printStackTrace();
            } else {
                System.err.println("Exception raised: '" + throwable + "'");
            }
        }
        if (string != null && string.length() > 0) {
            System.err.println("Reason: " + string);
        }
        if (throwable instanceof AccessControlException) {
            System.err.println("Check you have both java.security.manager and java.security.policy defined");
        }
        System.err.println("***************************************************************************");
    }

    private T3Srvr() {
        StateChangeValidator.initialize();
        singleton = this;
    }

    void initializeServerRuntime(ServerRuntime serverRuntime) {
        this.serverRuntimeMBean = serverRuntime;
        this.setState(1);
    }

    private void initializeStandby() throws ServerLifecycleException {
        try {
            this.startTime = System.currentTimeMillis();
            ServerServicesManager.startInStandbyState();
            this.lockoutManager = new ServerLockoutManager();
            this.am = SecurityServiceManager.getAuthorizationManager((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT");
            singleton.setState(3);
        }
        catch (ServiceFailureException serviceFailureException) {
            singleton.setFailedState(serviceFailureException, false);
            throw new ServerLifecycleException(serviceFailureException);
        }
        catch (Throwable throwable) {
            singleton.setFailedState(throwable, true);
            throw new ServerLifecycleException(throwable);
        }
    }

    private void initializeAdmin(long l) throws ServerLifecycleException {
        try {
            this.startTime = System.currentTimeMillis();
            this.setState(1);
            ServerServicesManager.startInAdminState(l);
            singleton.setState(17);
        }
        catch (ServiceFailureException serviceFailureException) {
            singleton.setFailedState(serviceFailureException, false);
            throw new ServerLifecycleException(serviceFailureException);
        }
        catch (Throwable throwable) {
            singleton.setFailedState(throwable, true);
            throw new ServerLifecycleException(throwable);
        }
    }

    void resume() throws ServerLifecycleException {
        long l = ManagementService.getRuntimeAccess(kernelId).getServer().getStartupTimeout() * 1000;
        this.checkPrivileges("unlock");
        this.resume(l);
    }

    private void resume(long l) throws ServerLifecycleException {
        try {
            if (this.srvrState == 2) {
                return;
            }
            long l2 = l;
            if (this.srvrState == 3) {
                long l3 = System.currentTimeMillis();
                this.initializeAdmin(l2);
                if (l2 > 0L) {
                    l2 = T3Srvr.updateStartTimeout(l2, l3);
                }
            }
            singleton.setState(6);
            ServerServicesManager.resume(l2);
            this.setState(2);
            ServerServicesManager.invokeRunningStateListeners();
            this.fallbackState = -1;
        }
        catch (ServiceFailureException serviceFailureException) {
            singleton.setFailedState(serviceFailureException, false);
            throw new ServerLifecycleException(serviceFailureException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ServerLifecycleException(illegalStateException);
        }
        catch (Throwable throwable) {
            singleton.setFailedState(throwable, true);
            throw new ServerLifecycleException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDeath() {
        do {
            Object object;
            if (ManagementService.getRuntimeAccess(kernelId).getServer().isConsoleInputEnabled()) {
                object = new T3SrvrConsole();
                ((T3SrvrConsole)object).processCommands();
                continue;
            }
            object = this;
            synchronized (object) {
                while (this.isWaitingToDie()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } while (this.isWaitingToDie());
    }

    private boolean isWaitingToDie() {
        return this.srvrState == 2 || this.srvrState == 3 || this.srvrState == 17;
    }

    void gracefulShutdown(boolean bl) throws ServerLifecycleException {
        this.checkShutdownPrivileges();
        this.shutdown(true, bl);
    }

    void forceShutdown() throws ServerLifecycleException {
        this.checkShutdownPrivileges();
        this.shutdown(false, true);
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (!T3Srvr.this.setPreventShutdownHook()) {
                    return;
                }
                T3SrvrLogger.logShutdownHookCalled();
                try {
                    T3Srvr.getT3Srvr().forceShutdown();
                }
                catch (ServerLifecycleException serverLifecycleException) {
                    serverLifecycleException.printStackTrace();
                    FileUtils.removeLockFiles();
                    JrveVM.setShutdownAction(-1);
                    Runtime.getRuntime().halt(-1);
                }
            }
        });
    }

    private synchronized boolean setPreventShutdownHook() {
        if (this.preventShutdownHook) {
            return false;
        }
        this.preventShutdownHook = true;
        return true;
    }

    void requestShutdownFromConsole() throws SecurityException {
        this.setShutdownWaitSecs(0);
        try {
            this.forceShutdown();
        }
        catch (ServerLifecycleException serverLifecycleException) {
            throw new SecurityException(serverLifecycleException.toString());
        }
    }

    void gracefulSuspend(boolean bl) throws ServerLifecycleException {
        this.checkPrivileges("lock");
        this.suspend(true, bl);
    }

    void forceSuspend() throws ServerLifecycleException {
        this.checkPrivileges("lock");
        this.suspend(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean bl, boolean bl2) throws ServerLifecycleException {
        try {
            if (!bl) {
                this.prepareForForceShutdown();
            }
            ServerServicesManager.abortStartup();
            if (this.shutWaitSecs > 0) {
                this.setState(11);
                if (this.isShutdownCancelled()) {
                    return;
                }
            }
            this.isShuttingDown = true;
            if (T3Srvr.isServerBeyondAdminState(this.srvrState)) {
                this.suspend(bl, bl2);
            }
            this.fallbackState = -1;
            if (bl) {
                this.setState(7);
                ServerServicesManager.stop(0, bl2);
            } else {
                this.setState(18);
                ServerServicesManager.halt(0);
            }
            this.setPreventShutdownHook();
            T3Srvr t3Srvr = this;
            synchronized (t3Srvr) {
                singleton.notifyAll();
            }
        }
        catch (ServerLifecycleException serverLifecycleException) {
            throw serverLifecycleException;
        }
        catch (IllegalStateException illegalStateException) {
            throw new ServerLifecycleException(illegalStateException);
        }
        catch (Exception exception) {
            T3SrvrLogger.logFailedToShutdownServer((Exception)exception);
            this.setFailedState(exception, false);
            throw new ServerLifecycleException(exception);
        }
    }

    private void prepareForForceShutdown() {
        this.setPreventShutdownHook();
        ServerLifeCycleTimerThread.startTimeBomb();
    }

    private void suspend(boolean bl, boolean bl2) throws ServerLifecycleException {
        try {
            if (bl) {
                this.setState(4);
                ServerServicesManager.stop(17, bl2);
            } else {
                this.setState(5);
                ServerServicesManager.halt(17);
            }
            this.fallbackState = 17;
            if (this.srvrState == 17) {
                return;
            }
            this.setState(17);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ServerLifecycleException(illegalStateException);
        }
        catch (Exception exception) {
            T3SrvrLogger.logFailedToShutdownServer((Exception)exception);
            this.setFailedState(exception, true);
            throw new ServerLifecycleException(exception);
        }
    }

    private static synchronized boolean isServerBeyondAdminState(int n) {
        return n == 2 || n == 6 || n == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cancelShutdown() {
        this.checkShutdownPrivileges();
        T3Srvr t3Srvr = this;
        synchronized (t3Srvr) {
            if (this.srvrState != 10) {
                if (this.srvrState == 11) {
                    return T3SrvrLogger.logNoCancelShutdownTooLate();
                }
                return T3SrvrLogger.logNoCancelShutdownAlreadyNotShutting();
            }
            this.srvrState = 2;
        }
        this.setShutdownWaitSecs(0);
        T3SrvrLogger.logCancelShutdownInitiated();
        t3Srvr = this;
        synchronized (t3Srvr) {
            this.notifyAll();
        }
        return T3SrvrLogger.logCancelShutdownHappened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutdownCancelled() {
        if (this.shutWaitSecs > 0) {
            T3SrvrLogger.logWaitingForShutdown((int)this.shutWaitSecs);
            T3Srvr t3Srvr = this;
            synchronized (t3Srvr) {
                this.srvrState = 10;
            }
            t3Srvr = this;
            synchronized (t3Srvr) {
                try {
                    int n = this.shutWaitSecs;
                    this.setShutdownWaitSecs(0);
                    this.wait(n * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.srvrState == 10) {
                    this.srvrState = 11;
                }
            }
        }
        if (this.srvrState == 11) {
            T3SrvrLogger.logNotWaitingForShutdown();
            return false;
        }
        return true;
    }

    private void checkShutdownPrivileges() throws SecurityException {
        if (!ManagementService.isRuntimeAccessInitialized()) {
            return;
        }
        if (ManagementService.getRuntimeAccess(kernelId).getServer().isConsoleInputEnabled()) {
            T3SrvrLogger.logShutdownFromCommandLineOnly();
            throw new SecurityException("shutdown from command line only when weblogic.ConsoleInputEnabled=true");
        }
        this.checkPrivileges("shutdown");
    }

    private void checkPrivileges(String string) throws SecurityException {
        String string2 = null;
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        if (authenticatedSubject == null || (string2 = SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject)) == null || string2.trim().length() == 0) {
            throw new SecurityException("Cannot " + string + " the server, " + "the request was from a nameless user (Principal)");
        }
        T3SrvrLogger.logOperationRequested((String)string, (String)string2);
        if (!ManagementService.isRuntimeAccessInitialized()) {
            return;
        }
        ServerResource serverResource = new ServerResource(null, ManagementService.getRuntimeAccess(kernelId).getServerName(), string);
        if (this.am != null && !this.am.isAccessAllowed(authenticatedSubject, (Resource)serverResource, null)) {
            throw new SecurityException("User: '" + string2 + "' does not have permission to " + string + " server");
        }
    }

    public synchronized void abortStartupAfterAdminState() throws ServerLifecycleException {
        if (this.srvrState == 2 || this.srvrState == 6) {
            throw new ServerLifecycleException("cannot abort startup in admin state as current state is " + this.getState());
        }
        this.abortStartupAfterAdminState = true;
    }

    boolean isAbortStartupAfterAdminState() {
        return this.abortStartupAfterAdminState;
    }

    static {
        restartFile = null;
        debugExceptions = Debug.getCategory((String)"weblogic.slc.exceptions.verbose");
    }

    private static class JrveVM {
        private static final boolean isJRVE = OperatingSystem.isJRVE();
        private static boolean wipeOutRestartFile;
        private static Class jrveVM;
        private static Class shutdownAction;
        private static Class VM_CLASS;
        private static Object VM;
        private static Field POWEROFF;
        private static Field REBOOT;
        private static Field CRASH;
        private static Method setShutdownAction;
        private static final Class[] VM_SHUTDOWN_ACTION;

        private JrveVM() {
        }

        private static int getMaxNumRestarts() {
            return ManagementService.getRuntimeAccess(kernelId).getServer().getRestartMax();
        }

        private static boolean isAutoRestartEnabled() {
            return ManagementService.getRuntimeAccess(kernelId).getServer().getAutoRestart();
        }

        private static int getRestartDelaySeconds() {
            return ManagementService.getRuntimeAccess(kernelId).getServer().getRestartDelaySeconds();
        }

        private static int getRestartIntervalSeconds() {
            return ManagementService.getRuntimeAccess(kernelId).getServer().getRestartIntervalSeconds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void setShutdownAction(int n) {
            wipeOutRestartFile = true;
            try {
                if (!isJRVE) return;
                if (jrveVM == null) {
                    Class<?>[] classArray;
                    shutdownAction = Class.forName("com.oracle.jrockitve.VM$ShutdownAction");
                    POWEROFF = shutdownAction.getField("POWEROFF");
                    REBOOT = shutdownAction.getField("REBOOT");
                    CRASH = shutdownAction.getField("CRASH");
                    jrveVM = Class.forName("com.oracle.jrockitve.VM");
                    Method method = jrveVM.getMethod("getVM", null);
                    VM_CLASS = method.getReturnType();
                    for (Class<?> clazz : classArray = jrveVM.getClasses()) {
                        if (!clazz.getName().equals("com.oracle.jrockitve.VM$ShutdownAction")) continue;
                        JrveVM.VM_SHUTDOWN_ACTION[0] = clazz;
                        break;
                    }
                    setShutdownAction = VM_CLASS.getMethod("setShutdownAction", VM_SHUTDOWN_ACTION);
                    VM = method.invoke(null, (Object[])null);
                }
                switch (n) {
                    case 0: {
                        if (debugSLC.isEnabled()) {
                            debugSLCWLDF.debug("Setting VM shutdown action to POWEROFF");
                        }
                        setShutdownAction.invoke(VM, POWEROFF.get(null));
                        return;
                    }
                    case 1: 
                    case 65: {
                        if (JrveVM.isAutoRestartEnabled() && numRestartsSoFar < JrveVM.getMaxNumRestarts()) {
                            if (debugSLC.isEnabled()) {
                                debugSLCWLDF.debug("Setting VM shutdown action to REBOOT");
                            }
                            setShutdownAction.invoke(VM, REBOOT.get(null));
                            wipeOutRestartFile = System.currentTimeMillis() - singleton.getStartTime() > (long)(JrveVM.getRestartIntervalSeconds() * 1000);
                            return;
                        }
                        if (debugSLC.isEnabled()) {
                            debugSLCWLDF.debug("Setting VM shutdown action to POWEROFF");
                        }
                        setShutdownAction.invoke(VM, POWEROFF.get(null));
                        return;
                    }
                    case -1: {
                        if (debugSLC.isEnabled()) {
                            debugSLCWLDF.debug("Setting VM shutdown action to POWEROFF");
                        }
                        setShutdownAction.invoke(VM, POWEROFF.get(null));
                        return;
                    }
                }
                return;
            }
            catch (Exception exception) {
                System.err.println("Error in invoking JRVE setShutdownAction: ");
                exception.printStackTrace();
                return;
            }
            finally {
                if (wipeOutRestartFile) {
                    T3Srvr.deleteRestartFile();
                }
            }
        }

        static {
            VM_SHUTDOWN_ACTION = new Class[1];
        }
    }

    private static final class StateChangeValidator {
        private static final NumericKeyHashMap validStateTransitions = new NumericKeyHashMap();
        private static final int[] statesAlwaysAllowed = new int[]{8, 15, 14};

        private StateChangeValidator() {
        }

        private static void initialize() {
            validStateTransitions.put(1L, (Object)new int[]{3, 17, 7, 18});
            validStateTransitions.put(3L, (Object)new int[]{7, 18, 1});
            validStateTransitions.put(17L, (Object)new int[]{7, 18, 6});
            validStateTransitions.put(6L, (Object)new int[]{2, 5});
            validStateTransitions.put(2L, (Object)new int[]{4, 5, 10, 11});
            validStateTransitions.put(4L, (Object)new int[]{5, 17});
            validStateTransitions.put(5L, (Object)new int[]{17});
            validStateTransitions.put(7L, (Object)new int[]{18, 0});
            validStateTransitions.put(18L, (Object)new int[]{0});
            validStateTransitions.put(10L, (Object)new int[]{5, 4, 2});
        }

        private static boolean validate(int n, int n2) {
            if (StateChangeValidator.isNewStateAlwaysAllowed(n2)) {
                return true;
            }
            int[] nArray = (int[])validStateTransitions.get((long)n);
            if (nArray == null) {
                return true;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 != nArray[i]) continue;
                return true;
            }
            return false;
        }

        private static boolean isNewStateAlwaysAllowed(int n) {
            for (int i = 0; i < statesAlwaysAllowed.length; ++i) {
                if (n != statesAlwaysAllowed[i]) continue;
                return true;
            }
            return false;
        }
    }
}

