/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.DataInputStream;
import java.io.IOException;
import weblogic.kernel.T3SrvrLogger;
import weblogic.t3.srvr.T3Srvr;

final class T3SrvrConsole {
    T3SrvrConsole() {
    }

    public void processCommands() {
        Runtime runtime = Runtime.getRuntime();
        DataInputStream dataInputStream = new DataInputStream(System.in);
        String string = null;
        while (true) {
            try {
                string = dataInputStream.readLine();
            }
            catch (IOException iOException) {
                T3SrvrLogger.logReadCommandIOException((Exception)iOException);
            }
            if (string == null || string.trim().length() == 0) continue;
            T3SrvrLogger.logReadWhichCommand((String)string);
            if (string.equalsIgnoreCase("GC")) {
                this.doGarbageCollection();
                continue;
            }
            if (string.equalsIgnoreCase("PROFOFF")) {
                T3SrvrLogger.logConsoleProfilingDisabled();
                runtime.traceInstructions(false);
                runtime.traceMethodCalls(false);
                continue;
            }
            if (string.equalsIgnoreCase("PROFON")) {
                T3SrvrLogger.logConsoleProfilingEnabled();
                runtime.traceInstructions(true);
                runtime.traceMethodCalls(true);
                continue;
            }
            if (string.equalsIgnoreCase("SHUT")) {
                try {
                    T3Srvr.getT3Srvr().requestShutdownFromConsole();
                    return;
                }
                catch (SecurityException securityException) {
                    T3SrvrLogger.logConsoleShutSecurityException((Exception)securityException);
                }
                continue;
            }
            if (string.equalsIgnoreCase("KILL")) {
                runtime.exit(0);
                continue;
            }
            T3SrvrLogger.logConsoleNoSuchCommand((String)string);
        }
    }

    private void doGarbageCollection() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        T3SrvrLogger.logConsoleGCBefore((long)l2, (long)l, (long)(100L * l2 / l));
        runtime.gc();
        runtime.runFinalization();
        l = runtime.totalMemory();
        l2 = runtime.freeMemory();
        T3SrvrLogger.logConsoleGCAfter((long)l2, (long)l, (long)(100L * l2 / l));
    }
}

