/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr.servicegroups;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import weblogic.Home;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.server.ServerLogger;
import weblogic.server.ServiceFailureException;
import weblogic.server.servicegraph.Service;
import weblogic.server.servicegraph.ServiceDependencies;
import weblogic.t3.srvr.servicegroups.ConnectorServiceGroup;
import weblogic.t3.srvr.servicegroups.CoreServiceGroup;
import weblogic.t3.srvr.servicegroups.EJBServiceGroup;
import weblogic.t3.srvr.servicegroups.JMSServiceGroup;
import weblogic.t3.srvr.servicegroups.ServicePluginGroup;
import weblogic.t3.srvr.servicegroups.WseeServiceGroup;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class ServerServiceDependencies
extends ServiceDependencies {
    private static final DebugCategory debugSLC = Debug.getCategory((String)"weblogic.slc");
    private static final DebugLogger debugSLCWLDF = DebugLogger.getDebugLogger((String)"DebugServerLifeCycle");
    private static String serverTypeProp = System.getProperty("serverType");
    private static boolean checkServiceConfig = serverTypeProp != null;
    private static String DISABLED_SERVICES = null;
    private EJBServiceGroup ejbServiceGroup = null;
    private ConnectorServiceGroup connectorServiceGroup = null;
    private JMSServiceGroup jmsServiceGroup = null;
    private ServicePluginGroup servicePluginGroup = null;
    private WseeServiceGroup wseeServiceGroup = null;
    private static ServiceDependencies INSTANCE = new ServerServiceDependencies();

    private ServerServiceDependencies() {
        try {
            this.addServiceGroup(new CoreServiceGroup(true));
            this.servicePluginGroup = new ServicePluginGroup(this.isGroupConfigured(ServicePluginGroup.class.getName()));
            this.addServiceGroup(this.servicePluginGroup);
            this.ejbServiceGroup = new EJBServiceGroup(this.isGroupConfigured(EJBServiceGroup.class.getName()));
            this.addServiceGroup(this.ejbServiceGroup);
            this.connectorServiceGroup = new ConnectorServiceGroup(this.isGroupConfigured(ConnectorServiceGroup.class.getName()));
            this.addServiceGroup(this.connectorServiceGroup);
            this.jmsServiceGroup = new JMSServiceGroup(this.isGroupConfigured(JMSServiceGroup.class.getName()));
            this.addServiceGroup(this.jmsServiceGroup);
            this.wseeServiceGroup = new WseeServiceGroup(this.isGroupConfigured(WseeServiceGroup.class.getName()));
            this.addServiceGroup(this.wseeServiceGroup);
        }
        catch (ServiceFailureException serviceFailureException) {
            serviceFailureException.printStackTrace();
            throw new RuntimeException(serviceFailureException);
        }
    }

    private boolean isGroupConfigured(String string) {
        if (!checkServiceConfig) {
            return true;
        }
        if (DISABLED_SERVICES == null) {
            DISABLED_SERVICES = ServerServiceDependencies.getDisabledServices(serverTypeProp);
        }
        if (ServerServiceDependencies.isDebugEnabled()) {
            debugSLCWLDF.debug("isGroupConfigured( " + string + " ) = " + !DISABLED_SERVICES.contains(string));
        }
        return !DISABLED_SERVICES.contains(string);
    }

    private static String getDisabledServices(String string) {
        Object var1_1 = null;
        String string2 = "";
        String string3 = "";
        Object var4_4 = null;
        try {
            Object object;
            string2 = Home.getPath() + File.separator + "lib" + File.separator + "service-config.properties";
            File file = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            if (ServerServiceDependencies.isDebugEnabled()) {
                object = new StringWriter();
                properties.list(new PrintWriter((Writer)object));
                debugSLCWLDF.debug(((StringWriter)object).toString());
            }
            if ((object = properties.getProperty((string = string.toLowerCase(Locale.ENGLISH)) + "-config")) == null) {
                ServerLogger.logUnknownServerType((String)string);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    string3 = string3 + properties.getProperty(string4);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServerLogger.logMissingServiceConfigFile((String)string2);
        }
        catch (IOException iOException) {
            ServerLogger.logServiceConfigFileException((String)string2, (Exception)iOException);
        }
        return string3;
    }

    public boolean isServiceAvailable(String string) {
        if (string.equals("EJB")) {
            return this.ejbServiceGroup.isAvailable();
        }
        if (string.equals("JMS")) {
            return this.jmsServiceGroup.isAvailable();
        }
        if (string.equals("CONNECTOR")) {
            return this.connectorServiceGroup.isAvailable();
        }
        if (string.equals("WSEE")) {
            return this.wseeServiceGroup.isAvailable();
        }
        return this.servicePluginGroup.isAvailable() && this.servicePluginGroup.isPluginAvailable(string);
    }

    public static ServiceDependencies getInstance() {
        return INSTANCE;
    }

    private static boolean isDebugEnabled() {
        return debugSLC.isEnabled() || debugSLCWLDF.isDebugEnabled();
    }

    public static void main(String[] stringArray) {
        ServiceDependencies serviceDependencies = ServerServiceDependencies.getInstance();
        List list = serviceDependencies.getOrderedServices();
        System.out.println(" The ordered services: ");
        for (Service service2 : list) {
            System.out.println(service2.getServiceClassName() + "[" + service2.getIndex() + "]");
        }
    }
}

