/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr.servicegroups;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.server.ServerLogger;
import weblogic.server.ServiceActivator;
import weblogic.server.ServiceFailureException;
import weblogic.server.servicegraph.Service;
import weblogic.server.servicegraph.ServiceGroup;
import weblogic.t3.srvr.servicegroups.CoreServiceGroup;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class ServicePluginGroup
extends ServiceGroup {
    private static boolean servicePluginsAvailable = true;
    private static final DebugCategory debugSLC = Debug.getCategory((String)"weblogic.slc");
    private static final DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugServerLifeCycle");
    private List<String> availablePlugins = new ArrayList<String>();

    public ServicePluginGroup(boolean bl) throws ServiceFailureException {
        super(bl);
        if (!bl) {
            if (ServicePluginGroup.isDebugEnabled()) {
                debugLogger.debug("ServicePluginGroup is not configured. No attempt will be made to look for service plugins.");
            }
        } else {
            File[] fileArray;
            File file = new File(new File(DomainDir.getRootDir()), "lib");
            if (ServicePluginGroup.isDebugEnabled()) {
                debugLogger.debug("Looking in " + file.toString() + " for service plugins.");
            }
            if (file.exists() && (fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".jar");
                }
            })) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.processPossibleServicePlugin(fileArray[i]);
                }
            }
        }
    }

    public boolean isPluginAvailable(String string) {
        return this.isAvailable() && this.availablePlugins.contains(string);
    }

    public boolean isAvailable() {
        return servicePluginsAvailable;
    }

    public void processPossibleServicePlugin(File file) throws ServiceFailureException {
        Object object;
        JarFile jarFile = null;
        Manifest manifest = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            ServerLogger.logServicePluginException((String)file.getPath(), (Exception)iOException);
            return;
        }
        if (ServicePluginGroup.isDebugEnabled()) {
            debugLogger.debug("Processing possible service plugin: " + file.toString());
        }
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException iOException) {
            ServerLogger.logServicePluginManifestException((String)file.getPath(), (Exception)iOException);
        }
        if (manifest != null && (object = manifest.getMainAttributes()) != null) {
            string = ((Attributes)object).getValue("Bundle-Activator");
            string3 = ((Attributes)object).getValue("Import-Service");
            string2 = ((Attributes)object).getValue("Export-Service");
            string4 = ((Attributes)object).getValue("Bundle-SymbolicName");
        }
        if (string != null) {
            object = Thread.currentThread().getContextClassLoader();
            if (object == null) {
                object = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> clazz = Class.forName(string, false, (ClassLoader)object);
                if (!ServiceActivator.class.isAssignableFrom(clazz)) {
                    if (ServicePluginGroup.isDebugEnabled()) {
                        debugLogger.debug("The Bundle-Activator for this service plugin does not extend ServiceActivator");
                    }
                    return;
                }
                if (ServicePluginGroup.isDebugEnabled()) {
                    debugLogger.debug(clazz.getName() + " is a ServiceActivator.");
                }
                Field field = clazz.getDeclaredField("INSTANCE");
                ServiceActivator serviceActivator = (ServiceActivator)field.get(null);
                Service service2 = new Service(serviceActivator);
                this.addService(service2);
                if (string2.contains("weblogic.application.ServiceRegistrant")) {
                    service2.addSuccessor(CoreServiceGroup.getDeploymentService());
                }
                if (string3 != null) {
                    String[] stringArray = string3.split(", ");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Class<?> clazz2 = Class.forName(stringArray[i]);
                        Field field2 = clazz2.getDeclaredField("INSTANCE");
                        Service service3 = (Service)field2.get(null);
                        service2.addDependency(service3);
                    }
                }
                this.availablePlugins.add(string4);
                ServerLogger.logServicePluginAdded((String)file.getPath(), (String)string4);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new ServiceFailureException(ServerLogger.getServicePluginActivatorLoadException((String)file.getPath(), (Exception)noSuchFieldException));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServiceFailureException(ServerLogger.getServicePluginActivatorLoadException((String)file.getPath(), (Exception)illegalAccessException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ServiceFailureException(ServerLogger.getServicePluginActivatorLoadException((String)file.getPath(), (Exception)classNotFoundException));
            }
        }
    }

    private static boolean isDebugEnabled() {
        return debugSLC.isEnabled() || debugLogger.isDebugEnabled();
    }
}

