/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tgiop;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.config.TuxedoConnectorRAP;
import com.bea.core.jatmi.internal.TCRouteEntry;
import com.bea.core.jatmi.internal.TuxedoXid;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.ConnectionManager;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IIOPService;
import weblogic.iiop.IOR;
import weblogic.iiop.Message;
import weblogic.iiop.MessageHeader;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.iiop.ReplyMessage;
import weblogic.logging.LogOutputStream;
import weblogic.protocol.AsyncOutgoingMessage;
import weblogic.protocol.ChannelImpl;
import weblogic.protocol.ServerChannel;
import weblogic.rmi.spi.Channel;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.tgiop.TGIOPEndPointImpl;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.wtc.WTCLogger;
import weblogic.wtc.gwt.MethodParameters;
import weblogic.wtc.gwt.OatmialServices;
import weblogic.wtc.gwt.TDMRemote;
import weblogic.wtc.gwt.TuxedoCorbaConnection;
import weblogic.wtc.gwt.TuxedoCorbaConnectionFactory;
import weblogic.wtc.gwt.WTCService;
import weblogic.wtc.jatmi.BEAObjectKey;
import weblogic.wtc.jatmi.ObjinfoImpl;
import weblogic.wtc.jatmi.SessionAcallDescriptor;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TdomTcb;
import weblogic.wtc.jatmi.TypedBuffer;
import weblogic.wtc.jatmi.TypedTGIOP;
import weblogic.wtc.jatmi.UserTcb;
import weblogic.wtc.jatmi.dsession;
import weblogic.wtc.jatmi.rdsession;
import weblogic.wtc.jatmi.tcb;
import weblogic.wtc.jatmi.tcm;
import weblogic.wtc.jatmi.tfmh;

public final class TGIOPConnection
extends Connection {
    private static boolean initialized = false;
    private static boolean closed = false;
    private static TuxedoCorbaConnectionFactory tuxedoCorbaConnectionFactory;
    private EndPoint endPoint;
    private static final DebugCategory debugSecurity;
    private static final AuthenticatedSubject kernelId;
    protected static LogOutputStream log;
    private TuxedoCorbaConnection tuxedoCorbaConnection;
    private MethodParameters methodParameters;
    private AuthenticatedSubject user;
    private dsession session;
    private Channel channel;
    private static final ConnectionKey notused;
    private static final int TGIOP_FLAG_MASK = -2;

    protected static void p(String string) {
        System.err.println("<TGIOPConnection> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogOutputStream getLog() {
        if (log != null) return log;
        Class<TGIOPConnection> clazz = TGIOPConnection.class;
        synchronized (TGIOPConnection.class) {
            if (log != null) return log;
            log = new LogOutputStream("IIOPSocket");
            // ** MonitorExit[var0] (shouldn't be in output)
            return log;
        }
    }

    public void authenticate(UserInfo userInfo) {
    }

    public AuthenticatedSubject getUser() {
        return null;
    }

    public void setTxContext(Object object) {
    }

    public Object getTxContext() {
        return null;
    }

    public ServerChannel getChannel() {
        return ProtocolHandlerIIOP.getProtocolHandler().getDefaultServerChannel();
    }

    public Channel getRemoteChannel() {
        return this.channel;
    }

    private void initTuxedoCorbaConnectionFactory() throws IOException {
        try {
            InitialContext initialContext = new InitialContext();
            tuxedoCorbaConnectionFactory = (TuxedoCorbaConnectionFactory)initialContext.lookup("tuxedo.services.TuxedoCorbaConnection");
        }
        catch (NamingException namingException) {
            IIOPService.setTGIOPEnabled(false);
            throw new IOException("Problem getting TuxedoCorbaConnectionFactory: " + namingException);
        }
    }

    private TGIOPConnection() throws IOException {
        if (!IIOPService.isTGIOPEnabled()) {
            throw new IOException("TGIOP is disabled");
        }
        if (!initialized) {
            initialized = true;
            this.initTuxedoCorbaConnectionFactory();
        }
    }

    public TGIOPConnection(MethodParameters methodParameters) throws IOException {
        this();
        this.methodParameters = methodParameters;
        if (this.methodParameters != null) {
            this.session = (dsession)methodParameters.get_gwatmi();
        }
        this.user = this.methodParameters == null || this.methodParameters.getServiceParameters() == null ? SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId) : methodParameters.getAuthenticatedSubject();
        if (debugSecurity.isEnabled()) {
            WTCLogger.logDebugSecurity("inbound request user set to: " + this.user);
        }
    }

    public TGIOPConnection(String string, String string2, int n) throws IOException {
        this();
        this.channel = new ChannelImpl(string2, n, "tgiop");
        try {
            this.tuxedoCorbaConnection = tuxedoCorbaConnectionFactory.getTuxedoCorbaConnection();
            StringBuffer stringBuffer = new StringBuffer("//");
            stringBuffer.append(string);
            ArrayList arrayList = this.tuxedoCorbaConnection.getProviderRoute(stringBuffer.toString(), null, null, 0);
            TCRouteEntry tCRouteEntry = (TCRouteEntry)arrayList.get(0);
            this.session = (dsession)tCRouteEntry.getSessionGroup();
        }
        catch (TPException tPException) {
            throw new IOException("Could not get TuxedoCorbaConnection : " + (Object)((Object)tPException));
        }
        catch (Exception exception) {
            throw new IOException("Could not get TuxedoCorbaConnection : " + exception);
        }
    }

    public final synchronized void send(AsyncOutgoingMessage asyncOutgoingMessage) throws IOException {
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)asyncOutgoingMessage;
        Message message = (Message)iIOPOutputStream.getMessage();
        int n = message.getRequestID();
        byte[] byArray = iIOPOutputStream.getBufferToWrite();
        if (debugSecurity.isEnabled()) {
            WTCLogger.logDebugSecurity("sending tgiop message, user set to " + SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId));
        }
        if (this.tuxedoCorbaConnection != null) {
            this.methodParameters = new MethodParameters(n, this.session);
            this.sendUsingTuxedoCorbaConnection(byArray, byArray.length);
            return;
        }
        this.sendUsingMethodParameters(byArray, byArray.length);
    }

    private void sendUsingTuxedoCorbaConnection(byte[] byArray, int n) throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)65000);
        if (bl) {
            ntrace.doTrace((String)"[/TGIOPConnection/sendUsingTuxedoCorbaConnection/");
        }
        try {
            TypedTGIOP typedTGIOP = new TypedTGIOP(byArray, n);
            BEAObjectKey bEAObjectKey = new BEAObjectKey(typedTGIOP);
            ObjinfoImpl objinfoImpl = new ObjinfoImpl(bEAObjectKey, null, null, 0);
            this.tuxedoCorbaConnection.tpMethodReq((TypedBuffer)typedTGIOP, objinfoImpl, this.methodParameters, 16384);
        }
        catch (TPException tPException) {
            if (bl) {
                ntrace.doTrace((String)("*]/TGIOPConnection/sendUsingTuxedoCorbaConnection/10/exception: " + (Object)((Object)tPException)));
            }
            IOException iOException = new IOException("Could not send message via WTC : " + (Object)((Object)tPException));
            iOException.initCause(tPException);
            throw iOException;
        }
        catch (Exception exception) {
            if (bl) {
                ntrace.doTrace((String)("*]/TGIOPConnection/sendUsingTuxedoCorbaConnection/20/exception: " + exception));
            }
            IOException iOException = new IOException("Could not send message via WTC : " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        if (bl) {
            ntrace.doTrace((String)"]/TGIOPConnection/sendUsingTuxedoCorbaConnection/30");
        }
    }

    private void sendUsingMethodParameters(byte[] byArray, int n) throws IOException {
        TypedTGIOP typedTGIOP = new TypedTGIOP(byArray, n);
        tcm tcm2 = new tcm(0, (tcb)new UserTcb((TypedBuffer)typedTGIOP));
        tfmh tfmh2 = new tfmh(typedTGIOP.getHintIndex(), tcm2, 1);
        dsession dsession2 = (dsession)this.methodParameters.get_gwatmi();
        TdomTcb tdomTcb = (TdomTcb)this.methodParameters.get_invokeInfo().getServiceMessage().tdom.body;
        int n2 = 0;
        int n3 = 0;
        Object var10_10 = null;
        int n4 = -1;
        SessionAcallDescriptor sessionAcallDescriptor = null;
        rdsession rdsession2 = null;
        n4 = tdomTcb.get_convid();
        if (n4 != -1) {
            sessionAcallDescriptor = new SessionAcallDescriptor(n4, true);
            rdsession2 = dsession2.get_rcv_place();
        }
        Object[] objectArray = this.methodParameters.getTxInfo();
        TuxedoXid tuxedoXid = null;
        TDMRemote tDMRemote = null;
        OatmialServices oatmialServices = null;
        XAResource xAResource = null;
        if (objectArray != null) {
            tuxedoXid = (TuxedoXid)objectArray[0];
            xAResource = (XAResource)objectArray[1];
            tDMRemote = (TDMRemote)((Object)objectArray[2]);
            oatmialServices = WTCService.getOatmialServices();
        }
        try {
            dsession2.send_success_return(this.methodParameters.get_invokeInfo().getReqid(), tfmh2, n2, n3, n4);
        }
        catch (TPException tPException) {
            if (xAResource != null) {
                try {
                    xAResource.end((Xid)tuxedoXid, 0x20000000);
                    oatmialServices.removeInboundRdomFromXid(tDMRemote, (Xid)tuxedoXid);
                    xAResource.rollback((Xid)tuxedoXid);
                }
                catch (XAException xAException) {
                    // empty catch block
                }
            }
            if (n4 == -1) {
                dsession2.send_failure_return(this.methodParameters.get_invokeInfo().getReqid(), tPException, n4);
            } else {
                rdsession2.remove_rplyObj(sessionAcallDescriptor);
            }
            throw new IOException("Got TPException: " + (Object)((Object)tPException));
        }
        if (xAResource != null) {
            try {
                if (var10_10 == null) {
                    xAResource.end((Xid)tuxedoXid, 0x4000000);
                } else {
                    xAResource.end((Xid)tuxedoXid, 0x20000000);
                    oatmialServices.removeInboundRdomFromXid((TuxedoConnectorRAP)tDMRemote, (Xid)tuxedoXid);
                    xAResource.rollback((Xid)tuxedoXid);
                }
            }
            catch (XAException xAException) {
                // empty catch block
            }
        }
        if (n4 != -1) {
            rdsession2.remove_rplyObj(sessionAcallDescriptor);
        }
    }

    private TPException getTPExceptionFromReply(byte[] byArray) {
        int n = MessageHeader.getMsgType(byArray);
        if (n != 1) {
            return null;
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(byArray);
        MessageHeader messageHeader = new MessageHeader(iIOPInputStream);
        ReplyMessage replyMessage = new ReplyMessage(this.getEndPoint(), messageHeader, iIOPInputStream);
        if (replyMessage.getReplyStatus() == 2) {
            return new TPException(11);
        }
        return null;
    }

    public final synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        if (this.tuxedoCorbaConnection != null) {
            this.tuxedoCorbaConnection.tpterm();
        }
        closed = true;
    }

    public final synchronized boolean isClosed() {
        return closed;
    }

    public boolean isStateful() {
        return false;
    }

    public ConnectionKey getConnectionKey() {
        return notused;
    }

    public void setConnectionKey(ConnectionKey connectionKey) {
    }

    public final int getMinorVersion() {
        return this.session.getMinorVersion();
    }

    public final void setMinorVersion(int n) {
        this.session.setMinorVersion(n);
    }

    public final void setCodeSets(int n, int n2) {
        this.session.setCodeSets(n, n2);
    }

    public final int getWcharCodeSet() {
        return this.session.getWcharCodeSet();
    }

    public final int getCharCodeSet() {
        return this.session.getCharCodeSet();
    }

    public void setFlag(int n) {
        this.session.setFlag(n & 0xFFFFFFFE);
    }

    public boolean getFlag(int n) {
        return this.session.getFlag(n);
    }

    public final IOR getRemoteCodeBase() {
        return this.session.getRemoteCodeBase();
    }

    public final void setRemoteCodeBase(IOR iOR) {
        this.session.setRemoteCodeBase(iOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPoint getEndPoint() {
        if (this.endPoint == null) {
            TGIOPConnection tGIOPConnection = this;
            synchronized (tGIOPConnection) {
                if (this.endPoint == null) {
                    this.endPoint = new TGIOPEndPointImpl(this, ConnectionManager.getConnectionManager(), this.user);
                }
            }
        }
        return this.endPoint;
    }

    protected final boolean isSecure() {
        return false;
    }

    static {
        debugSecurity = Debug.getCategory((String)"weblogic.tgiop.security");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        notused = new ConnectionKey("notused", 0);
    }
}

