/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tgiop;

import com.bea.core.jatmi.common.ntrace;
import java.security.AccessController;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionManager;
import weblogic.iiop.EndPointImpl;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.SequencedRequestMessage;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.SyncKeyTable;
import weblogic.wtc.WTCLogger;

public final class TGIOPEndPointImpl
extends EndPointImpl {
    private AuthenticatedSubject user;
    private static final SyncKeyTable pendingResponses = new SyncKeyTable();
    private static int nextRequestID = 1;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.tgiop.security");

    protected boolean isSecure(Connection connection) {
        return false;
    }

    public boolean supportsForwarding() {
        return false;
    }

    public int getNextRequestID() {
        return TGIOPEndPointImpl.getNextInternalRequestID();
    }

    private static synchronized int getNextInternalRequestID() {
        return ++nextRequestID;
    }

    public SequencedRequestMessage getPendingResponse(int n) {
        return (SequencedRequestMessage)pendingResponses.get(n);
    }

    public SequencedRequestMessage removePendingResponse(int n) {
        boolean bl = ntrace.isTraceEnabled((int)65000);
        if (bl) {
            ntrace.doTrace((String)("[/TGIOPEndpoint/removePendingResponse requestid = " + n));
        }
        super.removePendingResponse(n);
        SequencedRequestMessage sequencedRequestMessage = (SequencedRequestMessage)pendingResponses.remove(n);
        if (bl) {
            ntrace.doTrace((String)("]/TGIOPEndpoint/removePendingResponse returning msg = " + sequencedRequestMessage));
        }
        return sequencedRequestMessage;
    }

    public void registerPendingResponse(SequencedRequestMessage sequencedRequestMessage) {
        boolean bl = ntrace.isTraceEnabled((int)65000);
        if (bl) {
            ntrace.doTrace((String)("[/TGIOPEndpoint/registgerPendingResponse requestID = " + sequencedRequestMessage.getRequestID()));
        }
        super.registerPendingResponse(sequencedRequestMessage);
        pendingResponses.put((Object)sequencedRequestMessage);
        if (bl) {
            ntrace.doTrace((String)"]/TGIOPEndpoint/registerPendingResponse");
        }
    }

    public TGIOPEndPointImpl(Connection connection, ConnectionManager connectionManager, AuthenticatedSubject authenticatedSubject) {
        super(connection, connectionManager);
        this.user = authenticatedSubject;
    }

    public AuthenticatedSubject getSubject(RequestMessage requestMessage) {
        if (this.user == null) {
            this.user = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        }
        return this.user;
    }

    public void setSubject(RequestMessage requestMessage, AuthenticatedSubject authenticatedSubject) {
        if (debugSecurity.isEnabled()) {
            WTCLogger.logDebugSecurity("outbound request user set to: " + authenticatedSubject);
        }
    }

    public Object getInboundRequestTxContext(RequestMessage requestMessage) {
        Object object = requestMessage.getCachedTxContext();
        if (object == null) {
            object = TxHelper.getTransaction();
            requestMessage.setCachedTxContext(object);
        }
        return object;
    }

    public Object getInboundResponseTxContext(ReplyMessage replyMessage) {
        return TxHelper.getTransaction();
    }

    public void setOutboundResponseTxContext(ReplyMessage replyMessage, Object object) {
    }

    public void setOutboundRequestTxContext(RequestMessage requestMessage, Object object) {
    }
}

