/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.common.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.time.common.Schedulable;
import weblogic.time.common.ScheduledTriggerDef;
import weblogic.time.common.TimeTriggerException;
import weblogic.time.common.Triggerable;
import weblogic.time.common.internal.TimeEvent;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.work.WorkManager;

public class ScheduledTrigger
extends TimeEvent
implements ScheduledTriggerDef,
PrivilegedAction {
    public static boolean cancelAppTriggers = false;
    Schedulable scheduler;
    TimeEventGenerator teg;
    protected Triggerable trigger;
    private boolean cancelled = false;
    private boolean scheduled = false;
    private AuthenticatedSubject subject;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean runInThread = false;
    private boolean isDaemon;

    public ScheduledTrigger() {
    }

    public ScheduledTrigger(Schedulable schedulable, Triggerable triggerable) {
        this.scheduler = schedulable;
        this.trigger = triggerable;
        this.teg = TimeEventGenerator.getOne();
    }

    public ScheduledTrigger(Schedulable schedulable, Triggerable triggerable, WorkManager workManager) {
        this.scheduler = schedulable;
        this.trigger = triggerable;
        this.teg = TimeEventGenerator.getOne();
        this.setWorkManager(workManager);
    }

    public ScheduledTrigger(Schedulable schedulable, Triggerable triggerable, TimeEventGenerator timeEventGenerator) {
        this.scheduler = schedulable;
        this.trigger = triggerable;
        this.teg = timeEventGenerator;
    }

    public void setRunInThread(boolean bl) {
        this.runInThread = bl;
    }

    public synchronized int schedule() throws TimeTriggerException {
        this.subject = (AuthenticatedSubject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SubjectManager.getSubjectManager().getCurrentSubject((AbstractSubject)kernelId);
            }
        });
        if (!this.scheduled) {
            this.time = this.scheduler.schedule(System.currentTimeMillis());
            if (this.time > 0L) {
                this.teg.insert(this);
            }
        }
        this.scheduled = true;
        return this.teg.nextTriggerID();
    }

    public void setDaemon(boolean bl) throws TimeTriggerException {
        if (this.cancelled) {
            throw new TimeTriggerException("Scheduled Trigger has been cancelled");
        }
        this.isDaemon = bl;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public synchronized boolean cancel() throws TimeTriggerException {
        this.cancelled = true;
        this.scheduled = false;
        return this.teg.delete(this);
    }

    public void executeTimer(long l, WorkManager workManager, boolean bl) {
        this.time = l;
        if (this.subject == null) {
            this.subject = (AuthenticatedSubject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return SubjectManager.getSubjectManager().getCurrentSubject((AbstractSubject)kernelId);
                }
            });
        }
        if (this.runInThread) {
            this.executeLocally();
        } else if (cancelAppTriggers) {
            this.teg.deleted(this);
            this.destroy();
        } else {
            workManager.schedule(new Runnable(){

                public void run() {
                    ScheduledTrigger.this.execute();
                }
            });
        }
    }

    protected void execute() {
        this.executeLocally();
    }

    private void executeLocally() {
        if (!this.cancelled) {
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedAction)this);
            if (!this.cancelled) {
                if (this.time > 0L) {
                    this.teg.insert(this);
                } else {
                    this.teg.deleted(this);
                    this.destroy();
                }
            }
        }
    }

    public Object run() {
        this.trigger.trigger(this.scheduler);
        if (!this.cancelled) {
            this.time = this.scheduler.schedule(this.time);
        }
        return null;
    }

    protected synchronized void destroy() {
        super.destroy();
        this.cancelled = true;
        this.scheduled = false;
    }

    public static void cancelAppTriggers(boolean bl) {
        cancelAppTriggers = bl;
    }
}

