/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.common.internal;

import java.util.Date;
import java.util.Hashtable;
import weblogic.common.T3MiscLogger;
import weblogic.kernel.Kernel;
import weblogic.time.common.ScheduledTriggerDef;
import weblogic.time.common.internal.ScheduledTrigger;
import weblogic.time.common.internal.TimeTable;
import weblogic.work.WorkManagerFactory;

public final class TimeEventGenerator
implements Runnable {
    private static final int HIGH_THREAD_PRIORITY = 9;
    private static final String RUNTIME_MBEAN_NAME = "TimeEventGenerator";
    private static final Date LAUNCH = new Date();
    private static TimeEventGenerator singleton;
    private final Hashtable allTriggers = new Hashtable();
    private final Thread theThread;
    private final TimeTable timeTriggers;
    private long nexttime;
    private long startMillis;
    private int triggerInstanceCount;
    private int triggerExpiredCount;

    public static Date getLaunch() {
        return LAUNCH;
    }

    public static synchronized TimeEventGenerator init(ThreadGroup threadGroup) {
        if (singleton != null) {
            throw new IllegalStateException("Attempt to double initialize");
        }
        singleton = new TimeEventGenerator(threadGroup, 9);
        singleton.start();
        return singleton;
    }

    public static synchronized TimeEventGenerator getOne() {
        return TimeEventGenerator.getHighPriorityOne();
    }

    public static synchronized TimeEventGenerator getHighPriorityOne() {
        return singleton != null ? singleton : TimeEventGenerator.init(null);
    }

    public static int deltaMillis(long l) {
        if (l == 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)(System.currentTimeMillis() - l);
    }

    public static int deltaSecs(long l) {
        if (l == 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)(TimeEventGenerator.getCurrentSecs() - l);
    }

    public static int deltaMins(long l) {
        if (l == 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)(TimeEventGenerator.getCurrentMins() - l);
    }

    public static long getCurrentMillis() {
        return System.currentTimeMillis();
    }

    public static long getCurrentSecs() {
        return (System.currentTimeMillis() + 500L) / 1000L;
    }

    public static long getCurrentMins() {
        return (TimeEventGenerator.getCurrentSecs() + 30L) / 60L;
    }

    private TimeEventGenerator(ThreadGroup threadGroup, int n) {
        this.theThread = new Thread(threadGroup, this, "weblogic.time.TimeEventGenerator");
        this.theThread.setDaemon(true);
        this.theThread.setPriority(n);
        this.timeTriggers = new TimeTable(100, 1000L, System.currentTimeMillis());
    }

    public void start() {
        this.theThread.start();
    }

    public void stop() {
        this.theThread.stop();
        if (this == singleton) {
            singleton = null;
        }
    }

    public void run() {
        this.startMillis = System.currentTimeMillis();
        while (true) {
            try {
                while (true) {
                    this.timeTriggers.execute(System.currentTimeMillis(), WorkManagerFactory.getInstance().getDefault(), true);
                    this.timeTriggers.snooze();
                }
            }
            catch (ThreadDeath threadDeath) {
                if (!Kernel.isServer()) continue;
                throw threadDeath;
            }
            catch (Throwable throwable) {
                T3MiscLogger.logThrowable((Throwable)throwable);
                continue;
            }
            break;
        }
    }

    public void insert(ScheduledTrigger scheduledTrigger) {
        this.timeTriggers.insert(scheduledTrigger);
    }

    public boolean delete(ScheduledTrigger scheduledTrigger) {
        if (this.timeTriggers.delete(scheduledTrigger)) {
            this.dropTriggerID();
            return true;
        }
        return false;
    }

    public void deleted(ScheduledTrigger scheduledTrigger) {
        this.dropTriggerID();
    }

    public void register(Object object, ScheduledTriggerDef scheduledTriggerDef) {
        this.allTriggers.put(object, scheduledTriggerDef);
    }

    public ScheduledTriggerDef unregister(Object object) {
        return (ScheduledTriggerDef)this.allTriggers.remove(object);
    }

    public ScheduledTriggerDef registered(Object object) {
        return (ScheduledTriggerDef)this.allTriggers.get(object);
    }

    public final synchronized int nextTriggerID() {
        return this.triggerInstanceCount++;
    }

    public final synchronized void dropTriggerID() {
        ++this.triggerExpiredCount;
    }

    public int getTriggerInstanceCount() {
        return this.triggerInstanceCount;
    }

    public int getTriggerExpiredCount() {
        return this.triggerExpiredCount;
    }

    public final int getAvgExecCount() {
        int n = (int)(System.currentTimeMillis() - this.startMillis);
        return this.timeTriggers.executeCount() * 1000 * 60 / n;
    }

    public int getExecuteCount() {
        return this.timeTriggers.executeCount();
    }

    public int getExceptionCount() {
        return this.timeTriggers.exceptionCount();
    }

    public String getRuntimeName() {
        return RUNTIME_MBEAN_NAME;
    }
}

