/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.common.internal;

import weblogic.common.T3MiscLogger;
import weblogic.time.common.internal.TimeEvent;
import weblogic.utils.AssertionError;
import weblogic.work.WorkManager;

public final class TimeTable
extends TimeEvent {
    private long wakeupTime;
    private int executeCount = 0;
    private int exceptionCount = 0;
    private TimeEvent[] array;
    private int index = 0;
    private long granularity;
    private TimeTable nextTable;

    public TimeTable() {
        this(100, 1000L, System.currentTimeMillis());
    }

    TimeTable(int n, long l, long l2) {
        this.array = new TimeEvent[n];
        this.granularity = l;
        this.time = l2 / l * l;
        this.next = this.prev = this;
        this.array[this.index] = this;
    }

    private final TimeEvent next() {
        TimeEvent timeEvent = this.next;
        this.next = timeEvent.next;
        timeEvent.next.prev = this;
        timeEvent.prev = null;
        return timeEvent;
    }

    public synchronized void insert(TimeEvent timeEvent) {
        long l = timeEvent.time;
        if (l < this.time) {
            l = timeEvent.time = this.time;
        }
        int n = (int)((l - this.time) / this.granularity);
        long l2 = (l - this.time) / this.granularity;
        if (l2 > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        if (n < 0) {
            throw new AssertionError("Time for scheduled trigger out of bounds: " + l);
        }
        if (timeEvent.next != null) {
            timeEvent.next.prev = null;
        }
        if (timeEvent.prev != null) {
            timeEvent.prev.next = null;
        }
        if (n >= this.array.length) {
            if (this.nextTable == null) {
                this.nextTable = new TimeTable(this.array.length, this.granularity * (long)this.array.length, this.time);
            }
            this.nextTable.insert(timeEvent);
        } else {
            int n2 = (this.index + n) % this.array.length;
            if (this.array[n2] != null) {
                if (timeEvent.time < this.array[n2].time) {
                    this.array[n2].prev.insertAfter(timeEvent);
                    this.array[n2] = timeEvent;
                } else {
                    this.array[n2].insertAfter(timeEvent);
                }
            } else {
                this.array[this.next((int)n2)].prev.insertAfter(timeEvent);
                this.array[n2] = timeEvent;
            }
            if (l < this.wakeupTime) {
                this.notify();
            }
        }
    }

    private final int next(int n) {
        do {
            if (++n != this.array.length) continue;
            n = 0;
        } while (this.array[n] == null);
        return n;
    }

    public synchronized boolean delete(TimeEvent timeEvent) {
        int n = (int)((timeEvent.time - this.time) / this.granularity);
        long l = (timeEvent.time - this.time) / this.granularity;
        if (l > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        if (n < 0) {
            return false;
        }
        if (n >= this.array.length && this.nextTable != null) {
            return this.nextTable.delete(timeEvent);
        }
        int n2 = (this.index + n) % this.array.length;
        if (this.array[n2] == timeEvent) {
            this.array[n2] = timeEvent.next != null && (timeEvent.next.time - this.time) / this.granularity == (long)n ? timeEvent.next : null;
        }
        timeEvent.remove();
        return true;
    }

    public void executeTimer(long l, WorkManager workManager, boolean bl) {
        throw new AssertionError("TimeTable executed as timer event");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(long l, WorkManager workManager, boolean bl) {
        TimeEvent timeEvent = null;
        TimeEvent timeEvent2 = null;
        int n = 0;
        TimeTable timeTable = this;
        synchronized (timeTable) {
            this.revise_structures(l);
            timeEvent = this.snip(this.time + this.granularity);
        }
        while (timeEvent != null) {
            try {
                timeEvent2 = timeEvent.next;
                if (timeEvent.next != null) {
                    timeEvent.next.prev = null;
                    timeEvent.next = null;
                }
                if (timeEvent.prev != null) {
                    timeEvent.prev.next = null;
                    timeEvent.prev = null;
                }
                timeEvent.executeTimer(l, workManager, bl);
                ++n;
            }
            catch (Throwable throwable) {
                try {
                    T3MiscLogger.logExecution((String)timeEvent.toString(), (Throwable)throwable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++this.exceptionCount;
            }
            timeEvent = timeEvent2;
        }
        this.executeCount += n;
        return n;
    }

    private final TimeEvent snip(long l) {
        TimeEvent timeEvent = this.next;
        TimeEvent timeEvent2 = this;
        while (timeEvent2.next != this && timeEvent2.next.time < l) {
            timeEvent2 = timeEvent2.next;
        }
        if (timeEvent2 == this) {
            return null;
        }
        this.next = timeEvent2.next;
        timeEvent2.next.prev = this;
        timeEvent2.next = null;
        timeEvent.prev = null;
        return timeEvent;
    }

    public synchronized void snooze() {
        long l = System.currentTimeMillis();
        this.wakeupTime = this.wakeupTime(l);
        try {
            long l2 = this.wakeupTime - l;
            if (l2 <= 0L) {
                throw new AssertionError("Illegal wait time: " + l2);
            }
            this.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long wakeupTime(long l) {
        long l2;
        long l3 = this.next == this || this.next == null ? l + this.granularity * (long)this.array.length : this.next.time;
        if (this.nextTable != null && (l2 = this.nextTable.wakeupTime(l)) < l3) {
            l3 = l2;
        }
        if (l3 <= l + 1L) {
            l3 = l + 1L;
        }
        return l3;
    }

    private final boolean revise_structures(long l) {
        int n = (int)((l - this.time) / this.granularity);
        if (n > 0) {
            int n2 = this.array.length;
            this.time += (long)n * this.granularity;
            while (n-- > 0) {
                this.array[this.index] = null;
                this.index = (this.index + 1) % n2;
            }
            this.array[this.index] = this;
            if (this.nextTable != null && this.nextTable.revise_structures(l)) {
                this.nextTable.collect(this, this.time + this.granularity * (long)n2);
            }
            return true;
        }
        return false;
    }

    private void collect(TimeTable timeTable, long l) {
        while (this.next != this && this.next.time < l) {
            int n;
            TimeEvent timeEvent = this.next();
            int n2 = (int)((timeEvent.time - this.time) / this.granularity);
            if (n2 > 0 && this.array[n = (this.index + n2) % this.array.length] == timeEvent) {
                this.array[n] = timeEvent.next != this && (timeEvent.next.time - this.time) / this.granularity == (long)n2 ? timeEvent.next : null;
            }
            timeEvent.next = null;
            timeTable.insert(timeEvent);
        }
    }

    int executeCount() {
        return this.executeCount;
    }

    int exceptionCount() {
        return this.exceptionCount;
    }

    public synchronized int showState() {
        int n;
        for (n = 0; n < this.array.length; ++n) {
            System.out.print(this.array[n] == this ? "v" : "-");
        }
        System.out.println(": " + this.timeSymbol());
        for (n = 0; n < this.array.length; ++n) {
            System.out.print(this.array[n] == null ? " " : "*");
        }
        System.out.println("");
        TimeEvent timeEvent = this;
        int n2 = 0;
        while (timeEvent.next != this) {
            if (timeEvent.next.prev != timeEvent) {
                throw new AssertionError("node.next.prev != node.next");
            }
            timeEvent = timeEvent.next;
            ++n2;
        }
        System.out.println(this.timeSymbol() + " N=" + n2 + " triggers");
        if (this.nextTable != null) {
            n2 += this.nextTable.showState();
        }
        if (this.granularity == 1000L) {
            System.out.println("Total Trigger Count = " + n2);
        }
        return n2;
    }

    private String timeSymbol() {
        int n = 0;
        for (long i = this.granularity; i > 1000L; i /= (long)this.array.length) {
            ++n;
        }
        return "S^" + n;
    }

    private String timeDelta(long l) {
        long l2 = l - System.currentTimeMillis();
        return l2 / 60000L + ":" + l2 % 60000L / 1000L;
    }
}

