/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.server;

import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RJVM;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.time.common.Schedulable;
import weblogic.time.common.TimeTriggerException;
import weblogic.time.common.Triggerable;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.work.WorkManager;

public final class ScheduledTrigger
extends weblogic.time.common.internal.ScheduledTrigger
implements PeerGoneListener {
    private ClassLoader classLoader;
    private EndPoint clientEndPoint;

    public ScheduledTrigger(Schedulable schedulable, Triggerable triggerable) {
        super(schedulable, triggerable);
    }

    public ScheduledTrigger(Schedulable schedulable, Triggerable triggerable, WorkManager workManager) {
        super(schedulable, triggerable, workManager);
    }

    public ScheduledTrigger(Schedulable schedulable, Triggerable triggerable, TimeEventGenerator timeEventGenerator) {
        super(schedulable, triggerable, timeEventGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        if (this.classLoader != null) {
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        try {
            super.execute();
            Object var2_1 = null;
            Thread.currentThread().setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Thread.currentThread().setContextClassLoader(null);
            throw throwable;
        }
    }

    public boolean cancel() throws TimeTriggerException {
        this.destroy();
        return super.cancel();
    }

    protected void destroy() {
        if (this.clientEndPoint != null && this.clientEndPoint instanceof RJVM) {
            ((RJVM)this.clientEndPoint).removePeerGoneListener((PeerGoneListener)this);
        }
        this.clientEndPoint = null;
        this.classLoader = null;
    }

    public int schedule() throws TimeTriggerException {
        if (!this.isDaemon()) {
            this.clientEndPoint = ServerHelper.getClientEndPointInternal();
            if (this.clientEndPoint != null && this.clientEndPoint instanceof RJVM) {
                ((RJVM)this.clientEndPoint).addPeerGoneListener((PeerGoneListener)this);
            }
        }
        this.classLoader = Thread.currentThread().getContextClassLoader();
        return super.schedule();
    }

    public void peerGone(PeerGoneEvent peerGoneEvent) {
        try {
            this.cancel();
        }
        catch (TimeTriggerException timeTriggerException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Scheduled Trigger";
    }
}

