/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimerTask;
import weblogic.time.common.Schedulable;
import weblogic.time.common.TimeTriggerException;
import weblogic.time.common.Triggerable;
import weblogic.time.server.ScheduledTrigger;
import weblogic.utils.AssertionError;

public class Timer {
    private Collection triggers = new ArrayList();

    public Timer() {
    }

    public Timer(boolean bl) {
    }

    public void schedule(TimerTask timerTask, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, 0L);
    }

    public void schedule(TimerTask timerTask, Date date) {
        this.sched(timerTask, date.getTime(), 0L);
    }

    public void schedule(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, -l2);
    }

    public void schedule(TimerTask timerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, date.getTime(), -l);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, l2);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, date.getTime(), l);
    }

    private void sched(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        if (this.triggers == null) {
            throw new IllegalStateException("Timer already cancelled.");
        }
        PeriodicTask periodicTask = new PeriodicTask(timerTask, l, l2);
        ScheduledTrigger scheduledTrigger = new ScheduledTrigger(periodicTask, periodicTask);
        this.triggers.add(scheduledTrigger);
        try {
            scheduledTrigger.schedule();
        }
        catch (TimeTriggerException timeTriggerException) {
            IllegalStateException illegalStateException = new IllegalStateException("scheduling problem: ");
            illegalStateException.initCause((Throwable)((Object)timeTriggerException));
            throw illegalStateException;
        }
    }

    public void cancel() {
        if (this.triggers == null) {
            return;
        }
        Iterator iterator = this.triggers.iterator();
        this.triggers = null;
        while (iterator.hasNext()) {
            ScheduledTrigger scheduledTrigger = (ScheduledTrigger)iterator.next();
            try {
                scheduledTrigger.cancel();
            }
            catch (TimeTriggerException timeTriggerException) {
                throw new AssertionError("Problem canceling timer", (Throwable)((Object)timeTriggerException));
            }
        }
    }

    static class PeriodicTask
    implements Schedulable,
    Triggerable {
        private final TimerTask task;
        private final long period;
        private long executionTime;

        PeriodicTask(TimerTask timerTask, long l, long l2) {
            this.task = timerTask;
            this.period = l2;
            this.executionTime = l;
        }

        public final void trigger(Schedulable schedulable) {
            this.task.run();
        }

        public final long schedule(long l) {
            long l2 = this.executionTime;
            this.executionTime = this.period == 0L ? 0L : (this.period < 0L ? (this.executionTime -= this.period) : l + this.period);
            return l2;
        }
    }
}

