/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.t3client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.T3Client;
import weblogic.common.T3Exception;
import weblogic.time.common.ScheduledTriggerDef;
import weblogic.time.common.Scheduler;
import weblogic.time.common.TimeTriggerException;
import weblogic.time.common.Trigger;
import weblogic.time.t3client.internal.TimeMsg;
import weblogic.work.WorkManager;

public final class ScheduledTrigger
implements ScheduledTriggerDef,
Externalizable {
    static final long serialVersionUID = 265454191653137961L;
    private transient T3Client t3;
    private Scheduler scheduler;
    private Trigger trigger;
    private transient int regID = -1;
    private transient boolean isDaemon = false;

    public ScheduledTrigger(Scheduler scheduler, Trigger trigger, T3Client t3Client) {
        this.scheduler = scheduler;
        this.trigger = trigger;
        this.t3 = t3Client;
    }

    public ScheduledTrigger() {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.scheduler = (Scheduler)objectInput.readObject();
        this.trigger = (Trigger)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.scheduler);
        objectOutput.writeObject(this.trigger);
    }

    public void initialize() {
        this.scheduler = null;
        this.trigger = null;
        this.t3 = null;
    }

    public void destroy() {
        this.scheduler = null;
        this.trigger = null;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public int schedule() throws TimeTriggerException {
        String string = "(unknown)";
        try {
            this.regID = (Integer)this.t3.sendRecv("weblogic.time.t3client.internal.TimeProxy", new TimeMsg().doSchedule(this, this.isDaemon));
            if (this.isDaemon) {
                this.setDaemon(this.isDaemon);
            }
        }
        catch (T3Exception t3Exception) {
            if (t3Exception.getNestedException() instanceof TimeTriggerException) {
                throw (TimeTriggerException)((Object)t3Exception.getNestedException());
            }
            throw new TimeTriggerException("" + t3Exception.getNestedException());
        }
        return this.regID;
    }

    public static boolean cancel(T3Client t3Client, int n) throws TimeTriggerException {
        try {
            Boolean bl = (Boolean)t3Client.sendRecv("weblogic.time.t3client.internal.TimeProxy", new TimeMsg().doCancel(n));
            return bl;
        }
        catch (T3Exception t3Exception) {
            if (t3Exception.getNestedException() instanceof TimeTriggerException) {
                throw (TimeTriggerException)((Object)t3Exception.getNestedException());
            }
            throw new TimeTriggerException("" + t3Exception.getNestedException());
        }
    }

    public void setDaemon(boolean bl) throws TimeTriggerException {
        if (this.regID == -1) {
            this.isDaemon = bl;
        } else {
            try {
                this.t3.sendRecv("weblogic.time.t3client.internal.TimeProxy", new TimeMsg().doSetDaemon(bl, this.regID));
                this.isDaemon = bl;
            }
            catch (T3Exception t3Exception) {
                if (t3Exception.getNestedException() instanceof TimeTriggerException) {
                    throw (TimeTriggerException)((Object)t3Exception.getNestedException());
                }
                throw new TimeTriggerException("" + t3Exception.getNestedException());
            }
        }
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public void setWorkManager(WorkManager workManager) {
    }

    public boolean cancel() throws TimeTriggerException {
        return ScheduledTrigger.cancel(this.t3, this.regID);
    }
}

