/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.t3client.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.time.t3client.ScheduledTrigger;

public final class TimeMsg
implements Externalizable {
    private static final long serialVersionUID = 5819526650654284539L;
    public static final byte CMD_TRIGGER_SCHEDULE_T = 1;
    public static final byte CMD_TRIGGER_SCHEDULE_F = 2;
    public static final byte CMD_TRIGGER_CANCEL = 3;
    public static final byte CMD_TRIGGER_SET_DAEMON_T = 4;
    public static final byte CMD_TRIGGER_SET_DAEMON_F = 5;
    public static final byte CMD_CLOCK_PING = 6;
    public static final boolean verbose = false;
    static final String[] cmd_names = new String[]{"UNKNOWN", "Schedule Daemon Trigger", "Schedule Trigger", "Cancel Trigger", "Set Daemon True", "Set Daemon False", "Clock Ping"};
    public static final String PROXYCLASS = "weblogic.time.t3client.internal.TimeProxy";
    protected byte cmd;
    protected ScheduledTrigger sch;
    protected int key;
    protected byte tindex;
    protected long t1 = 0L;
    protected long t2 = 0L;
    protected long t3 = 0L;
    protected long t4 = 0L;

    public byte cmd() {
        return this.cmd;
    }

    public String toString() {
        String string = "(unknown)";
        switch (this.cmd) {
            case 1: 
            case 2: {
                string = " sch = " + this.sch.toString();
                break;
            }
            case 3: {
                string = " key = " + this.key;
                break;
            }
            case 6: {
                string = " ts  = \n\tt1=" + (this.t1 != 0L ? new Date(this.t1).toString() : "-") + "/" + this.t1 + "\n\tt2=" + (this.t2 != 0L ? new Date(this.t2).toString() : "-") + "/" + this.t2 + "\n\tt3=" + (this.t3 != 0L ? new Date(this.t3).toString() : "-") + "/" + this.t3 + "\n\tt4=" + (this.t4 != 0L ? new Date(this.t4).toString() : "-") + "/" + this.t4;
            }
        }
        return "TimeMsg: " + cmd_names[this.cmd] + string;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
        this.cmd = wLObjectInput.readByte();
        block0 : switch (this.cmd) {
            case 1: 
            case 2: {
                this.sch = (ScheduledTrigger)wLObjectInput.readObjectWL();
                break;
            }
            case 3: {
                this.key = wLObjectInput.readInt();
                break;
            }
            case 4: {
                this.key = wLObjectInput.readInt();
                break;
            }
            case 5: {
                this.key = wLObjectInput.readInt();
                break;
            }
            case 6: {
                long l = System.currentTimeMillis();
                this.tindex = wLObjectInput.readByte();
                switch (this.tindex) {
                    case 4: {
                        this.t4 = wLObjectInput.readLong();
                    }
                    case 3: {
                        this.t3 = wLObjectInput.readLong();
                    }
                    case 2: {
                        this.t2 = wLObjectInput.readLong();
                    }
                    case 1: {
                        this.t1 = wLObjectInput.readLong();
                    }
                }
                this.tindex = (byte)(this.tindex + 1);
                switch (this.tindex) {
                    case 4: {
                        this.t4 = l;
                        break block0;
                    }
                    case 3: {
                        this.t3 = l;
                        break block0;
                    }
                    case 2: {
                        this.t2 = l;
                        break block0;
                    }
                    case 1: {
                        this.t1 = l;
                    }
                }
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
        wLObjectOutput.writeByte((int)this.cmd);
        switch (this.cmd) {
            case 1: 
            case 2: {
                wLObjectOutput.writeObjectWL((Object)this.sch);
                break;
            }
            case 3: {
                wLObjectOutput.writeInt(this.key);
                break;
            }
            case 4: {
                wLObjectOutput.writeInt(this.key);
                break;
            }
            case 5: {
                wLObjectOutput.writeInt(this.key);
                break;
            }
            case 6: {
                long l = System.currentTimeMillis();
                this.tindex = (byte)(this.tindex + 1);
                switch (this.tindex) {
                    case 4: {
                        this.t4 = l;
                        break;
                    }
                    case 3: {
                        this.t3 = l;
                        break;
                    }
                    case 2: {
                        this.t2 = l;
                        break;
                    }
                    case 1: {
                        this.t1 = l;
                    }
                }
                wLObjectOutput.writeByte((int)this.tindex);
                switch (this.tindex) {
                    case 4: {
                        wLObjectOutput.writeLong(this.t4);
                    }
                    case 3: {
                        wLObjectOutput.writeLong(this.t3);
                    }
                    case 2: {
                        wLObjectOutput.writeLong(this.t2);
                    }
                    case 1: {
                        wLObjectOutput.writeLong(this.t1);
                    }
                }
            }
        }
    }

    public TimeMsg doSchedule(ScheduledTrigger scheduledTrigger, boolean bl) {
        this.cmd = (byte)(bl ? 1 : 2);
        this.sch = scheduledTrigger;
        return this;
    }

    public TimeMsg doSetDaemon(boolean bl, int n) {
        this.cmd = (byte)(bl ? 4 : 5);
        this.key = n;
        return this;
    }

    public TimeMsg doCancel(int n) {
        this.cmd = (byte)3;
        this.key = n;
        return this;
    }

    public TimeMsg doPing() {
        this.cmd = (byte)6;
        return this;
    }
}

