/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.t3client.internal;

import java.io.Serializable;
import weblogic.common.T3Exception;
import weblogic.common.T3Executable;
import weblogic.t3.srvr.ExecutionContext;
import weblogic.time.common.ScheduledTriggerDef;
import weblogic.time.common.TimeTriggerException;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.time.t3client.ScheduledTrigger;
import weblogic.time.t3client.internal.TimeMsg;

public final class TimeProxy
implements T3Executable {
    public void initialize() {
    }

    public void destroy() {
    }

    public Object execute(ExecutionContext executionContext, Object object) throws T3Exception {
        TimeMsg timeMsg = (TimeMsg)object;
        Serializable serializable = null;
        switch (timeMsg.cmd) {
            case 1: 
            case 2: {
                ScheduledTrigger scheduledTrigger = timeMsg.sch;
                try {
                    ScheduledTriggerDef scheduledTriggerDef = executionContext.getServices().time().getScheduledTrigger(scheduledTrigger.getScheduler(), scheduledTrigger.getTrigger());
                    serializable = new Integer(scheduledTriggerDef.schedule());
                    TimeEventGenerator.getOne().register(serializable, scheduledTriggerDef);
                    break;
                }
                catch (TimeTriggerException timeTriggerException) {
                    throw new T3Exception("nested exception:", (Throwable)((Object)timeTriggerException));
                }
            }
            case 4: 
            case 5: {
                ScheduledTriggerDef scheduledTriggerDef = TimeEventGenerator.getOne().registered(new Integer(timeMsg.key));
                try {
                    if (scheduledTriggerDef == null) {
                        throw new TimeTriggerException("Unknown ScheduledTrigger, id=" + timeMsg.key);
                    }
                    scheduledTriggerDef.setDaemon(timeMsg.cmd == 4);
                    break;
                }
                catch (TimeTriggerException timeTriggerException) {
                    throw new T3Exception("TimeTriggerException: " + (Object)((Object)timeTriggerException));
                }
            }
            case 3: {
                ScheduledTriggerDef scheduledTriggerDef = TimeEventGenerator.getOne().unregister(new Integer(timeMsg.key));
                try {
                    if (scheduledTriggerDef != null) {
                        serializable = new Boolean(scheduledTriggerDef.cancel());
                        break;
                    }
                    serializable = new Boolean(false);
                    break;
                }
                catch (TimeTriggerException timeTriggerException) {
                    throw new T3Exception("TimeTriggerException: " + (Object)((Object)timeTriggerException));
                }
            }
            case 6: {
                serializable = timeMsg;
                break;
            }
            default: {
                throw new T3Exception("Unknown TimeMsg Command: " + timeMsg.cmd);
            }
        }
        return serializable;
    }
}

