/*
 * Decompiled with CFR 0.152.
 */
package weblogic.time.t3client.internal;

import weblogic.common.DisconnectEvent;
import weblogic.common.DisconnectListener;
import weblogic.common.T3Client;
import weblogic.common.T3Exception;
import weblogic.common.T3ServicesDef;
import weblogic.time.common.Schedulable;
import weblogic.time.common.ScheduledTriggerDef;
import weblogic.time.common.Scheduler;
import weblogic.time.common.TimeServicesDef;
import weblogic.time.common.TimeTriggerException;
import weblogic.time.common.Trigger;
import weblogic.time.common.Triggerable;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.time.t3client.ScheduledTrigger;
import weblogic.time.t3client.internal.TimeMsg;

public final class TimeServicesImpl
implements TimeServicesDef,
DisconnectListener {
    T3Client t3;
    T3ServicesDef svc;
    private static final boolean verbose = false;
    boolean needsInitSync = true;
    int roundTripDelayMillis = 0;
    int localClockOffsetMillis = 0;
    long serverTimeDiff = 0L;
    Object initLock = new Object();
    private TimeEventGenerator teg = null;

    public TimeServicesImpl(T3ServicesDef t3ServicesDef, T3Client t3Client) {
        this.t3 = t3Client;
        this.svc = t3ServicesDef;
        t3Client.addDisconnectListener(this);
    }

    public ScheduledTriggerDef getScheduledTrigger(Schedulable schedulable, Triggerable triggerable) {
        if (this.teg == null) {
            this.teg = TimeEventGenerator.getOne();
        }
        return new weblogic.time.common.internal.ScheduledTrigger(schedulable, triggerable, this.teg);
    }

    public ScheduledTriggerDef getScheduledTrigger(Scheduler scheduler, Trigger trigger) throws TimeTriggerException {
        if (scheduler.theObject() != null && trigger.theObject() != null) {
            scheduler.private_initialize(this.svc);
            trigger.private_initialize(this.svc);
            return this.getScheduledTrigger((Schedulable)scheduler.theObject(), (Triggerable)trigger.theObject());
        }
        return new ScheduledTrigger(scheduler, trigger, this.t3);
    }

    public void disconnectOccurred(DisconnectEvent disconnectEvent) {
        if (this.teg != null) {
            this.teg.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTimeSync() throws T3Exception {
        if (this.needsInitSync) {
            Object object = this.initLock;
            synchronized (object) {
                if (this.needsInitSync) {
                    this.needsInitSync = false;
                    try {
                        TimeMsg timeMsg = (TimeMsg)this.t3.sendRecv("weblogic.time.t3client.internal.TimeProxy", new TimeMsg().doPing());
                        long l = (timeMsg.t2 - timeMsg.t1 + (timeMsg.t3 - timeMsg.t4)) / 2L;
                        long l2 = timeMsg.t4 - timeMsg.t1 - (timeMsg.t2 - timeMsg.t3);
                        this.localClockOffsetMillis = (int)l;
                        this.roundTripDelayMillis = (int)l2;
                        this.serverTimeDiff = timeMsg.t2 - timeMsg.t1 - l2 / 2L;
                    }
                    catch (T3Exception t3Exception) {
                        if (t3Exception.getNestedException() instanceof T3Exception) {
                            throw (T3Exception)t3Exception.getNestedException();
                        }
                        throw new T3Exception("" + t3Exception.getNestedException());
                    }
                }
            }
        }
    }

    public long currentTimeMillis() throws T3Exception {
        this.initTimeSync();
        return System.currentTimeMillis() + this.serverTimeDiff;
    }

    public int getRoundTripDelayMillis() throws T3Exception {
        this.initTimeSync();
        return this.roundTripDelayMillis;
    }

    public int getLocalClockOffsetMillis() throws T3Exception {
        this.initTimeSync();
        return this.localClockOffsetMillis;
    }
}

