/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.security.AccessController;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.Timer;
import weblogic.management.runtime.TimerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.internal.TimerImpl;

public final class TimerRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements TimerRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    TimerRuntimeMBeanImpl() throws ManagementException {
        super("TimerRuntime");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().setTimerRuntime(this);
    }

    public Timer[] getTimers() {
        TimerImpl[] timerImplArray = TimerImpl.getTimers();
        if (timerImplArray == null || timerImplArray.length == 0) {
            return null;
        }
        Timer[] timerArray = new Timer[timerImplArray.length];
        for (int i = 0; i < timerImplArray.length; ++i) {
            timerArray[i] = new TimerRuntime(timerImplArray[i]);
        }
        return timerArray;
    }

    public static final class TimerRuntime
    implements Timer {
        static final long serialVersionUID = -1639099960837088234L;
        private final String timerManagerName;
        private final long timeout;
        private final long period;
        private final boolean stopped;
        private final boolean cancelled;
        private final long[] pastExpirationTimes;

        public TimerRuntime(TimerImpl timerImpl) {
            this.timerManagerName = timerImpl.getTimerManager().getName() + "[" + timerImpl.toString() + "]";
            this.timeout = timerImpl.getTimeout();
            this.period = Math.abs(timerImpl.getPeriod());
            this.stopped = timerImpl.isStopped();
            this.cancelled = timerImpl.isCancelled();
            this.pastExpirationTimes = timerImpl.sortedExpirationTimes();
        }

        public String getTimerManagerName() {
            return this.timerManagerName;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public long getPeriod() {
            return this.period;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public long getExpirationCount() {
            return this.pastExpirationTimes.length;
        }

        public long[] getPastExpirationTimes() {
            return this.pastExpirationTimes;
        }
    }
}

