/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import weblogic.management.ManagementException;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.timers.internal.TimerRuntimeMBeanImpl;
import weblogic.timers.internal.TimerThread;

public class TimerService
extends AbstractServerService {
    private static final int STARTED = 0;
    private static final int STOPPED = 1;
    private static final int HALTED = 2;
    private static TimerService singleton;
    private TimerThread timerThread;
    private boolean initialized;
    private int state = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerService() {
        Class<TimerService> clazz = TimerService.class;
        synchronized (TimerService.class) {
            if (singleton != null) {
                throw new IllegalStateException();
            }
            singleton = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            this.timerThread = TimerThread.getTimerThread();
            try {
                new TimerRuntimeMBeanImpl();
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
            this.initialized = true;
        }
    }

    public String getVersion() {
        return "Commonj TimerManager v1.1";
    }

    public synchronized void start() throws ServiceFailureException {
        this.initialize();
        this.timerThread.start();
        if (this.state != 0) {
            ((Object)((Object)this)).notifyAll();
        }
        this.state = 0;
    }

    public synchronized void stop() throws ServiceFailureException {
        try {
            this.checkInitialized();
        }
        catch (IllegalStateException illegalStateException) {
            throw new ServiceFailureException("Error stopping service", (Throwable)illegalStateException);
        }
        this.timerThread.halt();
        this.state = 2;
    }

    public synchronized void halt() throws ServiceFailureException {
        this.stop();
    }

    private void checkInitialized() {
        if (this.initialized) {
            return;
        }
        throw new IllegalStateException("Service is not initialized");
    }
}

