/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class AWTUtils {
    private static final boolean debug = false;
    protected static boolean confirm = false;

    public static Image loadImage(ClassLoader classLoader, String string) {
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return AWTUtils.loadImage(string);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            return toolkit.createImage((ImageProducer)uRL.getContent());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Image loadImage(String string) {
        try {
            URL uRL = AWTUtils.class.getResource(string);
            if (uRL == null) {
                uRL = AWTUtils.class.getResource("/weblogic/graphics/" + string);
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            return toolkit.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URL getResourceURL(String string) {
        URL uRL = AWTUtils.class.getResource(string);
        if (uRL == null) {
            uRL = AWTUtils.class.getResource("/weblogic/graphics/" + string);
        }
        return uRL;
    }

    public static GridBagConstraints gbc(int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        if (gridBagConstraints.gridwidth > 1) {
            gridBagConstraints.weightx = gridBagConstraints.gridwidth;
        }
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        return gridBagConstraints;
    }

    public static void frontAndCenter(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        window.setLocation(new Point(n, n2));
    }

    public static void centerOnWindow(Window window, Window window2) {
        if (window2 == null || !window2.isVisible()) {
            AWTUtils.frontAndCenter(window);
            return;
        }
        Dimension dimension = window.getSize();
        Dimension dimension2 = window2.getSize();
        Point point = window2.getLocation();
        point.x = dimension2.width - dimension.width < 20 && dimension2.height - dimension.height < 20 ? (point.x += 20) : (point.x += (dimension2.width - dimension.width) / 2);
        point.y += (dimension2.height - dimension.height) / 2;
        point.x = Math.max(point.x, 5);
        point.y = Math.max(point.y, 5);
        window.setLocation(point);
    }

    public static Point getNextCascadeLocation(Point point, Window window) {
        int n = point.x + 20;
        int n2 = point.y + 20;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        if (n + dimension2.height > dimension.height || n2 + dimension2.height > dimension.height) {
            n = 0;
            n2 = 0;
        }
        return new Point(n, n2);
    }

    public static boolean confirm(Frame frame, String string) {
        int n = JOptionPane.showConfirmDialog(frame, "Confirm", string, 0);
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                throw new Error("Boolean logic fails us!");
            }
        }
        return bl;
    }

    public static void message(Frame frame, String string) {
        JOptionPane.showMessageDialog(frame, "Error", string, 0);
    }

    public static boolean confirm(String string) {
        return AWTUtils.confirm(null, string);
    }

    public static void message(String string) {
        AWTUtils.message(null, string);
    }

    public static void initLookAndFeel() {
        AWTUtils.initLookAndFeel(null, false);
    }

    public static void initLookAndFeel(String string, boolean bl) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (string != null) {
            try {
                if (string.equals("java")) {
                    UIManager.setLookAndFeel("javax.swing.jlf.JLFLookAndFeel");
                } else if (string.equals("basic")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.basic.BasicLookAndFeel");
                } else if (string.equals("metal")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                } else if (string.equals("motif")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                } else if (string.startsWith("win")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                } else {
                    UIManager.setLookAndFeel(string);
                }
                return;
            }
            catch (Exception exception) {
                if (bl) {
                    System.err.println("Could not set LookAndFeel to " + string + ": " + exception.toString());
                }
                string = null;
            }
        }
        try {
            String string2 = System.getProperty("os.name");
            if (string2 != null && ((string2 = string2.toLowerCase()).indexOf("digital unix") >= 0 || string2.indexOf("linux") >= 0 || string2.indexOf("solaris") >= 0)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                if (bl) {
                    System.err.println("Trying to set SystemLookAndFeel: " + exception.toString());
                }
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }
}

