/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JButton;
import javax.swing.UIManager;

public class ArrowButton
extends JButton {
    public static final int UP = 1;
    public static final int DOWN = 5;
    private int direction;
    private boolean allowFocusTraverse = true;
    private Dimension prefSize;

    public ArrowButton(int n) {
        this.direction = n == 1 ? 1 : 5;
        this.setOpaque(false);
    }

    public Dimension getPreferredSize() {
        if (this.prefSize != null) {
            return new Dimension(this.prefSize.width, this.prefSize.height);
        }
        Dimension dimension = super.getPreferredSize();
        Font font = this.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = Math.min(dimension.width, fontMetrics.getHeight() + 8);
        return new Dimension(n, n);
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public void setFocusTraversable(boolean bl) {
        this.allowFocusTraverse = bl;
    }

    public boolean isFocusTraversable() {
        return this.allowFocusTraverse;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.getModel().isPressed()) {
            graphics.translate(1, 1);
        }
        this.paintTriangle(graphics, 3 * n / 8, 3 * n2 / 8, n2 / 4, this.direction, this.isEnabled());
    }

    public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        int n5 = 0;
        n3 = Math.max(n3, 2);
        int n6 = n3 / 2;
        graphics.translate(n, n2);
        if (bl) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(UIManager.getDefaults().getColor("controlShadow"));
        }
        switch (n4) {
            case 1: {
                int n7;
                for (n7 = 0; n7 < n3; ++n7) {
                    graphics.drawLine(n6 - n7, n7, n6 + n7, n7);
                }
                if (bl) break;
                graphics.setColor(UIManager.getDefaults().getColor("controlHighlight"));
                graphics.drawLine(n6 - n7 + 2, n7, n6 + n7, n7);
                break;
            }
            case 5: {
                int n8;
                if (!bl) {
                    graphics.translate(1, 1);
                    graphics.setColor(UIManager.getDefaults().getColor("controlHighlight"));
                    for (n8 = n3 - 1; n8 >= 0; --n8) {
                        graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                        ++n5;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(UIManager.getDefaults().getColor("controlShadow"));
                }
                n5 = 0;
                for (n8 = n3 - 1; n8 >= 0; --n8) {
                    graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                    ++n5;
                }
                break;
            }
        }
    }
}

