/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import weblogic.servlet.jsp.BeanUtils;
import weblogic.tools.ui.BeanTableModel;
import weblogic.tools.ui.IBeanRowEditor;
import weblogic.tools.ui.MarathonTextFormatter;
import weblogic.tools.ui.ModelPanel;
import weblogic.tools.ui.RowEditorDialog;
import weblogic.utils.StringUtils;

public class BeanGrid
extends ModelPanel
implements ActionListener,
ListSelectionListener,
MouseListener {
    private static MarathonTextFormatter fmt = new MarathonTextFormatter();
    private boolean m_onlyAcceptUniqueEntries = false;
    private JTable table;
    private BeanTableModel model;
    private DefaultTableColumnModel columnModel;
    private DefaultListSelectionModel selectionModel;
    private JButton deleteB;
    private JButton addB;
    private JButton editB;
    private JScrollPane tableScrollPane;
    private Border m_border = new EmptyBorder(2, 2, 2, 2);
    private boolean m_createBorder = false;
    private String m_editorDialogTitle = null;
    Container buttonPane = null;
    Class bc;
    BeanInfo bi;
    PropertyDescriptor[] pds;
    Object[] beans;
    String[] props;
    String[] titles;
    IBeanRowEditor bre;

    public BeanGrid(Object[] objectArray) {
        this(objectArray, null);
    }

    public BeanGrid(Object[] objectArray, IBeanRowEditor iBeanRowEditor) {
        this(objectArray, null, null, null, iBeanRowEditor);
    }

    public BeanGrid(Object[] objectArray, String[] stringArray, String[] stringArray2) {
        this(objectArray, stringArray, stringArray2, null);
    }

    public BeanGrid(Object[] objectArray, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this(objectArray, stringArray, stringArray2, stringArray3, null);
    }

    public BeanGrid(Object[] objectArray, String[][] stringArray, IBeanRowEditor iBeanRowEditor) {
        String[][] stringArray2 = this.invertArray(stringArray);
        this.init(objectArray, stringArray2[0], stringArray2[1], stringArray2[2], iBeanRowEditor);
    }

    public BeanGrid(Object[] objectArray, String[] stringArray, String[] stringArray2, String[] stringArray3, IBeanRowEditor iBeanRowEditor) {
        this.init(objectArray, stringArray, stringArray2, stringArray3, iBeanRowEditor);
    }

    public void setEditorDialogTitle(String string) {
        this.m_editorDialogTitle = string;
    }

    public void setOnlyAcceptUniqueEntries(boolean bl) {
        this.m_onlyAcceptUniqueEntries = bl;
    }

    public boolean alreadyExists(Object object) {
        for (int i = 0; i < this.beans.length; ++i) {
            if (null == object || !object.equals(this.beans[i])) continue;
            return true;
        }
        return false;
    }

    public void cleanup() {
        this.bi = null;
        this.beans = null;
        this.bre = null;
    }

    public void setEditable(boolean bl) {
        this.model.setEditable(bl);
        this.table.setShowVerticalLines(false);
        this.table.setBackground(Color.lightGray);
    }

    public JTable getTable() {
        return this.table;
    }

    private void init(Object[] objectArray, String[] stringArray, String[] stringArray2, String[] stringArray3, IBeanRowEditor iBeanRowEditor) {
        int n;
        this.beans = objectArray;
        this.bre = iBeanRowEditor;
        if (this.m_createBorder) {
            this.setBorder(this.m_border);
        }
        if (objectArray == null) {
            return;
        }
        this.bc = objectArray.getClass().getComponentType();
        if (this.bc.isArray()) {
            throw new RuntimeException("multi-dimensional array");
        }
        if (BeanUtils.isStringConvertible(this.bc)) {
            throw new RuntimeException("use PrimitiveGrid for primitive types");
        }
        try {
            this.bi = Introspector.getBeanInfo(this.bc);
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException(introspectionException.toString());
        }
        this.pds = this.bi.getPropertyDescriptors();
        this.props = stringArray;
        this.fixPDs();
        if (this.props == null) {
            this.props = new String[this.pds.length];
            for (n = 0; n < this.pds.length; ++n) {
                this.props[n] = this.pds[n].getName();
            }
        }
        this.titles = stringArray2;
        if (this.titles == null) {
            this.titles = new String[this.props.length];
            for (n = 0; n < this.titles.length; ++n) {
                this.titles[n] = StringUtils.ucfirst((String)this.props[n]);
            }
        }
        this.makeTable();
        for (n = 0; stringArray3 != null && n < stringArray3.length; ++n) {
            this.table.putClientProperty("wl.helpanchor." + n, stringArray3[n]);
        }
        for (n = 0; n < this.titles.length; ++n) {
            TableColumn tableColumn = this.columnModel.getColumn(n);
            tableColumn.setHeaderValue(BeanGrid.uncolon(this.titles[n]));
        }
        n = this.table.getRowCount() * this.table.getRowHeight();
        int n2 = this.table.getColumnModel().getTotalColumnWidth();
        this.table.setPreferredScrollableViewportSize(new Dimension(n2, n));
        this.tableScrollPane = new JScrollPane(this.table);
        this.tableScrollPane.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tableScrollPane, "Center");
        this.buttonPane = this.makeButtonPane();
        this.add((Component)this.buttonPane, "South");
    }

    private static String uncolon(String string) {
        int n = 0;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        if (string.charAt(n - 1) == ':') {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    private String[][] invertArray(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length == 3) continue;
            throw new IllegalArgumentException("expected row length 3, not " + stringArray[i].length);
        }
        String[][] stringArray2 = new String[3][stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[0][i] = stringArray[i][0];
            stringArray2[1][i] = stringArray[i][1];
            stringArray2[2][i] = stringArray[i][2];
        }
        return stringArray2;
    }

    public void setParentInfo(Object object, String string) {
        this.model.setParentInfo(object, string);
    }

    public void setParentAdder(Object object, String string) {
        this.model.setParentAdder(object, string);
    }

    public void setConstrained(String string, Object[] objectArray) {
        this.setConstrained(string, objectArray, false);
    }

    public void setConstrained(String string, Object[] objectArray, boolean bl) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(bl);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        TableColumn tableColumn = this.table.getColumn(BeanGrid.uncolon(string));
        tableColumn.setCellEditor(defaultCellEditor);
    }

    public Object[] getBeans() {
        return this.beans;
    }

    public void setBeans(Object[] objectArray) {
        Class<?> clazz;
        Class<?> clazz2 = this.beans.getClass().getComponentType();
        if (!clazz2.isAssignableFrom(clazz = objectArray.getClass().getComponentType())) {
            String string = clazz.getName();
            String string2 = clazz2.getName();
            throw new IllegalArgumentException("type mismatch: new=" + string + " old=" + string2);
        }
        this.beans = (Object[])objectArray.clone();
        this.model.setBeans(objectArray);
        this.model.fireTableDataChanged();
    }

    public boolean isEditable(int n) {
        return this.model.isCellEditable(0, n);
    }

    public void setEditable(int n, boolean bl) {
        this.model.setEditable(n, bl);
    }

    public void modelToUI() {
    }

    public void uiToModel() {
    }

    private void fixPDs() {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        for (int i = 0; i < this.pds.length; ++i) {
            if (this.pds[i].getReadMethod() == null) continue;
            arrayList.add(this.pds[i]);
        }
        this.pds = new PropertyDescriptor[arrayList.size()];
        arrayList.toArray(this.pds);
    }

    private void makeTable() {
        this.model = new BeanTableModel(this.bc, this.bi, this.pds, this.beans, this.props, this.titles);
        this.table = new JTable();
        this.table.addMouseListener(this);
        this.table.setBorder(null);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        this.table.setModel(this.model);
        this.columnModel = (DefaultTableColumnModel)this.table.getColumnModel();
        this.selectionModel = (DefaultListSelectionModel)this.table.getSelectionModel();
        this.selectionModel.addListSelectionListener(this);
        this.selectionModel.setSelectionMode(0);
    }

    private Container makeButtonPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weightx = 1.0;
        this.addB = new JButton(fmt.getAddEllipsis());
        jPanel.add((Component)this.addB, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.addB.addActionListener(this);
        ++gridBagConstraints.gridx;
        this.editB = new JButton(fmt.getEditEllipsis());
        jPanel.add((Component)this.editB, gridBagConstraints);
        this.editB.addActionListener(this);
        ++gridBagConstraints.gridx;
        this.deleteB = new JButton(fmt.getDelete());
        jPanel.add((Component)this.deleteB, gridBagConstraints);
        this.deleteB.addActionListener(this);
        this.editB.setEnabled(false);
        this.deleteB.setEnabled(false);
        jPanel.setBorder(null);
        return jPanel;
    }

    public JButton getAddButton() {
        return this.addB;
    }

    public JButton getEditButton() {
        return this.editB;
    }

    public JButton getDeleteButton() {
        return this.deleteB;
    }

    private static void p(String string) {
        System.err.println(string);
    }

    private void deleteBean(Object object) {
        try {
            Method method = object.getClass().getMethod("onDelete", new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("Warning:  couldn't find onDelete() on " + object.getClass());
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.selectionModel.getLeadSelectionIndex();
        int n2 = this.table.getRowCount();
        if (this.selectionModel.isSelectionEmpty()) {
            this.editB.setEnabled(false);
            this.deleteB.setEnabled(false);
        } else {
            this.editB.setEnabled(true & this.bre != null);
            this.deleteB.setEnabled(true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() < 2) {
            return;
        }
        int n = this.table.getSelectedRow();
        if (this.beans != null && n >= 0 && n < this.beans.length) {
            this.editObject(this.beans[n]);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.selectionModel.getLeadSelectionIndex();
        Object object = actionEvent.getSource();
        int n2 = this.table.getRowCount();
        if (object == this.deleteB) {
            if (n < 0 || n >= n2) {
                return;
            }
            this.doDelete(n);
            this.beans = this.model.getBeans();
            if (n < --n2) {
                this.selectionModel.setSelectionInterval(n, n);
            } else if (n2 > 0) {
                this.selectionModel.setSelectionInterval(n - 1, n - 1);
            }
            if (this.model.getRowCount() == 0) {
                this.editB.setEnabled(false);
                this.deleteB.setEnabled(false);
            }
        } else if (object == this.addB) {
            Object object2 = this.doAdd();
            if (object2 == null) {
                return;
            }
            this.model.addRow(object2);
            this.beans = this.model.getBeans();
        } else if (object == this.editB) {
            this.editObject(this.beans[n]);
        }
    }

    protected void editObject(Object object) {
        if (this.bre != null) {
            RowEditorDialog rowEditorDialog = null;
            rowEditorDialog = new RowEditorDialog(this.getEnclosingFrame(), "", true, this.bre);
            rowEditorDialog.editObject(object);
            this.model.fireTableDataChanged();
        }
    }

    public void doDelete(int n) {
        this.deleteBean(this.beans[n]);
        this.model.removeRow(n);
    }

    public Object doAdd() {
        if (this.bre == null) {
            return null;
        }
        RowEditorDialog rowEditorDialog = new RowEditorDialog(this.getEnclosingFrame(), this.m_editorDialogTitle, true, this.bre);
        Object object = rowEditorDialog.addObject();
        while (object != null && this.m_onlyAcceptUniqueEntries && this.alreadyExists(object)) {
            String string = fmt.getEntryAlreadyExists();
            String string2 = fmt.getIllegalEntry();
            JOptionPane.showMessageDialog(this, string, string2, 0);
            rowEditorDialog.editObject(object);
            if (!rowEditorDialog.wasCancelled()) continue;
            object = null;
        }
        return object;
    }

    protected Frame getEnclosingFrame() {
        Container container = this.getParent();
        do {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        } while ((container = container.getParent()) != null);
        return null;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.tableScrollPane.getPreferredSize();
        Dimension dimension2 = this.buttonPane.getMinimumSize();
        Dimension dimension3 = this.buttonPane.getMinimumSize();
        return dimension3;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

