/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.table.AbstractTableModel;
import weblogic.servlet.jsp.BeanUtils;

public class BeanTableModel
extends AbstractTableModel {
    Class beanClass;
    BeanInfo beanInfo;
    PropertyDescriptor[] propertyDescriptors;
    Object[] beans;
    String[] props;
    boolean[] editable;
    Object parentBean;
    Method parentSetter;
    Method parentAdder;
    private static final Object[] NO_ARGS = new Object[0];

    public BeanTableModel(Class clazz, BeanInfo beanInfo, PropertyDescriptor[] propertyDescriptorArray, Object[] objectArray, String[] stringArray, String[] stringArray2) {
        this.beanClass = clazz;
        this.beanInfo = beanInfo;
        this.propertyDescriptors = propertyDescriptorArray;
        this.beans = objectArray;
        this.props = stringArray;
        this.editable = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.editable[i] = BeanUtils.isStringConvertible(propertyDescriptorArray[i].getPropertyType());
            this.editable[i] = true;
        }
    }

    public void setEditable(boolean bl) {
        for (int i = 0; i < this.editable.length; ++i) {
            this.editable[i] = bl;
        }
    }

    static void p(String string) {
        System.err.println("[BGModel]: " + string);
    }

    private void setParentInfo(Object object, String string, boolean bl) {
        Class<?> clazz;
        if (object == null) {
            this.parentSetter = null;
            this.parentAdder = null;
            this.parentBean = null;
            return;
        }
        RuntimeException runtimeException = null;
        for (clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                this.parentAdder = bl ? this.findAdder(clazz, string) : null;
                this.parentSetter = this.findSetter(clazz, string);
                this.parentBean = object;
                return;
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException != null) continue;
                runtimeException = runtimeException2;
                continue;
            }
        }
        if (runtimeException == null) {
            runtimeException = new RuntimeException("Couldn't find " + clazz.getClass() + " .set" + string + "(" + this.beans.getClass().getComponentType() + ")");
        }
        throw runtimeException;
    }

    public void setParentInfo(Object object, String string) {
        this.setParentInfo(object, string, false);
    }

    public void setParentAdder(Object object, String string) {
        this.setParentInfo(object, string, true);
    }

    private Method findAdder(Class clazz, String string) {
        Method method = null;
        int n = string.length();
        if (null != string && 's' == string.charAt(n - 1)) {
            string = string.substring(0, n - 1);
        }
        String string2 = "add" + string;
        try {
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
                Class<?> clazz2;
                Class<?>[] classArray;
                Method method2;
                int n2;
                if (!methodArray[i].getName().equalsIgnoreCase(string2) || ((n2 = (method2 = methodArray[i]).getModifiers()) & 1) == 0 || (classArray = method2.getParameterTypes()) == null || classArray.length != 1 || !(clazz2 = classArray[0]).isAssignableFrom(this.beanClass)) continue;
                method = method2;
            }
            String string3 = "Couldn't find " + clazz.getName() + "." + string2 + "(" + this.beanClass.getName() + "[])";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("nested: " + exception);
        }
        return method;
    }

    private Method findSetter(Class clazz, String string) {
        String string2 = "set" + string;
        try {
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
                Class<?> clazz2;
                Class<?>[] classArray;
                Method method;
                int n;
                if (!methodArray[i].getName().equalsIgnoreCase(string2) || ((n = (method = methodArray[i]).getModifiers()) & 1) == 0 || (classArray = method.getParameterTypes()) == null || classArray.length != 1 || !classArray[0].isArray() || !(clazz2 = classArray[0].getComponentType()).isAssignableFrom(this.beanClass)) continue;
                return method;
            }
            String string3 = "Couldn't find " + clazz.getName() + "." + string2 + "(" + this.beanClass.getName() + "[])";
            throw new RuntimeException(string3);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("nested: " + exception);
        }
    }

    public Object[] getBeans() {
        return this.beans;
    }

    public void setBeans(Object[] objectArray) {
        this.beans = objectArray;
    }

    private PropertyDescriptor getPD(String string) {
        int n;
        for (n = 0; n < this.propertyDescriptors.length; ++n) {
            if (!this.propertyDescriptors[n].getName().equals(string)) continue;
            return this.propertyDescriptors[n];
        }
        for (n = 0; n < this.propertyDescriptors.length; ++n) {
            if (!this.propertyDescriptors[n].getName().equalsIgnoreCase(string)) continue;
            return this.propertyDescriptors[n];
        }
        return null;
    }

    public Class getColumnClass(int n) {
        PropertyDescriptor propertyDescriptor = this.getPD(this.props[n]);
        if (propertyDescriptor == null) {
            return Object.class;
        }
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz)) {
            return Number.class;
        }
        return Object.class;
    }

    public void setEditable(int n, boolean bl) {
        PropertyDescriptor propertyDescriptor;
        if (bl && (propertyDescriptor = this.getPD(this.props[n])).getWriteMethod() == null) {
            String string = "property " + this.props[n] + " on " + this.beanClass.getName() + " cannot be editable, it has no write method";
            throw new RuntimeException(string);
        }
        this.editable[n] = bl;
    }

    private static void handleITE(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable.toString());
    }

    public boolean isCellEditable(int n, int n2) {
        return this.editable[n2];
    }

    public int getColumnCount() {
        return this.props.length;
    }

    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray;
        if (null == object) {
            return;
        }
        BeanTableModel.p("setValueAt(" + n + "," + n2 + ")->\"" + object + "\"(" + object.getClass().getName() + ")");
        PropertyDescriptor propertyDescriptor = this.getPD(this.props[n2]);
        Method method = propertyDescriptor.getWriteMethod();
        if (null == method) {
            throw new RuntimeException("Couldn't find a setter for " + propertyDescriptor.getReadMethod().getName());
        }
        Object object2 = null;
        if (!BeanUtils.isStringConvertible(propertyDescriptor.getPropertyType())) {
            object2 = object;
        } else {
            objectArray = object.toString();
            object2 = this.convertArg((String)objectArray, propertyDescriptor.getPropertyType());
        }
        try {
            objectArray = new Object[]{object2};
            method.invoke(this.beans[n], objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            BeanTableModel.handleITE(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.getRowCount()) {
            return null;
        }
        if (n2 >= this.props.length) {
            return null;
        }
        try {
            PropertyDescriptor propertyDescriptor = this.getPD(this.props[n2]);
            if (propertyDescriptor == null) {
                String string = "bean class " + this.beanClass.getName() + " has no property " + this.props[n2];
                throw new RuntimeException(string);
            }
            Method method = propertyDescriptor.getReadMethod();
            Object object = method.invoke(this.beans[n], NO_ARGS);
            if (propertyDescriptor.getPropertyType().isArray() && propertyDescriptor.getPropertyType().getComponentType() == String.class) {
                object = this.makeStringList((String[])object);
            }
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            BeanTableModel.handleITE(invocationTargetException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    public int getRowCount() {
        return this.beans.length;
    }

    public void removeRow(int n) {
        Class<?> clazz = this.beans.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.beans.length - 1);
        System.arraycopy(this.beans, 0, objectArray, 0, n);
        System.arraycopy(this.beans, n + 1, objectArray, n, this.beans.length - n - 1);
        this.beans = objectArray;
        this.invokeParentSetter();
        this.fireTableRowsDeleted(n, n);
    }

    public void addRow(Object object) {
        Class<?> clazz = this.beans.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.beans.length + 1);
        for (int i = 0; i < this.beans.length; ++i) {
            objectArray[i] = this.beans[i];
        }
        try {
            objectArray[this.beans.length] = object;
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ArrayStoreException("Make sure the beans stored in the table and the type  returned by createNewBean() match.");
        }
        this.beans = objectArray;
        if (this.parentAdder != null) {
            this.invokeParentAdder(object);
        } else {
            this.invokeParentSetter();
        }
        this.fireTableRowsInserted(this.beans.length - 1, this.beans.length - 1);
    }

    private String makeStringList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (stringArray[i] != null) {
                stringBuffer.append(stringArray[i]);
            }
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    private void invokeParentSetter() {
        Object[] objectArray = new Object[]{this.beans};
        this.invokeMethod(this.parentSetter, objectArray);
    }

    private void invokeParentAdder(Object object) {
        Object[] objectArray = new Object[]{object};
        if (this.parentAdder != null) {
            this.invokeMethod(this.parentAdder, objectArray);
        }
    }

    private void invokeMethod(Method method, Object[] objectArray) {
        if (this.parentBean == null) {
            return;
        }
        try {
            method.invoke(this.parentBean, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            BeanTableModel.handleITE(invocationTargetException);
        }
    }

    private Object convertArg(String string, Class clazz) {
        if (clazz == String.class) {
            return string;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.valueOf(string);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return Byte.valueOf(string.trim());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Double.valueOf(string.trim());
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.valueOf(string.trim());
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(string.trim());
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Long.valueOf(string.trim());
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return new Character(string.charAt(0));
        }
        throw new IllegalArgumentException("cannot convert String to " + clazz.getName());
    }

    private static void ppp(String string) {
        System.out.println("[BeanTableModel] " + string);
    }
}

