/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weblogic.tools.ui.Util;

public class DualListPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    static final String IMG_BASE_PATH = "/weblogic/tools/ui/graphics/";
    static final String LEFT_PATH = "/weblogic/tools/ui/graphics/arrow_left_enabled.gif";
    static final String RIGHT_PATH = "/weblogic/tools/ui/graphics/arrow_right_enabled.gif";
    private static final int DEFAULT_LIST_HEIGHT = 250;
    protected JList selected = new JList();
    protected JList total;
    protected JButton left;
    protected JButton right;
    protected JLabel selLabel;
    protected JLabel totalLabel;
    protected int m_listHeight = 250;
    private static final int LABEL_LIST_GAP = 2;
    private static final int OUTSIDE_GAP = 5;
    static String[] totalData = new String[]{"Larry", "Moe", "Curly", "Fred", "Wilma", "Barney", "Betty"};
    static String[] selData = new String[]{"Moe", "Curly", "Barney", "Shemp"};

    public DualListPanel(String string, String string2) {
        this.add(this.selected);
        this.total = new JList();
        this.add(this.total);
        this.left = this.makeImageButton(LEFT_PATH);
        this.add(this.left);
        this.right = this.makeImageButton(RIGHT_PATH);
        this.add(this.right);
        this.selLabel = new JLabel(string);
        this.add(this.selLabel);
        this.totalLabel = new JLabel(string2);
        this.add(this.totalLabel);
        this.selLabel.setLabelFor(this.selected);
        this.totalLabel.setLabelFor(this.total);
        this.selected.setBorder(new BevelBorder(1));
        this.total.setBorder(new BevelBorder(1));
        this.left.addActionListener(this);
        this.right.addActionListener(this);
        this.selected.addListSelectionListener(this);
        this.total.addListSelectionListener(this);
        this.total.setSelectionMode(0);
        this.selected.setSelectionMode(0);
        this.syncEnabled();
    }

    public Object[] getUnselected() {
        return DualListPanel.getListData(this.total);
    }

    public Object[] getTotal() {
        Object[] objectArray = this.getSelected();
        Object[] objectArray2 = this.getUnselected();
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    public Object[] getSelected() {
        return DualListPanel.getListData(this.selected);
    }

    public void setTotal(Object[] objectArray) {
        Object[] objectArray2 = this.getSelected();
        Object[] objectArray3 = DualListPanel.computeLeftover(objectArray2, objectArray);
        this.total.setListData(objectArray3);
        Object[] objectArray4 = DualListPanel.removeBadSels(objectArray2, objectArray);
        this.selected.setListData(objectArray4);
    }

    public void setSelected(Object[] objectArray) {
        Object[] objectArray2 = this.getTotal();
        Object[] objectArray3 = DualListPanel.computeLeftover(objectArray, objectArray2);
        this.total.setListData(objectArray3);
        Object[] objectArray4 = DualListPanel.removeBadSels(objectArray, objectArray2);
        this.selected.setListData(objectArray4);
    }

    protected void listsChanged() {
    }

    static Object[] removeBadSels(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (objectArray2 == null) {
            objectArray2 = new Object[]{};
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < objectArray2.length; ++j) {
                if (!objectArray[i].equals(objectArray2[j])) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(objectArray[i]);
        }
        Object[] objectArray3 = new Object[arrayList.size()];
        arrayList.toArray(objectArray3);
        return objectArray3;
    }

    static Object[] computeLeftover(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (objectArray2 == null) {
            objectArray2 = new Object[]{};
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray2.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < objectArray.length; ++j) {
                if (!objectArray2[i].equals(objectArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(objectArray2[i]);
        }
        Object[] objectArray3 = new Object[arrayList.size()];
        arrayList.toArray(objectArray3);
        return objectArray3;
    }

    static Object[] getListData(JList jList) {
        ListModel listModel = jList.getModel();
        ArrayList arrayList = new ArrayList();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            arrayList.add(listModel.getElementAt(i));
        }
        Object[] objectArray = new Object[n];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private void syncEnabled() {
        this.right.setEnabled(!this.selected.isSelectionEmpty());
        this.left.setEnabled(!this.total.isSelectionEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.action(actionEvent);
        }
        finally {
            this.syncEnabled();
        }
    }

    public void setListHeight(int n) {
        this.m_listHeight = n;
    }

    private void action(ActionEvent actionEvent) {
        JList jList;
        JList jList2;
        if (actionEvent.getSource() == this.right) {
            jList2 = this.selected;
            jList = this.total;
        } else {
            jList2 = this.total;
            jList = this.selected;
        }
        int n = jList2.getSelectedIndex();
        if (n == -1) {
            return;
        }
        Object e = jList2.getSelectedValue();
        jList2.setListData(DualListPanel.remove(DualListPanel.getListData(jList2), n));
        jList.setListData(DualListPanel.add(DualListPanel.getListData(jList), e));
        jList2.clearSelection();
        jList.clearSelection();
        int n2 = jList2.getModel().getSize();
        if (n >= n2) {
            n = n2 - 1;
        }
        jList2.setSelectedIndex(n);
        this.listsChanged();
    }

    static Object[] remove(Object[] objectArray, int n) {
        if (n < 0 || n > objectArray.length - 1) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        if (n != objectArray2.length) {
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray2.length - n);
        }
        return objectArray2;
    }

    static Object[] add(Object[] objectArray, Object object) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = object;
        return objectArray2;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.syncEnabled();
    }

    public Dimension getPreferredSize() {
        return this.layout(false);
    }

    public void doLayout() {
        this.layout(true);
    }

    private Dimension layout(boolean bl) {
        Border border = this.getBorder();
        Insets insets = null;
        insets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        int n = insets.left + 5;
        int n2 = insets.left + 5;
        int n3 = insets.top + 5;
        int n4 = insets.bottom + 5;
        Dimension dimension = null;
        int n5 = 100;
        int n6 = this.m_listHeight;
        n5 = Math.max(this.selLabel.getPreferredSize().width, n5);
        n5 = Math.max(this.totalLabel.getPreferredSize().width, n5);
        dimension = this.selected.getPreferredSize();
        n5 = Math.max(n5, dimension.width);
        if (n6 == 250) {
            n6 = Math.max(n6, dimension.height);
        }
        dimension = this.total.getPreferredSize();
        n5 = Math.max(n5, dimension.width);
        if (n6 == 250) {
            n6 = Math.max(n6, dimension.height);
        }
        n6 = Math.min(n6, 500);
        int n7 = this.selLabel.getPreferredSize().height;
        n7 = Math.max(this.totalLabel.getPreferredSize().height, n7);
        dimension = this.selLabel.getPreferredSize();
        if (bl) {
            this.selLabel.setBounds(n, n3, dimension.width, dimension.height);
        }
        int n8 = n3 + dimension.height + 2;
        if (bl) {
            this.selected.setBounds(n, n8, n5, n6);
        }
        int n9 = this.left.getPreferredSize().width;
        n9 = Math.max(this.right.getPreferredSize().width, n9);
        n9 += 10;
        dimension = this.totalLabel.getPreferredSize();
        if (bl) {
            this.totalLabel.setBounds(n + n5 + n9, n3, dimension.width, dimension.height);
            this.total.setBounds(n + n5 + n9, n8, n5, n6);
        }
        int n10 = 10;
        dimension = this.left.getPreferredSize();
        int n11 = dimension.width;
        int n12 = dimension.height;
        int n13 = n + n5 + 5;
        int n14 = n8 + n6 / 2 - n12 - n10 / 2;
        if (bl) {
            this.right.setBounds(n13, n14, n11, n12);
        }
        n14 = n8 + n6 / 2 + n10 / 2;
        if (bl) {
            this.left.setBounds(n13, n14, n11, n12);
            return null;
        }
        Dimension dimension2 = new Dimension();
        dimension2.width = 0;
        dimension2.width += n;
        dimension2.width += n5 * 2;
        dimension2.width += n9;
        dimension2.width += n2;
        dimension2.height = 0;
        dimension2.height += n3;
        dimension2.height += n7;
        dimension2.height += 2;
        dimension2.height += n6;
        dimension2.height += n4;
        return dimension2;
    }

    private static void p(String string) {
        System.err.println("[DualListPanel]: " + string);
    }

    private JButton makeImageButton(String string) {
        ImageIcon imageIcon = new ImageIcon(Util.loadImage(string));
        JButton jButton = new JButton(imageIcon);
        Dimension dimension = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        jButton.setPreferredSize(dimension);
        return jButton;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("test");
        DualListPanel dualListPanel = new DualListPanel("Selected", "Available");
        dualListPanel.setTotal(totalData);
        dualListPanel.setSelected(selData);
        dualListPanel.setBorder(new TitledBorder("Widget Test"));
        jFrame.getContentPane().add(dualListPanel);
        jFrame.setLocation(100, 100);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

