/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.border.Border;

class ExArea
extends JTextArea {
    char[][] vals;
    int W;
    int H;
    int fh;
    static final int PAD = 10;
    boolean want2BeSeen = false;
    boolean outOfCTOR = false;
    static final int MAX_W = 600;
    static final int MAX_H = 600;

    public ExArea(String string) {
        super(string);
        this.parseStackTrace(string);
        this.setEditable(false);
        this.outOfCTOR = true;
        this.setCaretPosition(0);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.outOfCTOR) {
            this.parseStackTrace(this.getText());
        }
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        if (this.outOfCTOR) {
            this.parseStackTrace(this.getText());
        }
    }

    private void parseStackTrace(String string) {
        Font font = this.getFont();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t\n\r", false);
        this.vals = new char[stringTokenizer.countTokens()][];
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.fh = fontMetrics.getHeight();
        this.H = 0;
        this.W = 0;
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = i == 0 ? stringTokenizer.nextToken().toCharArray() : ("  " + stringTokenizer.nextToken()).toCharArray();
            this.W = Math.max(this.W, fontMetrics.charsWidth(this.vals[i], 0, this.vals[i].length));
            this.H += this.fh;
        }
        this.H += 40;
        this.W += 40;
        this.W = Math.min(this.W, 600);
        this.H = Math.min(this.H, 600);
        Border border = this.getBorder();
        if (border == null) {
            return;
        }
        Insets insets = border.getBorderInsets(this);
        if (insets == null) {
            return;
        }
        this.H += insets.top + insets.bottom;
        this.W += insets.left + insets.right;
    }

    static void p(String string) {
        System.err.println("[ExArea]: " + string);
    }
}

