/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import weblogic.tools.ui.ExArea;
import weblogic.tools.ui.MarathonTextFormatter;
import weblogic.tools.ui.Util;
import weblogic.utils.StackTraceUtils;

public class ExceptionDialog
extends JDialog
implements ActionListener,
WindowListener,
KeyListener {
    private static MarathonTextFormatter fmt = new MarathonTextFormatter();
    JLabel m_messageLabel = null;
    JButton ok;
    JButton details;
    ExArea ex;
    JScrollPane sp;

    public static void showExceptionDialog(Component component, String string, Throwable throwable, boolean bl) {
        String string2 = bl ? throwable.toString() : throwable.getClass().getName();
        JOptionPane.showMessageDialog(component, string2, string, 2);
    }

    public ExceptionDialog(Frame frame, String string, Throwable throwable) {
        this(frame, string, throwable, null, false);
    }

    public ExceptionDialog(Frame frame, String string, Throwable throwable, String string2) {
        this(frame, string, throwable, string2, false);
    }

    public void show() {
        this.ok.requestFocus();
        super.show();
    }

    public ExceptionDialog(Frame frame, String string, Throwable throwable, String string2, boolean bl) {
        super(frame, string, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().setLayout(gridBagLayout);
        URL uRL = ExceptionDialog.getResourceURL("/com/sun/java/swing/plaf/windows/icons/Error.gif");
        String string3 = null;
        string3 = bl ? throwable.toString() : throwable.getClass().getName();
        if (uRL != null) {
            this.m_messageLabel = new JLabel(string3, new ImageIcon(uRL), 2);
            this.m_messageLabel.setIconTextGap(11);
        } else {
            this.m_messageLabel = new JLabel(string3);
        }
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.m_messageLabel, gridBagConstraints);
        this.getContentPane().add(this.m_messageLabel);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        JComponent jComponent = this.makeButtons();
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.getContentPane().add(jComponent);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.ex = new ExArea(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        this.ex.setVisible(false);
        final ExceptionDialog exceptionDialog = this;
        EmptyBorder emptyBorder = new EmptyBorder(11, 11, 11, 11){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Color color = graphics.getColor();
                graphics.setColor(exceptionDialog.getBackground());
                graphics.translate(n, n2);
                graphics.fillRect(n, n2, n3, this.top);
                graphics.fillRect(n, n2, this.left, n4);
                graphics.fillRect(n, n4 - this.bottom, n3, this.bottom);
                graphics.fillRect(n3 - this.right, n2, this.right, n4);
                graphics.setColor(color);
            }
        };
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, new BevelBorder(1));
        final ExArea exArea = this.ex;
        this.sp = new JScrollPane(this.ex){

            public Dimension getPreferredSize() {
                Dimension dimension;
                if (exArea.isVisible()) {
                    JScrollBar jScrollBar = this.getHorizontalScrollBar();
                    int n = jScrollBar.getPreferredSize().height;
                    dimension = new Dimension(exArea.W, exArea.H + 2 * n);
                } else {
                    dimension = new Dimension(exArea.W, 0);
                }
                return dimension;
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.sp.setBorder(compoundBorder);
        this.getContentPane().add(this.sp);
        this.setResizable(false);
        this.addWindowListener(this);
        this.pack();
        int n = this.sp.getPreferredSize().width;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        n = (dimension.width - dimension2.width) / 2;
        int n2 = Math.max((dimension.height - dimension2.height) / 2 - 100, 100);
        this.setLocation(new Point(n, n2));
    }

    public void setMessage(String string) {
        this.m_messageLabel.setText(string);
    }

    private JComponent makeButtons() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.ok = new JButton(fmt.getContinue());
        this.ok.addKeyListener(this);
        this.ok.setOpaque(false);
        this.ok.addActionListener(this);
        jPanel.add((Component)this.ok, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.details = new JButton(fmt.getShowDetails());
        this.details.setOpaque(false);
        this.details.addActionListener(this);
        jPanel.add((Component)this.details, gridBagConstraints);
        return jPanel;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = this.sp.getPreferredSize().width;
        if (!this.ex.isVisible()) {
            n += 6;
        }
        dimension.width = Math.max(dimension.width, n);
        return dimension;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.setVisible(false);
            this.dispose();
        } else if (object == this.details) {
            if (!this.ex.isVisible()) {
                this.details.setLabel(fmt.getHideDetails());
                this.ex.setVisible(true);
            } else {
                this.details.setLabel(fmt.getShowDetails());
                this.ex.setVisible(false);
            }
            this.invalidate();
            this.pack();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        block5: {
            block4: {
                if (keyEvent.getSource() != this.ok) {
                    return;
                }
                if (keyEvent.getKeyCode() == 10) break block4;
                if (keyEvent.getKeyChar() != '\n' && keyEvent.getKeyChar() != '\r') break block5;
            }
            this.setVisible(false);
            this.dispose();
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static URL getResourceURL(String string) {
        URL uRL = ExceptionDialog.class.getResource(string);
        if (uRL == null) {
            uRL = ExceptionDialog.class.getResource("/weblogic/graphics/" + string);
        }
        return uRL;
    }

    public static void main(String[] stringArray) throws Exception {
        Util.initLookAndFeel("win");
        String[] stringArray2 = new String[]{"Foo", "Bar", "Baz"};
        JFrame jFrame = new JFrame("test");
        JList<String> jList = new JList<String>();
        jList.setListData(stringArray2);
        jFrame.getContentPane().add(jList);
        jFrame.setSize(300, 300);
        jFrame.setVisible(true);
        try {
            ExceptionDialog.deep(0, 20);
        }
        catch (Exception exception) {
            ExceptionDialog exceptionDialog = new ExceptionDialog((Frame)jFrame, "Error", exception);
            exceptionDialog.show();
        }
    }

    private static void deep(int n, int n2) throws Exception {
        if (++n >= n2) {
            String string = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD";
            throw new Exception(string);
        }
        ExceptionDialog.deep(n, n2);
    }
}

