/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.io.OutputStream;
import javax.swing.JTextArea;
import weblogic.tools.ui.GUIPrintFrame;

public class GUIPrintStream
extends OutputStream {
    static final String nl = "\n";
    JTextArea t;
    private static final int MAX_CHARS = 50000;
    private int maxChars;

    void newLine() {
        this.write(nl);
    }

    protected void write(String string) {
        if (this.t.getText().length() + string.length() >= this.maxChars) {
            this.t.setText("****<truncated buffer>***\n");
        }
        this.t.append(string);
    }

    public static void main(String[] stringArray) throws Exception {
        new GUIPrintFrame("Stdout/Stderr").run();
    }

    public GUIPrintStream(JTextArea jTextArea) {
        this.t = jTextArea;
        this.maxChars = 50000;
    }

    public void setMaxChars(int n) {
        this.maxChars = n;
    }

    public void write(int n) {
        this.write(String.valueOf((char)n));
    }

    public void write(byte[] byArray, int n, int n2) {
        String string = new String(byArray, 0, n, n2);
        this.write(string);
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.print(new String(cArray));
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.write(nl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(bl);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(c);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(n);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(l);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(f);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(d);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(cArray);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(string);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        GUIPrintStream gUIPrintStream = this;
        synchronized (gUIPrintStream) {
            this.print(object);
            this.newLine();
        }
    }
}

