/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import weblogic.tools.ui.ComponentDescription;
import weblogic.tools.ui.NumberBox;
import weblogic.utils.Debug;

public class KeyValueLayout
implements LayoutManager {
    public static final String KEY = "Key";
    public static final String VALUE = "Value";
    public static final String CHOOSER = "Chooser";
    private boolean m_verbose = false;
    public static int VERTICAL_GAP = 5;
    public static int TOP_GAP = 5;
    public static int BOTTOM_GAP = 15;
    public static int LEFT_GAP = 10;
    public static int RIGHT_GAP = 10;
    public static int LABEL_WIDGET_OFFSET = 6;
    public static int CHOOSER_GAP = 5;
    private int HEIGHT = 20;
    private HashMap m_components = new HashMap();
    private ComponentDescription m_currentComponentDescription = null;

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = LEFT_GAP + insets.left;
        int n2 = TOP_GAP + insets.top;
        int n3 = 5;
        int n4 = 5;
        int n5 = (int)container.getSize().getWidth() - LEFT_GAP - RIGHT_GAP - insets.left - insets.right;
        int n6 = this.HEIGHT;
        int n7 = this.HEIGHT;
        int n8 = container.countComponents();
        String string = null;
        for (int i = 0; i < n8; ++i) {
            String string2;
            Component component = container.getComponent(i);
            n6 = (int)component.getPreferredSize().getHeight();
            if (i + 1 < n8) {
                string = (String)this.m_components.get(container.getComponent(i + 1));
            }
            Debug.assertion((null != (string2 = (String)this.m_components.get(component)) ? 1 : 0) != 0, (String)("KeyValueLayout: no constraint was specified for component " + component.getClass()));
            if (KEY.equals(string2)) {
                this.resizeComponent(component, string2, n, n2, n5, n6);
                n2 += n6 + VERTICAL_GAP - LABEL_WIDGET_OFFSET;
                continue;
            }
            if (VALUE.equals(string2)) {
                n7 = n6;
                if (CHOOSER.equals(string)) {
                    JComponent jComponent = (JComponent)container.getComponent(i + 1);
                    int n9 = (int)jComponent.getPreferredSize().getWidth();
                    this.resizeComponent(component, string2, n, n2, n5 - n9 - CHOOSER_GAP, n6);
                    continue;
                }
                this.resizeComponent(component, string2, n, n2, n5, n6);
                string = null;
                n2 += n6 + VERTICAL_GAP;
                continue;
            }
            int n10 = (int)component.getPreferredSize().getWidth();
            this.resizeComponent(component, string2, n + n5 - n10, n2, n10, n7);
            n2 += n7 + VERTICAL_GAP;
        }
    }

    private void resizeComponent(Component component, String string, int n, int n2, double d, double d2) {
        component.setBounds(n, n2, (int)d, (int)d2);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.minimumLayoutSize(container);
        return dimension;
    }

    private int getMinimumHeight(Container container, int n) {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        int n2;
        boolean bl = false;
        int n3 = 0;
        int n4 = container.countComponents();
        for (n2 = 0; n2 < n4; ++n2) {
            Insets insets;
            Border border;
            serializable2 = container.getComponent(n2);
            object = (String)this.m_components.get(serializable2);
            if (!CHOOSER.equals(object)) {
                n3 += (int)((Component)serializable2).getPreferredSize().getHeight();
            }
            if (!(serializable2 instanceof JComponent) || (border = ((JComponent)(serializable = (JComponent)serializable2)).getBorder()) == null || (insets = border.getBorderInsets((Component)serializable)) == null) continue;
            n3 += insets.top;
            n3 += insets.bottom;
        }
        n2 = n3;
        serializable2 = container.getInsets();
        if (container instanceof JComponent && null != (object = ((JComponent)container).getBorder()) && null != (serializable = object.getBorderInsets(container))) {
            n2 += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        return n2 + BOTTOM_GAP + TOP_GAP;
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = container.countComponents();
        Dimension dimension = new Dimension(100, this.getMinimumHeight(container, n));
        return dimension;
    }

    public void addLayoutComponent(String string, Component component) {
        this.m_components.put(component, string);
    }

    public void removeLayoutComponent(Component component) {
    }

    private void log(String string) {
        if (this.m_verbose) {
            System.out.println("[KeyValueLayout] " + string);
        }
    }

    private static void ppp(String string) {
        System.out.println("[KeyValueLayout] " + string);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test KeyValue");
        JPanel jPanel = new JPanel(new KeyValueLayout());
        JLabel jLabel = new JLabel("Last Name:");
        JTextField jTextField = new JTextField(30);
        JButton jButton = new JButton("...");
        jPanel.add((Component)jLabel, KEY);
        jPanel.add((Component)jTextField, VALUE);
        jPanel.add((Component)new JLabel("First name"), KEY);
        jPanel.add(new JComboBox(), VALUE);
        jPanel.add((Component)new JLabel("First name"), KEY);
        jPanel.add(new JComboBox(), VALUE);
        jPanel.add((Component)new JLabel("First name"), KEY);
        jPanel.add(new JComboBox(), VALUE);
        jPanel.add((Component)new JCheckBox("Toggle"), KEY);
        for (int i = 0; i < 9; ++i) {
            jPanel.add((Component)new JLabel("Age"), KEY);
            jPanel.add((Component)new NumberBox(1, 100, 30), VALUE);
        }
        jPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Test"));
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

