/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Component;
import java.beans.PropertyDescriptor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import weblogic.tools.ui.Property;
import weblogic.tools.ui.SortedComboBox;

public class ListProperty
extends Property {
    JComboBox jc;
    boolean selectFirstElement = false;
    boolean allowEditing = false;
    JTextField editor;

    public ListProperty(Object object, PropertyDescriptor propertyDescriptor, String string, String[] stringArray, boolean bl) {
        super(object, propertyDescriptor, string, bl);
        this.jc = new SortedComboBox(stringArray);
        this.jc.addFocusListener(this);
        Component component = this.jc.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            this.editor = (JTextField)component;
        }
    }

    public ListProperty(PropertyDescriptor propertyDescriptor, String string, String[] stringArray, boolean bl) {
        this(null, propertyDescriptor, string, stringArray, bl);
    }

    public boolean isUIEmpty() {
        String string;
        if (this.allowEditing && (string = this.editor.getText()) != null && (string = string.trim()).length() > 0) {
            return false;
        }
        return this.jc.getSelectedIndex() == -1;
    }

    public Component getComponent() {
        return this.jc;
    }

    public void setAllowEditing(boolean bl) {
        this.allowEditing = bl;
        this.jc.setEditable(this.allowEditing);
    }

    public boolean getAllowEditing() {
        return this.allowEditing;
    }

    public Object getCurrentUIValue() {
        if (this.allowEditing) {
            String string = this.editor.getText();
            if (string != null && (string = string.trim()).length() == 0) {
                string = null;
            }
            return string;
        }
        Object object = this.jc.getSelectedItem();
        if (object != null) {
            return object;
        }
        this.jc.setSelectedIndex(-1);
        return this.jc.getSelectedItem();
    }

    public void setSelectFirstElement(boolean bl) {
        this.selectFirstElement = bl;
    }

    public boolean getSelectFirstElement() {
        return this.selectFirstElement;
    }

    public void setCurrentUIValue(Object object) {
        this.jc.setSelectedItem(object);
        if (this.jc.getSelectedItem() == null) {
            if (this.getSelectFirstElement() && this.jc.getItemCount() > 0) {
                this.jc.setSelectedIndex(0);
            } else {
                this.jc.setSelectedIndex(-1);
            }
        }
    }
}

