/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicToolTipUI;

class MultiLineToolTipUI
extends BasicToolTipUI {
    private String[] strs;
    private int maxWidth = 0;

    MultiLineToolTipUI() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = graphics.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.getHeight();
        Dimension dimension = jComponent.getSize();
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(jComponent.getForeground());
        if (this.strs != null) {
            for (int i = 0; i < this.strs.length; ++i) {
                graphics.drawString(this.strs[i], 3, n * (i + 1));
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n;
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                n = SwingUtilities.computeStringWidth(fontMetrics, string2);
                n2 = n2 < n ? n : n2;
                vector.addElement(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n3 = vector.size();
        if (n3 < 1) {
            this.strs = null;
            n3 = 1;
        } else {
            this.strs = new String[n3];
            vector.copyInto(this.strs);
        }
        n = fontMetrics.getHeight() * n3;
        this.maxWidth = n2;
        return new Dimension(n2 + 6, n + 6);
    }
}

