/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import weblogic.utils.Debug;

public class MyModel
extends AbstractTableModel {
    private boolean targetIsString;
    private HashMap m_map = null;
    Object bean;
    Class bc;
    Method reader;
    Method writer;
    Class propType;
    boolean autoCommit = true;
    Object[] tmpModel;
    private static final Object[] NO_ARGS = new Object[0];

    private static void p(String string) {
        System.err.println("[ListModel]: " + string);
    }

    public MyModel(Class clazz, Object object, String string) {
        this.bc = clazz;
        this.bean = object;
        try {
            this.reader = this.getMethod("get" + string);
            this.writer = this.getMethod("set" + string);
            Class<?>[] classArray = this.writer.getParameterTypes();
            this.propType = classArray[0].getComponentType();
            boolean bl = this.targetIsString = this.propType == String.class;
            if (!this.targetIsString) {
                this.m_map = new HashMap();
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl) {
        this.tmpModel = !bl ? this.getStrings() : null;
        this.autoCommit = bl;
    }

    public void modelToUI() {
        this.fireTableDataChanged();
    }

    public void uiToModel() {
        if (!this.isAutoCommit()) {
            this.invokeSetter(this.tmpModel);
        }
    }

    public Object getValueAt(int n, int n2) {
        return n2 == 0 ? this.getElementAt(n) : null;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.targetIsString;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 0) {
            return;
        }
        Object[] objectArray = this.getStrings();
        if (n >= 0 && n < objectArray.length) {
            objectArray[n] = object;
            this.setStrings(objectArray);
        }
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public Object getElementAt(int n) {
        Object[] objectArray = this.getStrings();
        if (n < 0 || n >= objectArray.length) {
            return null;
        }
        return objectArray[n];
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this.getStrings().length;
    }

    public int getSize() {
        return this.getStrings().length;
    }

    public void swap(int n) {
        Object[] objectArray = this.getStrings();
        Object object = objectArray[n - 1];
        objectArray[n - 1] = objectArray[n];
        objectArray[n] = object;
        this.setStrings(objectArray);
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void remove(int n) {
        Object[] objectArray = this.getStrings();
        Object[] objectArray2 = new String[objectArray.length - 1];
        if (n != 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n != objectArray2.length) {
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray2.length - n);
        }
        this.setStrings(objectArray2);
        this.fireTableRowsDeleted(n, n);
        this.fireTableStructureChanged();
    }

    public void add(Object object) {
        Object[] objectArray = this.getStrings();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = object;
        if (!this.targetIsString) {
            this.m_map.put(object.toString(), object);
        }
        this.setStrings(objectArray2);
        this.fireTableRowsUpdated(objectArray.length, objectArray.length);
    }

    public void setBean(Object object) {
        int n = this.getSize();
        this.fireTableRowsDeleted(0, n);
        this.bean = object;
        if (!this.isAutoCommit()) {
            this.tmpModel = this.invokeGetter();
        }
        n = this.getSize();
        this.fireTableRowsInserted(0, n);
    }

    void setStrings(Object[] objectArray) {
        if (objectArray == null) {
            objectArray = (Object[])Array.newInstance(this.propType, 0);
        }
        if (!this.isAutoCommit()) {
            this.tmpModel = (Object[])objectArray.clone();
            return;
        }
        this.invokeSetter(objectArray);
    }

    private void invokeSetter(Object[] objectArray) {
        Object[] objectArray2;
        if (objectArray == null) {
            objectArray = (Object[])Array.newInstance(this.propType, 0);
        }
        Object[] objectArray3 = new Object[1];
        Class<?> clazz = null;
        if (this.targetIsString) {
            clazz = String.class;
        } else {
            if (objectArray.length > 0) {
                clazz = this.m_map.get(objectArray[0].toString()).getClass();
            }
            if (clazz == null) {
                clazz = this.propType;
            }
        }
        Object object = Array.newInstance(clazz, objectArray.length);
        if (this.targetIsString) {
            objectArray2 = (String[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = (String)objectArray[i];
            }
            objectArray3[0] = objectArray2;
        } else {
            objectArray2 = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.m_map.get(objectArray[i].toString());
                Debug.assertion((null != objectArray2[i] ? 1 : 0) != 0, (String)("Couldn't find object " + objectArray[i]));
            }
            objectArray3[0] = objectArray2;
        }
        try {
            this.writer.invoke(this.bean, objectArray3);
        }
        catch (InvocationTargetException invocationTargetException) {
            MyModel.handleITE(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    Object[] getStrings() {
        if (!this.isAutoCommit()) {
            return (Object[])this.tmpModel.clone();
        }
        if (this.bean == null) {
            return new String[0];
        }
        return this.invokeGetter();
    }

    private Object[] invokeGetter() {
        try {
            Object object = this.reader.invoke(this.bean, NO_ARGS);
            if (object == null) {
                return new String[0];
            }
            if (this.targetIsString) {
                String[] stringArray = (String[])object;
                return (String[])stringArray.clone();
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i].toString();
                this.m_map.put(((String)objectArray2[i]).toString(), objectArray[i]);
            }
            return objectArray2;
        }
        catch (InvocationTargetException invocationTargetException) {
            MyModel.handleITE(invocationTargetException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    private static void handleITE(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable.toString());
    }

    private Method getMethod(String string) throws NoSuchMethodException {
        return MyModel.getMethod(this.bc, string);
    }

    public static Method getMethod(Class clazz, String string) throws NoSuchMethodException {
        Method[] methodArray = clazz.getDeclaredMethods();
        Class<?>[] classArray = null;
        for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
            Method method;
            int n;
            if (!methodArray[i].getName().equalsIgnoreCase(string) || ((n = (method = methodArray[i]).getModifiers()) & 1) == 0) continue;
            classArray = method.getParameterTypes();
            if (string.startsWith("set")) {
                if (classArray == null || classArray.length != 1 || !classArray[0].isArray()) continue;
                return method;
            }
            if (classArray != null && classArray.length != 0 && (classArray.length != 1 || classArray[0] != Void.TYPE)) continue;
            return method;
        }
        String string2 = "cannot find appropriate method " + clazz.getName() + "." + string + "(" + (null != classArray ? classArray.getClass().toString() : ") ");
        throw new IllegalArgumentException(string2);
    }
}

