/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import weblogic.tools.ui.ArrowButton;
import weblogic.tools.ui.UIFactory;
import weblogic.tools.ui.Util;

public class NumberBox
extends JPanel
implements ActionListener,
KeyListener,
FocusListener,
InputMethodListener {
    public static String PROPERTY_VALUE = "Value";
    JTextField tf;
    ArrowButton up;
    ArrowButton down;
    private int min = 0;
    private int max = Integer.MAX_VALUE;
    private int val = 0;
    private int inc = 1;
    PropertyChangeSupport pcs = null;
    private static final int BUTTON_WIDTH = 14;
    private static final int BUTTON_HEIGHT = 8;
    boolean inFL = false;

    public NumberBox(int n, int n2, int n3, int n4) {
        this();
        this.min = n;
        this.max = n2;
        this.setValue(n3);
        this.inc = n4;
        double d = n2;
        int n5 = (int)Math.ceil(Math.log(d) / Math.log(10.0));
        this.tf.setColumns(n5);
    }

    public NumberBox(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }

    public NumberBox() {
        super(new GridBagLayout());
        this.init();
    }

    private void setNoDraw(int n) {
        int n2 = this.val;
        this.val = n;
        this.pcs.firePropertyChange(PROPERTY_VALUE, n2, this.val);
    }

    private void justSet(int n) {
        this.setNoDraw(n);
        String string = String.valueOf(this.val);
        this.tf.setText(string);
        this.tf.setCaretPosition(string.length());
    }

    public void setValue(int n) {
        if (n <= this.max && n >= this.min) {
            this.justSet(n);
        }
    }

    public int getValue() {
        return this.val;
    }

    public void setMin(int n) {
        if (n < this.max) {
            this.min = n;
            this.adjustToBounds();
        }
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int n) {
        if (n > this.min) {
            this.adjustToBounds();
        }
        double d = n;
        int n2 = (int)Math.ceil(Math.log(d) / Math.log(10.0));
        this.tf.setColumns(n2);
        this.doLayout();
    }

    public int getMax() {
        return this.max;
    }

    public void setIncrement(int n) {
        this.inc = n;
    }

    public int getIncrement() {
        return this.inc;
    }

    public void setTextBackground(Color color) {
        this.tf.setBackground(color);
    }

    protected void illegalValueHook() {
        String string = "A value between " + this.getMin() + " and " + this.getMax() + " must be entered.";
        JOptionPane.showMessageDialog(this, string, "Illegal number", 2);
        if (this.getValue() < this.getMin()) {
            this.setValue(this.getMin());
        } else if (this.getValue() < this.getMax()) {
            this.setValue(this.getMax());
        }
        this.requestFocus();
    }

    public void setEditable(boolean bl) {
        this.tf.setEditable(bl);
    }

    private void init() {
        this.pcs = new PropertyChangeSupport(this);
        this.setOpaque(false);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tf = UIFactory.getTextField("");
        this.tf.setColumns(10);
        Border border = this.tf.getBorder();
        this.setBorder(border);
        this.tf.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tf.addKeyListener(this);
        this.tf.addFocusListener(this);
        this.tf.addActionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.tf, gridBagConstraints);
        this.add(this.tf);
        this.up = new ArrowButton(1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        this.up.addActionListener(this);
        this.up.addKeyListener(this);
        this.up.setFocusTraversable(false);
        gridBagLayout.setConstraints(this.up, gridBagConstraints);
        this.add(this.up);
        gridBagConstraints.gridy = 1;
        this.down = new ArrowButton(5);
        this.down.addActionListener(this);
        this.down.addKeyListener(this);
        this.down.setFocusTraversable(false);
        gridBagLayout.setConstraints(this.down, gridBagConstraints);
        this.add(this.down);
        Dimension dimension = new Dimension(14, 8);
        this.up.setPreferredSize(dimension);
        this.down.setPreferredSize(dimension);
    }

    public void doLayout() {
        Cloneable cloneable;
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = dimension.width;
        int n4 = dimension.height;
        Border border = this.getBorder();
        if (border != null) {
            cloneable = border.getBorderInsets(this);
            n += cloneable.left;
            n2 += cloneable.top;
            n3 -= cloneable.right;
            n4 -= cloneable.bottom;
        }
        cloneable = this.up.getPreferredSize();
        Dimension dimension2 = this.tf.getPreferredSize();
        int n5 = n3 - ((Dimension)cloneable).width;
        int n6 = n2;
        int n7 = ((Dimension)cloneable).width;
        int n8 = (n4 - n2) / 2;
        this.up.setBounds(n5, n6, n7, n8);
        this.down.setBounds(n5, n6 += n8, n7, n8);
        n7 = n3 - n7 - n;
        n8 = n4 - n2;
        this.tf.setBounds(n, n2, n7, n8);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setEnabled(boolean bl) {
        this.tf.setEnabled(bl);
        this.up.setEnabled(bl);
        this.down.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setToolTipText(String string) {
        this.tf.setToolTipText(string);
        this.up.setToolTipText(string);
        this.down.setToolTipText(string);
        super.setToolTipText(string);
    }

    public void requestFocus() {
        this.tf.requestFocus();
    }

    private void adjustToBounds() {
        if (this.val > this.min) {
            this.justSet(this.min);
        } else if (this.val > this.max) {
            this.justSet(this.max);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.up) {
            if (this.val + this.inc <= this.max && this.val + this.inc >= this.min) {
                this.justSet(this.val + this.inc);
            }
        } else if (object == this.down) {
            if (this.val - this.inc >= this.min && this.val - this.inc <= this.max) {
                this.justSet(this.val - this.inc);
            }
        } else if (object == this.tf && (this.getValue() > this.getMax() || this.getValue() < this.getMin())) {
            this.illegalValueHook();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusLost(FocusEvent focusEvent) {
        if (this.inFL) {
            return;
        }
        try {
            this.inFL = true;
            String string = this.tf.getText();
            if (string == null || string.length() == 0) {
                this.justSet(this.getMin());
            } else {
                this.justSet(this.getInt(string));
            }
            if (this.getValue() > this.getMax() || this.getValue() < this.getMin()) {
                this.illegalValueHook();
            }
        }
        finally {
            this.inFL = false;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38) {
            this.justSet(this.getValue() + this.inc);
            keyEvent.consume();
        } else if (n == 40) {
            this.justSet(this.getValue() - this.inc);
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    /*
     * Unable to fully structure code
     */
    public void keyTyped(KeyEvent var1_1) {
        block9: {
            block8: {
                var2_2 = this.tf.getCaretPosition();
                var3_3 = var1_1.getKeyChar();
                if (var3_3 != '-') break block8;
                var4_4 = this.tf.getText();
                if ("".equals(var4_4) || "0".equals(var4_4)) {
                    this.tf.setText("-");
                }
                break block9;
            }
            if (var3_3 == '\b') ** GOTO lbl-1000
            if (var3_3 == '\u007f') lbl-1000:
            // 2 sources

            {
                var4_5 = this.tf.getSelectionStart();
                var5_7 = this.tf.getSelectionEnd();
                var6_9 = this.clearSelection();
                if (var4_5 >= var5_7 && var6_9[0].length() > 0) {
                    var6_9[0] = var6_9[0].substring(0, var6_9[0].length() - 1);
                }
                var7_11 = var6_9[0] + var6_9[1];
                this.tf.setText(var7_11);
                this.tf.setCaretPosition(var6_9[0].length());
            } else if (Character.isDigit(var3_3)) {
                var4_6 = this.tf.getText();
                var5_8 = this.clearSelection();
                var6_10 = var5_8[0] + var3_3 + var5_8[1];
                try {
                    this.getInt(var6_10);
                    this.tf.setText(var6_10);
                }
                catch (NumberFormatException var7_12) {
                    var1_1.consume();
                    return;
                }
                var2_2 = var5_8[0].length() + 1;
                var7_13 = this.tf.getText().length();
                if (var2_2 > var7_13) {
                    var2_2 = var7_13;
                }
                this.tf.setCaretPosition(var2_2);
            }
        }
        var1_1.consume();
    }

    private String[] clearSelection() {
        int n;
        String[] stringArray = new String[2];
        String string = this.tf.getText();
        int n2 = this.tf.getCaretPosition();
        int n3 = this.tf.getSelectionStart();
        if (n3 >= (n = this.tf.getSelectionEnd())) {
            stringArray[0] = string.substring(0, n2);
            stringArray[1] = string.substring(n2);
            return stringArray;
        }
        stringArray[0] = string.substring(0, n3);
        stringArray[1] = string.substring(n);
        string = stringArray[0] + stringArray[1];
        this.tf.setText(string);
        n = Math.min(n, string.length());
        this.tf.setCaretPosition(n);
        return stringArray;
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
    }

    private int getInt(String string) {
        int n = 0;
        if (string != null && (string = string.trim()).length() > 0) {
            if (string.equals("-")) {
                return 0;
            }
            long l = Long.parseLong(string);
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new NumberFormatException("out of range: " + string);
            }
            n = Integer.parseInt(string);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Util.initLookAndFeel("win");
        JFrame jFrame = new JFrame("Number Box Test");
        NumberBox numberBox = new NumberBox();
        numberBox.setMin(0);
        numberBox.setMax(1000);
        numberBox.setValue(50);
        Container container = jFrame.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel = new JLabel("min " + numberBox.getMin());
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        gridBagConstraints.gridx = 1;
        jLabel = new JLabel("max " + numberBox.getMax());
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(numberBox, gridBagConstraints);
        container.add(numberBox);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        jFrame.addWindowListener(windowAdapter);
        jFrame.setSize(300, 300);
        jFrame.setVisible(true);
    }

    private void p(String string) {
        System.err.println("[NumBox (min=" + this.getMin() + " val=" + this.getValue() + ")]: " + string);
    }
}

